/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerReachable;
import net.tomp2p.p2p.PeerReceivedBroadcastPing;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PingRPC.class);
    public static final int WAIT_TIME = 10000;
    private final List<PeerReachable> reachableListeners = new ArrayList<PeerReachable>(1);
    private final List<PeerReceivedBroadcastPing> receivedBroadcastPingListeners = new ArrayList<PeerReceivedBroadcastPing>(1);
    private final boolean enable;
    private final boolean wait;

    public PingRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        this(peerBean, connectionBean, true, true, false);
    }

    PingRPC(PeerBean peerBean, ConnectionBean connectionBean, boolean enable, boolean register, boolean wait) {
        super(peerBean, connectionBean);
        this.enable = enable;
        this.wait = wait;
        if (register) {
            connectionBean.dispatcher().registerIoHandler(peerBean.serverPeerAddress().peerId(), peerBean.serverPeerAddress().peerId(), this, RPC.Commands.PING.getNr());
        }
    }

    public RequestHandler<FutureResponse> ping(PeerAddress remotePeer, ConnectionConfiguration configuration) {
        return this.createHandler(remotePeer, Message.Type.REQUEST_1, configuration);
    }

    public FutureResponse pingUDP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        return this.ping(remotePeer, configuration).sendUDP(channelCreator);
    }

    public FutureResponse pingBroadcastUDP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        return this.createHandler(remotePeer, Message.Type.REQUEST_4, configuration).sendBroadcastUDP(channelCreator);
    }

    public FutureResponse pingTCP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        LOG.debug("ping the remote peer {}", (Object)remotePeer);
        return this.ping(remotePeer, configuration).sendTCP(channelCreator);
    }

    public FutureResponse fireUDP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        return this.createHandler(remotePeer, Message.Type.REQUEST_FF_1, configuration).fireAndForgetUDP(channelCreator);
    }

    public FutureResponse fireTCP(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        return this.createHandler(remotePeer, Message.Type.REQUEST_FF_1, configuration).sendTCP(channelCreator);
    }

    public FutureResponse pingUDPDiscover(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        FutureResponse futureResponse = this.createDiscoverHandler(remotePeer);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration).sendUDP(channelCreator);
    }

    public FutureResponse pingTCPDiscover(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        FutureResponse futureResponse = this.createDiscoverHandler(remotePeer);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration).sendTCP(channelCreator);
    }

    public FutureResponse pingUDPProbe(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), Message.Type.REQUEST_3);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration).sendUDP(channelCreator);
    }

    public FutureResponse pingTCPProbe(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), Message.Type.REQUEST_3);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration).sendTCP(channelCreator);
    }

    public FutureDone<List<PeerSocketAddress>> pingNATType(PeerAddress remotePeer, ChannelCreator channelCreator, ConnectionConfiguration configuration, final Peer peer) {
        final FutureDone<List<PeerSocketAddress>> fDone = new FutureDone<List<PeerSocketAddress>>();
        final ArrayList peerSocketAddresses = new ArrayList(2);
        final Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), Message.Type.REQUEST_5);
        final FutureResponse futureResponse = new FutureResponse(message);
        SimpleChannelInboundHandler<Message> inbound = new SimpleChannelInboundHandler<Message>(){

            protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
                if (!msg.peerSocketAddresses().isEmpty() && msg.type() == Message.Type.OK) {
                    peerSocketAddresses.add(msg.peerSocketAddresses().get(0));
                    fDone.done(peerSocketAddresses);
                    ctx.close();
                }
            }
        };
        Utils.addReleaseListener(channelCreator, futureResponse);
        ChannelFuture cF = channelCreator.createUDP(false, peer.connectionBean().sender().configureHandlers(inbound, futureResponse, 30, false), futureResponse);
        cF.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    InetSocketAddress srcAddress = (InetSocketAddress)future.channel().localAddress();
                    peerSocketAddresses.add(new PeerSocketAddress(srcAddress.getAddress(), srcAddress.getPort(), srcAddress.getPort()));
                    peer.connectionBean().sender().afterConnect(futureResponse, message, future, false);
                }
            }
        });
        return fDone;
    }

    private RequestHandler<FutureResponse> createHandler(PeerAddress remotePeer, Message.Type type, ConnectionConfiguration configuration) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), type);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration);
    }

    private FutureResponse createDiscoverHandler(PeerAddress remotePeer) {
        Message message = this.createMessage(remotePeer, RPC.Commands.PING.getNr(), Message.Type.REQUEST_2);
        message.neighborsSet(this.createNeighborSet(this.peerBean().serverPeerAddress()));
        return new FutureResponse(message);
    }

    private NeighborSet createNeighborSet(PeerAddress self) {
        ArrayList<PeerAddress> tmp = new ArrayList<PeerAddress>();
        tmp.add(self);
        return new NeighborSet(-1, tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(final Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        Message responseMessage;
        if (message.type() != Message.Type.REQUEST_FF_1 && message.type() != Message.Type.REQUEST_1 && message.type() != Message.Type.REQUEST_2 && message.type() != Message.Type.REQUEST_3 && message.type() != Message.Type.REQUEST_4 && message.type() != Message.Type.REQUEST_5 || message.command() != RPC.Commands.PING.getNr()) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        if (message.type() == Message.Type.REQUEST_3) {
            LOG.debug("reply to probing, fire message to {}", (Object)message.sender());
            responseMessage = this.createResponseMessage(message, Message.Type.OK);
            if (message.isUdp()) {
                this.connectionBean().reservation().create(1, 0).addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                    @Override
                    public void operationComplete(FutureChannelCreator future) throws Exception {
                        if (future.isSuccess()) {
                            LOG.debug("fire UDP to {}", (Object)message.sender());
                            FutureResponse futureResponse = PingRPC.this.fireUDP(message.sender(), future.channelCreator(), PingRPC.this.connectionBean().channelServer().channelServerConfiguration());
                            Utils.addReleaseListener(future.channelCreator(), futureResponse);
                        } else {
                            Utils.addReleaseListener(future.channelCreator(), new BaseFuture[0]);
                            LOG.warn("handleResponse for REQUEST_3 failed (UDP) {}", (Object)future.failedReason());
                        }
                    }
                });
            } else {
                this.connectionBean().reservation().create(0, 1).addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                    @Override
                    public void operationComplete(FutureChannelCreator future) throws Exception {
                        if (future.isSuccess()) {
                            LOG.debug("fire TCP to {}", (Object)message.sender());
                            FutureResponse futureResponse = PingRPC.this.fireTCP(message.sender(), future.channelCreator(), PingRPC.this.connectionBean().channelServer().channelServerConfiguration());
                            Utils.addReleaseListener(future.channelCreator(), futureResponse);
                        } else {
                            Utils.addReleaseListener(future.channelCreator(), new BaseFuture[0]);
                            LOG.warn("handleResponse for REQUEST_3 failed (TCP) {}", (Object)future.failedReason());
                        }
                    }
                });
            }
        } else if (message.type() == Message.Type.REQUEST_2) {
            LOG.debug("reply to discover, found {}", (Object)message.sender());
            responseMessage = this.createResponseMessage(message, Message.Type.OK);
            responseMessage.neighborsSet(this.createNeighborSet(message.sender()));
        } else if (message.type() == Message.Type.REQUEST_1 || message.type() == Message.Type.REQUEST_4) {
            LOG.debug("reply to regular ping {}", (Object)message.sender());
            if (message.isUdp() && message.sender().peerId().equals(this.peerBean().serverPeerAddress().peerId()) && message.recipient().peerId().equals(Number160.ZERO)) {
                LOG.warn("don't reply, we are on the same peer, you should not make this call");
                responder.responseFireAndForget();
            }
            if (this.enable) {
                responseMessage = this.createResponseMessage(message, Message.Type.OK);
                if (this.wait) {
                    Thread.sleep(10000L);
                }
            } else {
                LOG.debug("do not reply");
                if (this.wait) {
                    Thread.sleep(10000L);
                }
                return;
            }
            if (message.type() == Message.Type.REQUEST_4) {
                List<PeerReceivedBroadcastPing> list = this.receivedBroadcastPingListeners;
                synchronized (list) {
                    for (PeerReceivedBroadcastPing listener : this.receivedBroadcastPingListeners) {
                        listener.broadcastPingReceived(message.sender());
                    }
                }
            }
        } else if (message.type() == Message.Type.REQUEST_5) {
            LOG.debug("reply to natTypePing {}");
            responseMessage = this.createResponseMessage(message, Message.Type.OK);
            int udpPort = -1;
            int tcpPort = -1;
            if (message.isUdp()) {
                udpPort = message.senderSocket().getPort();
            } else {
                tcpPort = message.senderSocket().getPort();
            }
            PeerSocketAddress pAddress = new PeerSocketAddress(message.senderSocket().getAddress(), tcpPort, udpPort);
            responseMessage.peerSocketAddresses().clear();
            ArrayList<PeerSocketAddress> list = new ArrayList<PeerSocketAddress>(2);
            list.add(pAddress);
            responseMessage.peerSocketAddresses(list);
            responseMessage.intValue(message.sender().peerSocketAddress().udpPort());
        } else {
            PeerAddress serverAddress = this.peerBean().serverPeerAddress();
            if (message.isUdp()) {
                PeerAddress newServerAddress = serverAddress.changeFirewalledUDP(false);
                this.peerBean().serverPeerAddress(newServerAddress);
                List<PeerReachable> list = this.reachableListeners;
                synchronized (list) {
                    for (PeerReachable listener : this.reachableListeners) {
                        listener.peerWellConnected(newServerAddress, message.sender(), false);
                    }
                }
                responseMessage = message;
            } else {
                PeerAddress newServerAddress = serverAddress.changeFirewalledTCP(false);
                this.peerBean().serverPeerAddress(newServerAddress);
                List<PeerReachable> list = this.reachableListeners;
                synchronized (list) {
                    for (PeerReachable listener : this.reachableListeners) {
                        listener.peerWellConnected(newServerAddress, message.sender(), true);
                    }
                }
                responseMessage = this.createResponseMessage(message, Message.Type.OK);
            }
        }
        responder.response(responseMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerReachableListener(PeerReachable peerReachable) {
        List<PeerReachable> list = this.reachableListeners;
        synchronized (list) {
            this.reachableListeners.add(peerReachable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerReachableListener(PeerReachable peerReachable) {
        List<PeerReachable> list = this.reachableListeners;
        synchronized (list) {
            this.reachableListeners.remove(peerReachable);
        }
    }

    public void addPeerReceivedBroadcastPingListener(PeerReceivedBroadcastPing peerReceivedBroadcastPing) {
        this.receivedBroadcastPingListeners.add(peerReceivedBroadcastPing);
    }

    public void removePeerReceivedBroadcastPingListener(PeerReceivedBroadcastPing peerReceivedBroadcastPing) {
        this.receivedBroadcastPingListeners.remove(peerReceivedBroadcastPing);
    }
}

