/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.net.InetAddress;
import java.util.Collection;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.connection.DiscoverNetworks;
import net.tomp2p.connection.DiscoverResults;
import net.tomp2p.connection.Ports;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerReachable;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoverBuilder.class);
    private static final FutureDiscover FUTURE_DISCOVER_SHUTDOWN = (FutureDiscover)new FutureDiscover().failed("Peer is shutting down");
    private final Peer peer;
    private InetAddress inetAddress;
    private int portUDP = 7700;
    private int portTCP = 7700;
    private PeerAddress peerAddress;
    private int discoverTimeoutSec = 5;
    private ConnectionConfiguration configuration;
    private FutureDiscover futureDiscover;

    public DiscoverBuilder(Peer peer) {
        this.peer = peer;
    }

    public InetAddress inetAddress() {
        return this.inetAddress;
    }

    public DiscoverBuilder inetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        return this;
    }

    public DiscoverBuilder inetSocketAddress(InetAddress inetAddress, int port) {
        this.inetAddress = inetAddress;
        this.portTCP = port;
        this.portUDP = port;
        return this;
    }

    public DiscoverBuilder inetSocketAddress(InetAddress inetAddress, int portTCP, int portUDP) {
        this.inetAddress = inetAddress;
        this.portTCP = portTCP;
        this.portUDP = portUDP;
        return this;
    }

    public int portUDP() {
        return this.portUDP;
    }

    public DiscoverBuilder portUDP(int portUDP) {
        this.portUDP = portUDP;
        return this;
    }

    public int portTCP() {
        return this.portTCP;
    }

    public DiscoverBuilder portTCP(int portTCP) {
        this.portTCP = portTCP;
        return this;
    }

    public DiscoverBuilder ports(int port) {
        this.portTCP = port;
        this.portUDP = port;
        return this;
    }

    public PeerAddress peerAddress() {
        return this.peerAddress;
    }

    public DiscoverBuilder peerAddress(PeerAddress peerAddress) {
        this.peerAddress = peerAddress;
        return this;
    }

    public int discoverTimeoutSec() {
        return this.discoverTimeoutSec;
    }

    public DiscoverBuilder discoverTimeoutSec(int discoverTimeoutSec) {
        this.discoverTimeoutSec = discoverTimeoutSec;
        return this;
    }

    public FutureDiscover futureDiscover() {
        return this.futureDiscover;
    }

    public DiscoverBuilder futureDiscover(FutureDiscover futureDiscover) {
        this.futureDiscover = futureDiscover;
        return this;
    }

    public FutureDiscover start() {
        if (this.peer.isShutdown()) {
            return FUTURE_DISCOVER_SHUTDOWN;
        }
        if (this.peerAddress == null && this.inetAddress != null) {
            this.peerAddress = new PeerAddress(Number160.ZERO, this.inetAddress, this.portTCP, this.portUDP);
        }
        if (this.peerAddress == null) {
            throw new IllegalArgumentException("need peeraddress or inetaddress");
        }
        if (this.configuration == null) {
            this.configuration = new DefaultConnectionConfiguration();
        }
        if (this.futureDiscover == null) {
            this.futureDiscover = new FutureDiscover();
        }
        return this.discover(this.peerAddress, this.configuration, this.futureDiscover);
    }

    private FutureDiscover discover(final PeerAddress peerAddress, final ConnectionConfiguration configuration, final FutureDiscover futureDiscover) {
        FutureChannelCreator fcc = this.peer.connectionBean().reservation().create(1, 2);
        Utils.addReleaseListener(fcc, (BaseFuture)futureDiscover);
        fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    DiscoverBuilder.this.discover(futureDiscover, peerAddress, future.channelCreator(), configuration);
                } else {
                    futureDiscover.failed(future);
                }
            }
        });
        return futureDiscover;
    }

    private void discover(final FutureDiscover futureDiscover, final PeerAddress peerAddress, final ChannelCreator cc, final ConnectionConfiguration configuration) {
        this.peer.pingRPC().addPeerReachableListener(new PeerReachable(){
            private boolean changedUDP = false;
            private boolean changedTCP = false;

            @Override
            public void peerWellConnected(PeerAddress peerAddress, PeerAddress reporter, boolean tcp) {
                if (tcp) {
                    this.changedTCP = true;
                    futureDiscover.discoveredTCP();
                } else {
                    this.changedUDP = true;
                    futureDiscover.discoveredUDP();
                }
                if (this.changedTCP && this.changedUDP) {
                    futureDiscover.done(peerAddress, reporter);
                }
            }
        });
        final FutureResponse futureResponseTCP = this.peer.pingRPC().pingTCPDiscover(peerAddress, cc, configuration);
        futureResponseTCP.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                PeerAddress serverAddress = DiscoverBuilder.this.peer.peerBean().serverPeerAddress();
                if (futureResponseTCP.isSuccess()) {
                    serverAddress = serverAddress.changeAddress(futureResponseTCP.responseMessage().recipient().inetAddress());
                    Collection<PeerAddress> tmp = futureResponseTCP.responseMessage().neighborsSet(0).neighbors();
                    futureDiscover.reporter(futureResponseTCP.responseMessage().sender());
                    if (tmp.size() == 1) {
                        PeerAddress seenAs = tmp.iterator().next();
                        LOG.info("I'm seen as {} by peer {}. I see myself as {}", new Object[]{seenAs, peerAddress, DiscoverBuilder.this.peer.peerAddress().inetAddress()});
                        if (!DiscoverBuilder.this.peer.peerAddress().inetAddress().equals(seenAs.inetAddress())) {
                            Bindings bindings2 = new Bindings().addAddress(seenAs.inetAddress());
                            DiscoverResults discoverResults = DiscoverNetworks.discoverInterfaces(bindings2);
                            String status = discoverResults.status();
                            LOG.info("2nd interface discovery: {}", (Object)status);
                            if (discoverResults.newAddresses().size() > 0 && discoverResults.newAddresses().contains(seenAs.inetAddress())) {
                                serverAddress = serverAddress.changeAddress(seenAs.inetAddress());
                                DiscoverBuilder.this.peer.peerBean().serverPeerAddress(serverAddress);
                                LOG.info("we were having the wrong interface, change it to: {}", (Object)serverAddress);
                            } else {
                                Ports ports = DiscoverBuilder.this.peer.connectionBean().channelServer().channelServerConfiguration().portsForwarding();
                                if (ports.isManualPort()) {
                                    PeerAddress serverAddressOrig = serverAddress;
                                    serverAddress = serverAddress.changePorts(ports.tcpPort(), ports.udpPort());
                                    serverAddress = serverAddress.changeAddress(seenAs.inetAddress());
                                    serverAddress = serverAddress.changePortForwarding(true);
                                    DiscoverBuilder.this.peer.peerBean().serverPeerAddress(serverAddress);
                                    DiscoverBuilder.this.peer.peerBean().serverPeerAddress().internalPeerSocketAddress(serverAddressOrig.peerSocketAddress());
                                    LOG.info("manual ports, change it to: {}", (Object)serverAddress);
                                } else {
                                    LOG.info("We are most likely behind NAT, try to UPNP, NATPMP or relay. PeerAddress: {}, ServerAddress: {}, Seen as: {}" + peerAddress, (Object)serverAddress.inetAddress(), (Object)seenAs.inetAddress());
                                    futureDiscover.externalHost("We are most likely behind NAT, try to UPNP, NATPMP or relay. Using peerAddress " + peerAddress, serverAddress.inetAddress(), seenAs.inetAddress());
                                    return;
                                }
                            }
                        }
                        FutureResponse fr1 = DiscoverBuilder.this.peer.pingRPC().pingTCPProbe(peerAddress, cc, configuration);
                        fr1.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

                            @Override
                            public void operationComplete(FutureResponse future) throws Exception {
                                if (future.isFailed() && !futureDiscover.isCompleted()) {
                                    LOG.warn("FutureDiscover (2): We need at least the TCP connection {} - {}", (Object)future, (Object)futureDiscover.failedReason());
                                    futureDiscover.failed("FutureDiscover (2): We need at least the TCP connection", future);
                                }
                            }
                        });
                        FutureResponse fr2 = DiscoverBuilder.this.peer.pingRPC().pingUDPProbe(peerAddress, cc, configuration);
                        fr2.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

                            @Override
                            public void operationComplete(FutureResponse future) throws Exception {
                                if (future.isFailed() && !futureDiscover.isCompleted()) {
                                    LOG.warn("FutureDiscover (2): UDP failed connection {} - {}", (Object)future, (Object)futureDiscover.failedReason());
                                }
                            }
                        });
                        futureDiscover.timeout(serverAddress, DiscoverBuilder.this.peer.connectionBean().timer(), DiscoverBuilder.this.discoverTimeoutSec);
                        return;
                    }
                    futureDiscover.failed("Peer " + peerAddress + " did not report our IP address");
                    return;
                }
                futureDiscover.failed("FutureDiscover (1): We need at least the TCP connection", futureResponseTCP);
            }
        });
    }
}

