/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.buffer.ByteBufAllocator;
import java.net.InetAddress;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.PipelineFilter;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.storage.AlternativeCompositeByteBuf;

public class ChannelClientConfiguration {
    private int maxPermitsPermanentTCP;
    private int maxPermitsUDP;
    private int maxPermitsTCP;
    private PipelineFilter pipelineFilter;
    private SignatureFactory signatureFactory;
    private Bindings bindings;
    private InetAddress senderUDP;
    private InetAddress senderTCP;
    private boolean enablePool = false;
    private boolean enableHeap = false;

    public int maxPermitsPermanentTCP() {
        return this.maxPermitsPermanentTCP;
    }

    public ChannelClientConfiguration maxPermitsPermanentTCP(int maxPermitsPermanentTCP) {
        this.maxPermitsPermanentTCP = maxPermitsPermanentTCP;
        return this;
    }

    public int maxPermitsUDP() {
        return this.maxPermitsUDP;
    }

    public ChannelClientConfiguration maxPermitsUDP(int maxPermitsUDP) {
        this.maxPermitsUDP = maxPermitsUDP;
        return this;
    }

    public int maxPermitsTCP() {
        return this.maxPermitsTCP;
    }

    public ChannelClientConfiguration maxPermitsTCP(int maxPermitsTCP) {
        this.maxPermitsTCP = maxPermitsTCP;
        return this;
    }

    public PipelineFilter pipelineFilter() {
        return this.pipelineFilter;
    }

    public ChannelClientConfiguration pipelineFilter(PipelineFilter pipelineFilter) {
        this.pipelineFilter = pipelineFilter;
        return this;
    }

    public SignatureFactory signatureFactory() {
        return this.signatureFactory;
    }

    public ChannelClientConfiguration signatureFactory(SignatureFactory signatureFactory) {
        this.signatureFactory = signatureFactory;
        return this;
    }

    public Bindings bindings() {
        return this.bindings;
    }

    public ChannelClientConfiguration bindings(Bindings bindings) {
        this.bindings = bindings;
        return this;
    }

    public InetAddress senderUDP() {
        return this.senderUDP;
    }

    public ChannelClientConfiguration senderUDP(InetAddress senderUDP) {
        this.senderUDP = senderUDP;
        return this;
    }

    public InetAddress senderTCP() {
        return this.senderTCP;
    }

    public ChannelClientConfiguration senderTCP(InetAddress senderUDP) {
        this.senderTCP = senderUDP;
        return this;
    }

    public ChannelClientConfiguration byteBufPool() {
        this.byteBufPool(true);
        return this;
    }

    public ChannelClientConfiguration byteBufPool(boolean enablePool) {
        this.enablePool = enablePool;
        return this;
    }

    public ChannelClientConfiguration byteBufHeap() {
        this.byteBufHeap(true);
        return this;
    }

    public ChannelClientConfiguration byteBufHeap(boolean enableHeap) {
        this.enableHeap = enableHeap;
        return this;
    }

    public ChannelClientConfiguration byteBufAllocator(boolean enablePool, boolean enableHeap) {
        this.enableHeap = enableHeap;
        this.enablePool = enablePool;
        return this;
    }

    public ByteBufAllocator byteBufAllocator() {
        if (this.enableHeap && this.enablePool) {
            return AlternativeCompositeByteBuf.POOLED_HEAP;
        }
        if (!this.enableHeap && this.enablePool) {
            return AlternativeCompositeByteBuf.POOLED_DIRECT;
        }
        if (this.enableHeap && !this.enablePool) {
            return AlternativeCompositeByteBuf.UNPOOLED_HEAP;
        }
        return AlternativeCompositeByteBuf.UNPOOLED_DIRECT;
    }
}

