/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.nat;

import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Ports;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.nat.FutureNAT;
import net.tomp2p.nat.FutureRelayNAT;
import net.tomp2p.nat.NATUtils;
import net.tomp2p.natpmp.NatPmpException;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.Shutdown;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.p2p.builder.DiscoverBuilder;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.DistributedRelay;
import net.tomp2p.relay.FutureRelay;
import net.tomp2p.relay.PeerMapUpdateTask;
import net.tomp2p.relay.RelayClientConfig;
import net.tomp2p.relay.RelayListener;
import net.tomp2p.relay.RelayRPC;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerNAT {
    private static final Logger LOG = LoggerFactory.getLogger(PeerNAT.class);
    private final Peer peer;
    private final NATUtils natUtils;
    private final RelayRPC relayRPC;
    private final boolean manualPorts;

    public PeerNAT(Peer peer, NATUtils natUtils, RelayRPC relayRPC, boolean manualPorts) {
        this.peer = peer;
        this.natUtils = natUtils;
        this.relayRPC = relayRPC;
        this.manualPorts = manualPorts;
    }

    public Peer peer() {
        return this.peer;
    }

    public NATUtils natUtils() {
        return this.natUtils;
    }

    public RelayRPC relayRPC() {
        return this.relayRPC;
    }

    public boolean isManualPorts() {
        return this.manualPorts;
    }

    public FutureNAT startSetupPortforwarding(FutureDiscover futureDiscover) {
        DiscoverBuilder builder = new DiscoverBuilder(this.peer);
        return this.startSetupPortforwarding(futureDiscover, builder);
    }

    public FutureNAT startSetupPortforwarding(final FutureDiscover futureDiscover, final DiscoverBuilder builder) {
        final FutureNAT futureNAT = new FutureNAT();
        futureDiscover.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDiscover>(){

            public void operationComplete(FutureDiscover future) throws Exception {
                if (future.reporter() != null) {
                    futureNAT.reporter(future.reporter());
                }
                if (future.isFailed() && future.isNat() && !PeerNAT.this.manualPorts) {
                    Ports externalPorts = PeerNAT.this.setupPortforwarding(future.internalAddress().getHostAddress(), PeerNAT.this.peer.connectionBean().channelServer().channelServerConfiguration().portsForwarding());
                    if (externalPorts != null) {
                        final PeerAddress serverAddressOrig = PeerNAT.this.peer.peerBean().serverPeerAddress();
                        final PeerAddress serverAddress = serverAddressOrig.changePorts(externalPorts.tcpPort(), externalPorts.udpPort()).changeAddress(future.externalAddress());
                        PeerNAT.this.peer.peerBean().serverPeerAddress(serverAddress);
                        builder.peerAddress(futureNAT.reporter()).start().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDiscover>(){

                            public void operationComplete(FutureDiscover future) throws Exception {
                                if (future.isSuccess()) {
                                    PeerNAT.this.peer.peerBean().serverPeerAddress(serverAddress.changePortForwarding(true));
                                    PeerNAT.this.peer.peerBean().serverPeerAddress().internalPeerSocketAddress(serverAddressOrig.peerSocketAddress());
                                    futureNAT.done(future.peerAddress(), future.reporter());
                                } else {
                                    PeerAddress pa = PeerNAT.this.peer.peerBean().serverPeerAddress().changeFirewalledTCP(true).changeFirewalledUDP(true);
                                    PeerNAT.this.peer.peerBean().serverPeerAddress(pa);
                                    futureNAT.failed((BaseFuture)future);
                                }
                            }
                        });
                    } else {
                        PeerAddress pa = PeerNAT.this.peer.peerBean().serverPeerAddress().changeFirewalledTCP(true).changeFirewalledUDP(true);
                        PeerNAT.this.peer.peerBean().serverPeerAddress(pa);
                        futureNAT.failed("could not setup NAT");
                    }
                } else if (future.isSuccess()) {
                    LOG.info("nothing to do, you are reachable from outside");
                    futureNAT.done(futureDiscover.peerAddress(), futureDiscover.reporter());
                } else {
                    LOG.info("not reachable, maybe your setup is wrong");
                    futureNAT.failed("could discover anything", (BaseFuture)future);
                }
            }
        });
        return futureNAT;
    }

    public Ports setupPortforwarding(String internalHost, Ports ports) {
        boolean success;
        block8: {
            try {
                success = this.natUtils.mapUPNP(internalHost, this.peer.peerAddress().tcpPort(), this.peer.peerAddress().udpPort(), ports.udpPort(), ports.tcpPort());
            }
            catch (Exception e) {
                success = false;
            }
            if (!success) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("cannot find UPNP devices");
                }
                try {
                    success = this.natUtils.mapPMP(this.peer.peerAddress().tcpPort(), this.peer.peerAddress().udpPort(), ports.udpPort(), ports.tcpPort());
                    if (!success && LOG.isWarnEnabled()) {
                        LOG.warn("cannot find NAT-PMP devices");
                    }
                }
                catch (NatPmpException e1) {
                    if (!LOG.isWarnEnabled()) break block8;
                    LOG.warn("cannot find NAT-PMP devices ", (Throwable)e1);
                }
            }
        }
        if (success) {
            return ports;
        }
        return null;
    }

    private DistributedRelay startSetupRelay(FutureRelay futureRelay, RelayClientConfig relayConfig) {
        final DistributedRelay distributedRelay = new DistributedRelay(this.peer, this.relayRPC, relayConfig);
        this.peer.addShutdownListener(new Shutdown(){

            public BaseFuture shutdown() {
                return distributedRelay.shutdown();
            }
        });
        distributedRelay.addRelayListener(new RelayListener(){

            @Override
            public void relayFailed(PeerAddress relayAddress) {
                FutureRelay futureRelay2 = new FutureRelay();
                distributedRelay.setupRelays(futureRelay2);
                PeerNAT.this.peer.notifyAutomaticFutures((BaseFuture)futureRelay2);
            }
        });
        distributedRelay.setupRelays(futureRelay);
        return distributedRelay;
    }

    private Shutdown startRelayMaintenance(FutureRelay futureRelay, BootstrapBuilder bootstrapBuilder, DistributedRelay distributedRelay, int peerMapUpdateInterval) {
        final PeerMapUpdateTask peerMapUpdateTask = new PeerMapUpdateTask(this.relayRPC, bootstrapBuilder, distributedRelay);
        this.peer.connectionBean().timer().scheduleAtFixedRate(peerMapUpdateTask, 0L, peerMapUpdateInterval, TimeUnit.SECONDS);
        final Shutdown shutdown = new Shutdown(){

            public BaseFuture shutdown() {
                peerMapUpdateTask.cancel();
                return new FutureDone().done();
            }
        };
        this.peer.addShutdownListener(shutdown);
        return new Shutdown(){

            public BaseFuture shutdown() {
                peerMapUpdateTask.cancel();
                PeerNAT.this.peer.removeShutdownListener(shutdown);
                return new FutureDone().done();
            }
        };
    }

    public FutureRelayNAT startRelay(RelayClientConfig relayConfig, PeerAddress peerAddress) {
        BootstrapBuilder bootstrapBuilder = this.peer.bootstrap().peerAddress(peerAddress);
        return this.startRelay(relayConfig, bootstrapBuilder);
    }

    public FutureRelayNAT startRelay(RelayClientConfig relayConfig, BootstrapBuilder bootstrapBuilder) {
        FutureRelayNAT futureBootstrapNAT = new FutureRelayNAT();
        return this.startRelay(relayConfig, futureBootstrapNAT, bootstrapBuilder);
    }

    public FutureRelayNAT startRelay(RelayClientConfig relayConfig, FutureDiscover futureDiscover) {
        return this.startRelay(relayConfig, futureDiscover, null);
    }

    public FutureRelayNAT startRelay(final RelayClientConfig relayConfig, final FutureDiscover futureDiscover, final FutureNAT futureNAT) {
        final FutureRelayNAT futureRelayNAT = new FutureRelayNAT();
        futureDiscover.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDiscover>(){

            public void operationComplete(FutureDiscover future) throws Exception {
                if (future.isFailed()) {
                    if (futureNAT != null) {
                        PeerNAT.this.handleFutureNat(relayConfig, futureDiscover.reporter(), futureNAT, futureRelayNAT);
                    } else {
                        BootstrapBuilder bootstrapBuilder = PeerNAT.this.peer.bootstrap().peerAddress(futureDiscover.reporter());
                        PeerNAT.this.startRelay(relayConfig, futureRelayNAT, bootstrapBuilder);
                    }
                } else {
                    futureRelayNAT.done();
                }
            }
        });
        return futureRelayNAT;
    }

    private void handleFutureNat(final RelayClientConfig relayConfig, final PeerAddress peerAddress, FutureNAT futureNAT, final FutureRelayNAT futureRelayNAT) {
        futureNAT.addListener((BaseFutureListener)new BaseFutureAdapter<FutureNAT>(){

            public void operationComplete(FutureNAT future) throws Exception {
                if (future.isSuccess()) {
                    futureRelayNAT.done();
                } else {
                    BootstrapBuilder bootstrapBuilder = PeerNAT.this.peer.bootstrap().peerAddress(peerAddress);
                    PeerNAT.this.startRelay(relayConfig, futureRelayNAT, bootstrapBuilder);
                }
            }
        });
    }

    private FutureRelayNAT startRelay(final RelayClientConfig relayConfig, final FutureRelayNAT futureRelayNAT, final BootstrapBuilder bootstrapBuilder) {
        PeerAddress upa = this.peer.peerBean().serverPeerAddress();
        upa = upa.changeFirewalledTCP(true).changeFirewalledUDP(true).changeSlow(relayConfig.type().isSlow());
        this.peer.peerBean().serverPeerAddress(upa);
        FutureBootstrap futureBootstrap = bootstrapBuilder.start();
        futureBootstrap.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

            public void operationComplete(FutureBootstrap future) throws Exception {
                if (future.isSuccess()) {
                    LOG.debug("bootstrap completed");
                    final FutureRelay futureRelay = new FutureRelay();
                    final DistributedRelay distributedRelay = PeerNAT.this.startSetupRelay(futureRelay, relayConfig);
                    futureRelayNAT.bufferRequestListener(distributedRelay);
                    futureRelayNAT.futureRelay(futureRelay);
                    futureRelay.addListener((BaseFutureListener)new BaseFutureAdapter<FutureRelay>(){

                        public void operationComplete(FutureRelay future) throws Exception {
                            if (future.isSuccess()) {
                                FutureBootstrap futureBootstrap = bootstrapBuilder.start();
                                futureBootstrap.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

                                    public void operationComplete(FutureBootstrap future) throws Exception {
                                        if (future.isSuccess()) {
                                            Shutdown shutdown = PeerNAT.this.startRelayMaintenance(futureRelay, bootstrapBuilder, distributedRelay, relayConfig.peerMapUpdateInterval());
                                            futureRelayNAT.done(shutdown);
                                        } else {
                                            futureRelayNAT.failed("2nd FutureBootstrap failed", (BaseFuture)future);
                                        }
                                    }
                                });
                            } else {
                                futureRelayNAT.failed("FutureRelay failed", (BaseFuture)future);
                            }
                        }
                    });
                } else {
                    futureRelayNAT.failed("FutureBootstrap failed", (BaseFuture)future);
                }
            }
        });
        return futureRelayNAT;
    }

    public FutureDone<PeerConnection> startSetupRcon(final PeerAddress relayPeerAddress, final PeerAddress unreachablePeerAddress) {
        this.checkRconPreconditions(relayPeerAddress, unreachablePeerAddress);
        final FutureDone futureDone = new FutureDone();
        final FuturePeerConnection fpc = this.peer.createPeerConnection(relayPeerAddress);
        fpc.addListener((BaseFutureListener)new BaseFutureAdapter<FuturePeerConnection>(){

            public void operationComplete(FuturePeerConnection future) throws Exception {
                if (fpc.isSuccess()) {
                    final PeerConnection peerConnection = fpc.peerConnection();
                    if (peerConnection != null) {
                        Message setUpMessage = this.createSetupMessage(relayPeerAddress, unreachablePeerAddress);
                        FutureResponse futureResponse = RelayUtils.send(peerConnection, PeerNAT.this.peer.peerBean(), PeerNAT.this.peer.connectionBean(), setUpMessage);
                        futureResponse.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                            public void operationComplete(FutureResponse future) throws Exception {
                                PeerConnection openPeerConnection = PeerNAT.this.peer.peerBean().peerConnection(unreachablePeerAddress.peerId());
                                if (openPeerConnection != null && openPeerConnection.isOpen()) {
                                    futureDone.done((Object)openPeerConnection);
                                } else {
                                    LOG.error("The reverse connection to the unreachable peer failed.");
                                    this.handleFail((FutureDone<PeerConnection>)futureDone, "No reverse connection could be established");
                                }
                                peerConnection.close();
                            }
                        });
                    } else {
                        this.handleFail((FutureDone<PeerConnection>)futureDone, "The PeerConnection was null!");
                    }
                } else {
                    this.handleFail((FutureDone<PeerConnection>)futureDone, "no channel could be established");
                }
            }

            private void handleFail(FutureDone<PeerConnection> futureDone2, String failMessage) {
                LOG.error(failMessage);
                futureDone2.failed(failMessage);
            }

            private Message createSetupMessage(PeerAddress relayPeerAddress2, PeerAddress unreachablePeerAddress2) {
                Message setUpMessage = new Message();
                setUpMessage.version(PeerNAT.this.peer.connectionBean().p2pId());
                setUpMessage.sender(PeerNAT.this.peer.peerAddress());
                setUpMessage.recipient(relayPeerAddress2.changePeerId(unreachablePeerAddress2.peerId()));
                setUpMessage.command(RPC.Commands.RCON.getNr());
                setUpMessage.type(Message.Type.REQUEST_1);
                return setUpMessage;
            }
        });
        return futureDone;
    }

    private void checkRconPreconditions(PeerAddress relayPeerAddress, PeerAddress unreachablePeerAddress) {
        if (relayPeerAddress == null || unreachablePeerAddress == null) {
            throw new IllegalArgumentException("either the relay PeerAddress or the unreachablePeerAddress or both was/were null!");
        }
        if (this.peer.peerAddress().peerId().equals((Object)relayPeerAddress.peerId())) {
            throw new IllegalStateException("We are alredy a relay for the target peer. We shouldn't use a reverse connection to connect to the targeted peer!");
        }
    }
}

