/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

public class RoutingConfiguration {
    private final int maxDirectHits;
    private final int maxNoNewInfoDiff;
    private final int maxFailures;
    private final int maxSuccess;
    private final int parallel;
    private final boolean forceTCP;

    public RoutingConfiguration(int maxNoNewInfoDiff, int maxFailures, int parallel) {
        this(Integer.MAX_VALUE, maxNoNewInfoDiff, maxFailures, 20, parallel);
    }

    public RoutingConfiguration(int maxNoNewInfoDiff, int maxFailures, int maxSuccess, int parallel) {
        this(Integer.MAX_VALUE, maxNoNewInfoDiff, maxFailures, maxSuccess, parallel);
    }

    public RoutingConfiguration(int directHits, int maxNoNewInfoDiff, int maxFailures, int maxSuccess, int parallel) {
        this(directHits, maxNoNewInfoDiff, maxFailures, maxSuccess, parallel, false);
    }

    public RoutingConfiguration(int maxDirectHits, int maxNoNewInfoDiff, int maxFailures, int maxSuccess, int parallel, boolean forceTCP) {
        if (maxDirectHits < 0 || maxNoNewInfoDiff < 0 || maxFailures < 0 || parallel < 0) {
            throw new IllegalArgumentException("need to be larger or equals zero");
        }
        this.maxDirectHits = maxDirectHits;
        this.maxNoNewInfoDiff = maxNoNewInfoDiff;
        this.maxFailures = maxFailures;
        this.maxSuccess = maxSuccess;
        this.parallel = parallel;
        this.forceTCP = forceTCP;
    }

    public int maxDirectHits() {
        return this.maxDirectHits;
    }

    public int maxNoNewInfoDiff() {
        return this.maxNoNewInfoDiff;
    }

    public int maxNoNewInfo(int minimumResults) {
        return this.maxNoNewInfoDiff + minimumResults;
    }

    public int maxFailures() {
        return this.maxFailures;
    }

    public int maxSuccess() {
        return this.maxSuccess;
    }

    public int parallel() {
        return this.parallel;
    }

    public boolean isForceTCP() {
        return this.forceTCP;
    }
}

