/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.BroadcastHandler;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.BroadcastBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.ConcurrentCacheMap;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBroadcastHandler
implements BroadcastHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBroadcastHandler.class);
    private static final Set<Number160> DEBUG_COUNTER = new HashSet<Number160>();
    private static final int NR = 10;
    private static final int MAX_HOP_COUNT = 4;
    private final Peer peer;
    private final Random rnd;
    private final ConcurrentCacheMap<Number160, Boolean> cache = new ConcurrentCacheMap();

    public DefaultBroadcastHandler(Peer peer, Random rnd) {
        this.peer = peer;
        this.rnd = rnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBroadcastCounter() {
        Set<Number160> set = DEBUG_COUNTER;
        synchronized (set) {
            return DEBUG_COUNTER.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Message message) {
        Number160 messageKey = message.key(0);
        NavigableMap<Number640, Data> dataMap = message.dataMap(0) != null ? message.dataMap(0).dataMap() : null;
        int hopCount = message.intAt(0);
        if (this.twiceSeen(messageKey)) {
            return;
        }
        LOG.debug("got broadcast map {} from {}", dataMap, (Object)this.peer.peerID());
        Set<Number160> set = DEBUG_COUNTER;
        synchronized (set) {
            DEBUG_COUNTER.add(this.peer.peerID());
        }
        if (hopCount < 4) {
            if (hopCount == 0) {
                this.firstPeer(messageKey, dataMap, hopCount, message.isUdp());
            } else {
                this.otherPeer(messageKey, dataMap, hopCount, message.isUdp());
            }
        }
    }

    private boolean twiceSeen(Number160 messageKey) {
        Boolean isInCache = this.cache.putIfAbsent(messageKey, Boolean.TRUE);
        if (isInCache != null) {
            if (isInCache.booleanValue()) {
                this.cache.put(messageKey, false);
            } else {
                return true;
            }
        }
        return false;
    }

    private void firstPeer(final Number160 messageKey, final NavigableMap<Number640, Data> dataMap, final int hopCounter, final boolean isUDP) {
        List<PeerAddress> list = this.peer.peerBean().peerMap().all();
        for (final PeerAddress peerAddress : list) {
            FutureChannelCreator frr = this.peer.connectionBean().reservation().create(isUDP ? 1 : 0, isUDP ? 0 : 1);
            frr.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        BroadcastBuilder broadcastBuilder = new BroadcastBuilder(DefaultBroadcastHandler.this.peer, messageKey);
                        broadcastBuilder.dataMap(dataMap);
                        broadcastBuilder.hopCounter(hopCounter + 1);
                        broadcastBuilder.udp(isUDP);
                        FutureResponse futureResponse = DefaultBroadcastHandler.this.peer.broadcastRPC().send(peerAddress, broadcastBuilder, future.channelCreator(), broadcastBuilder);
                        LOG.debug("1st broadcast to {}", (Object)peerAddress);
                        Utils.addReleaseListener(future.channelCreator(), futureResponse);
                    } else {
                        Utils.addReleaseListener(future.channelCreator(), new BaseFuture[0]);
                    }
                }
            });
        }
    }

    private void otherPeer(final Number160 messageKey, final NavigableMap<Number640, Data> dataMap, final int hopCounter, final boolean isUDP) {
        LOG.debug("other");
        final List<PeerAddress> list = this.peer.peerBean().peerMap().all();
        final int max = Math.min(10, list.size());
        FutureChannelCreator frr = this.peer.connectionBean().reservation().create(isUDP ? max : 0, isUDP ? 0 : max);
        frr.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    BaseFuture[] futures = new FutureResponse[max];
                    for (int i = 0; i < max; ++i) {
                        PeerAddress randomAddress = (PeerAddress)list.remove(DefaultBroadcastHandler.this.rnd.nextInt(list.size()));
                        BroadcastBuilder broadcastBuilder = new BroadcastBuilder(DefaultBroadcastHandler.this.peer, messageKey);
                        broadcastBuilder.dataMap(dataMap);
                        broadcastBuilder.hopCounter(hopCounter + 1);
                        broadcastBuilder.udp(isUDP);
                        futures[i] = DefaultBroadcastHandler.this.peer.broadcastRPC().send(randomAddress, broadcastBuilder, future.channelCreator(), broadcastBuilder);
                        LOG.debug("2nd broadcast to {} with hop {}", (Object)randomAddress, (Object)(hopCounter + 1));
                    }
                    Utils.addReleaseListener(future.channelCreator(), futures);
                } else {
                    Utils.addReleaseListener(future.channelCreator(), new BaseFuture[0]);
                }
            }
        });
    }
}

