/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.connection.ChannelClientConfiguration;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.Dispatcher;
import net.tomp2p.connection.HeartBeat;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerException;
import net.tomp2p.connection.PingBuilderFactory;
import net.tomp2p.connection.Responder;
import net.tomp2p.connection.SendBehavior;
import net.tomp2p.connection.TimeoutFactory;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.Cancel;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FuturePing;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.DataFilter;
import net.tomp2p.message.DataFilterTTL;
import net.tomp2p.message.Message;
import net.tomp2p.message.TomP2PCumulationTCP;
import net.tomp2p.message.TomP2POutbound;
import net.tomp2p.message.TomP2PSinglePacketUDP;
import net.tomp2p.p2p.builder.PingBuilder;
import net.tomp2p.peers.LocalMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sender {
    private static final Logger LOG = LoggerFactory.getLogger(Sender.class);
    private final List<PeerStatusListener> peerStatusListeners;
    private final ChannelClientConfiguration channelClientConfiguration;
    private final Dispatcher dispatcher;
    private final SendBehavior sendBehavior;
    private final Random random;
    private final PeerBean peerBean;
    private final DataFilter dataFilterTTL = new DataFilterTTL();
    private final ConcurrentHashMap<Integer, FutureResponse> cachedRequests = new ConcurrentHashMap();
    private PingBuilderFactory pingBuilderFactory;

    public Sender(Number160 peerId, List<PeerStatusListener> peerStatusListeners, ChannelClientConfiguration channelClientConfiguration, Dispatcher dispatcher, SendBehavior sendBehavior, PeerBean peerBean) {
        this.peerStatusListeners = peerStatusListeners;
        this.channelClientConfiguration = channelClientConfiguration;
        this.dispatcher = dispatcher;
        this.sendBehavior = sendBehavior;
        this.random = new Random(peerId.hashCode());
        this.peerBean = peerBean;
    }

    public ChannelClientConfiguration channelClientConfiguration() {
        return this.channelClientConfiguration;
    }

    public PingBuilderFactory pingBuilderFactory() {
        return this.pingBuilderFactory;
    }

    public Sender pingBuilderFactory(PingBuilderFactory pingBuilderFactory) {
        this.pingBuilderFactory = pingBuilderFactory;
        return this;
    }

    public void sendTCP(SimpleChannelInboundHandler<Message> handler, FutureResponse futureResponse, Message message, ChannelCreator channelCreator, int idleTCPSeconds, int connectTimeoutMillis, PeerConnection peerConnection) {
        PeerStatistic peerStatistic;
        if (futureResponse.isCompleted()) {
            return;
        }
        LocalMap localMap = this.peerBean.localMap();
        if (localMap != null && (peerStatistic = localMap.translate(message.recipient())) != null) {
            message.recipient(peerStatistic.peerAddress());
        }
        this.removePeerIfFailed(futureResponse, message);
        futureResponse.startRTTMeasurement(false);
        if (peerConnection != null && peerConnection.channelFuture() != null && peerConnection.channelFuture().channel().isActive()) {
            ChannelFuture channelFuture = this.sendTCPPeerConnection(peerConnection, (ChannelHandler)handler, channelCreator, futureResponse);
            this.afterConnect(futureResponse, message, channelFuture, handler == null);
        } else if (channelCreator != null) {
            TimeoutFactory timeoutHandler = this.createTimeoutHandler(futureResponse, idleTCPSeconds, handler == null);
            switch (this.sendBehavior.tcpSendBehavior(message)) {
                case DIRECT: {
                    this.connectAndSend(handler, futureResponse, channelCreator, connectTimeoutMillis, peerConnection, timeoutHandler, message);
                    break;
                }
                case RCON: {
                    this.handleRcon(handler, futureResponse, message, channelCreator, connectTimeoutMillis, peerConnection, timeoutHandler);
                    break;
                }
                case RELAY: {
                    this.handleRelay(handler, futureResponse, message, channelCreator, idleTCPSeconds, connectTimeoutMillis, peerConnection, timeoutHandler);
                    break;
                }
                case SELF: {
                    this.sendSelf(futureResponse, message);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal sending behavior");
                }
            }
        }
    }

    private void handleRcon(SimpleChannelInboundHandler<Message> handler, final FutureResponse futureResponse, final Message message, ChannelCreator channelCreator, int connectTimeoutMillis, PeerConnection peerConnection, TimeoutFactory timeoutHandler) {
        message.keepAlive(true);
        LOG.debug("initiate reverse connection setup to peer with peerAddress {}", (Object)message.recipient());
        Message rconMessage = Sender.createRconMessage(message);
        this.cachedRequests.put(message.messageId(), futureResponse);
        final FutureResponse rconResponse = new FutureResponse(rconMessage);
        SimpleChannelInboundHandler<Message> rconInboundHandler = new SimpleChannelInboundHandler<Message>(){

            protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
                if (msg.command() == RPC.Commands.RCON.getNr() && msg.type() == Message.Type.OK) {
                    LOG.debug("Successfully set up the reverse connection to peer {}", (Object)message.recipient().peerId());
                    rconResponse.response(msg);
                } else {
                    LOG.debug("Could not acquire a reverse connection, msg: {}", (Object)message);
                    rconResponse.failed("Could not acquire a reverse connection, msg: " + message);
                    futureResponse.failed(rconResponse);
                }
            }
        };
        this.sendTCP(rconInboundHandler, rconResponse, rconMessage, channelCreator, connectTimeoutMillis, connectTimeoutMillis, peerConnection);
    }

    private static Message createRconMessage(Message message) {
        PeerSocketAddress socketAddress = Utils.extractRandomRelay(message);
        Message rconMessage = new Message();
        rconMessage.sender(message.sender());
        rconMessage.version(message.version());
        rconMessage.intValue(message.messageId());
        rconMessage.keepAlive(true);
        Sender.readyToSend(message, socketAddress, rconMessage, RPC.Commands.RCON.getNr(), Message.Type.REQUEST_1);
        return rconMessage;
    }

    private static void readyToSend(Message originalMessage, PeerSocketAddress socketAddress, Message newMessage, byte RPCCommand, Message.Type messageType) {
        PeerAddress recipient = originalMessage.recipient().changeAddress(socketAddress.inetAddress()).changePorts(socketAddress.tcpPort(), socketAddress.udpPort()).changeRelayed(false);
        newMessage.recipient(recipient);
        newMessage.command(RPCCommand);
        newMessage.type(messageType);
    }

    private void connectAndSend(SimpleChannelInboundHandler<Message> handler, FutureResponse futureResponse, ChannelCreator channelCreator, int connectTimeoutMillis, PeerConnection peerConnection, TimeoutFactory timeoutHandler, Message message) {
        InetSocketAddress recipient = message.recipient().createSocketTCP();
        ChannelFuture channelFuture = this.sendTCPCreateChannel(recipient, channelCreator, peerConnection, (ChannelHandler)handler, timeoutHandler, connectTimeoutMillis, futureResponse);
        this.afterConnect(futureResponse, message, channelFuture, handler == null);
    }

    private void handleRelay(final SimpleChannelInboundHandler<Message> handler, final FutureResponse futureResponse, final Message message, final ChannelCreator channelCreator, final int idleTCPSeconds, final int connectTimeoutMillis, final PeerConnection peerConnection, final TimeoutFactory timeoutHandler) {
        FutureDone<PeerSocketAddress> futurePing = this.pingFirst(message.recipient().peerSocketAddresses());
        futurePing.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<PeerSocketAddress>>(){

            @Override
            public void operationComplete(final FutureDone<PeerSocketAddress> futureDone) throws Exception {
                if (futureDone.isSuccess()) {
                    InetSocketAddress recipient = PeerSocketAddress.createSocketTCP(futureDone.object());
                    ChannelFuture channelFuture = Sender.this.sendTCPCreateChannel(recipient, channelCreator, peerConnection, (ChannelHandler)handler, timeoutHandler, connectTimeoutMillis, futureResponse);
                    Sender.this.afterConnect(futureResponse, message, channelFuture, handler == null);
                    futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

                        @Override
                        public void operationComplete(FutureResponse future) throws Exception {
                            if (future.isFailed() && future.responseMessage() != null && future.responseMessage().type() != Message.Type.DENIED) {
                                this.clearInactivePeerSocketAddress(futureDone);
                                Sender.this.sendTCP((SimpleChannelInboundHandler<Message>)handler, futureResponse, message, channelCreator, idleTCPSeconds, connectTimeoutMillis, peerConnection);
                            }
                        }

                        private void clearInactivePeerSocketAddress(FutureDone<PeerSocketAddress> futureDone2) {
                            ArrayList<PeerSocketAddress> tmp = new ArrayList<PeerSocketAddress>();
                            for (PeerSocketAddress psa : message.recipient().peerSocketAddresses()) {
                                if (psa == null || psa.equals(futureDone2.object())) continue;
                                tmp.add(psa);
                            }
                            message.peerSocketAddresses(tmp);
                        }
                    });
                } else {
                    futureResponse.failed("no relay could be contacted", futureDone);
                }
            }
        });
    }

    private FutureDone<PeerSocketAddress> pingFirst(Collection<PeerSocketAddress> peerSocketAddresses) {
        final FutureDone<PeerSocketAddress> futureDone = new FutureDone<PeerSocketAddress>();
        FuturePing[] forks = new FuturePing[peerSocketAddresses.size()];
        int index = 0;
        for (PeerSocketAddress psa : peerSocketAddresses) {
            if (psa == null) continue;
            InetSocketAddress inetSocketAddress = PeerSocketAddress.createSocketUDP(psa);
            PingBuilder pingBuilder = this.pingBuilderFactory.create();
            forks[index++] = pingBuilder.inetAddress(inetSocketAddress.getAddress()).port(inetSocketAddress.getPort()).start();
        }
        FutureForkJoin<FuturePing> ffk = new FutureForkJoin<FuturePing>(1, true, new AtomicReferenceArray<FuturePing>(forks));
        ffk.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureForkJoin<FuturePing>>(){

            @Override
            public void operationComplete(FutureForkJoin<FuturePing> future) throws Exception {
                if (future.isSuccess()) {
                    futureDone.done(future.first().remotePeer().peerSocketAddress());
                } else {
                    futureDone.failed(future);
                }
            }
        });
        return futureDone;
    }

    public void sendSelf(final FutureResponse futureResponse, final Message message) {
        LOG.debug("Handle message that is intended for the sender itself {}", (Object)message);
        message.sendSelf();
        Message copy = message.duplicate(new DataFilter(){

            @Override
            public Data filter(Data data, boolean isConvertMeta, boolean isReply) {
                Data copyData = data.duplicate();
                if (copyData.isSigned() && copyData.signature() == null) {
                    copyData.protectEntry(message.privateKey());
                }
                copyData.validFromMillis(System.currentTimeMillis());
                return copyData;
            }
        });
        DispatchHandler handler = this.dispatcher.associatedHandler(copy);
        handler.forwardMessage(copy, null, new Responder(){

            @Override
            public void response(Message responseMessage) {
                Message copy = responseMessage.duplicate(Sender.this.dataFilterTTL);
                futureResponse.response(copy);
            }

            @Override
            public void failed(Message.Type type, String reason) {
                futureResponse.failed("Failed with type " + type.name() + ". Reason: " + reason);
            }

            @Override
            public void responseFireAndForget() {
                futureResponse.emptyResponse();
            }
        });
    }

    private ChannelFuture sendTCPCreateChannel(InetSocketAddress recipient, ChannelCreator channelCreator, PeerConnection peerConnection, ChannelHandler handler, TimeoutFactory timeoutHandler, int connectTimeoutMillis, FutureResponse futureResponse) {
        LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>> handlers;
        if (timeoutHandler != null) {
            handlers = new LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>>();
            handlers.put("timeout0", new Pair<Object, ChannelHandler>(null, timeoutHandler.idleStateHandlerTomP2P()));
            handlers.put("timeout1", new Pair<Object, ChannelHandler>(null, timeoutHandler.timeHandler()));
        } else {
            handlers = new LinkedHashMap();
        }
        handlers.put("decoder", new Pair<Object, TomP2PCumulationTCP>(null, new TomP2PCumulationTCP(this.channelClientConfiguration.signatureFactory())));
        handlers.put("encoder", new Pair<Object, TomP2POutbound>(null, new TomP2POutbound(false, this.channelClientConfiguration.signatureFactory())));
        if (peerConnection != null) {
            handlers.put("dispatcher", new Pair<Object, Dispatcher>(null, this.dispatcher));
        }
        if (timeoutHandler != null) {
            handlers.put("handler", new Pair<Object, ChannelHandler>(null, handler));
        }
        HeartBeat heartBeat = null;
        if (peerConnection != null) {
            heartBeat = new HeartBeat(peerConnection.heartBeatMillis(), TimeUnit.MILLISECONDS, this.pingBuilderFactory);
            handlers.put("heartbeat", new Pair<Object, HeartBeat>(null, heartBeat));
        }
        InetSocketAddress reflectedRecipient = Utils.natReflection(recipient, false, this.dispatcher.peerBean().serverPeerAddress());
        ChannelFuture channelFuture = channelCreator.createTCP(reflectedRecipient, connectTimeoutMillis, handlers, futureResponse);
        if (peerConnection != null && channelFuture != null) {
            peerConnection.channelFuture(channelFuture);
            heartBeat.peerConnection(peerConnection);
        }
        return channelFuture;
    }

    private ChannelFuture sendTCPPeerConnection(PeerConnection peerConnection, ChannelHandler handler, ChannelCreator channelCreator, FutureResponse futureResponse) {
        ChannelFuture channelFuture = peerConnection.channelFuture();
        if (channelCreator != null) {
            channelCreator.setupCloseListener(channelFuture, futureResponse);
        }
        ChannelPipeline pipeline = channelFuture.channel().pipeline();
        this.addOrReplace(pipeline, "dispatcher", "handler", handler);
        return channelFuture;
    }

    private boolean addOrReplace(ChannelPipeline pipeline, String before, String name, ChannelHandler channelHandler) {
        List names = pipeline.names();
        if (names.contains(name)) {
            pipeline.replace(name, name, channelHandler);
            return false;
        }
        if (before == null) {
            pipeline.addFirst(name, channelHandler);
        } else {
            pipeline.addBefore(before, name, channelHandler);
        }
        return true;
    }

    public void sendUDP(SimpleChannelInboundHandler<Message> handler, FutureResponse futureResponse, Message message, ChannelCreator channelCreator, int idleUDPSeconds, boolean broadcast) {
        PeerStatistic peerStatistic;
        if (futureResponse.isCompleted()) {
            return;
        }
        LocalMap localMap = this.peerBean.localMap();
        if (localMap != null && (peerStatistic = localMap.translate(message.recipient())) != null) {
            message.recipient(peerStatistic.peerAddress());
        }
        this.removePeerIfFailed(futureResponse, message);
        if (message.sender().isRelayed()) {
            message.peerSocketAddresses(message.sender().peerSocketAddresses());
        }
        boolean isFireAndForget = handler == null;
        Map<String, Pair<EventExecutorGroup, ChannelHandler>> handlers = this.configureHandlers(handler, futureResponse, idleUDPSeconds, isFireAndForget);
        if (message.command() != RPC.Commands.PING.getNr() && message.command() != RPC.Commands.NEIGHBOR.getNr() && message.recipient().isRelayed() && message.sender().isRelayed()) {
            if (this.peerBean.holePunchInitiator() != null) {
                this.handleHolePunch(futureResponse, message, channelCreator, idleUDPSeconds);
                return;
            }
            LOG.debug("No hole punching possible, because There is no PeerNAT.");
        }
        futureResponse.startRTTMeasurement(true);
        try {
            ChannelFuture channelFuture;
            switch (this.sendBehavior.udpSendBehavior(message)) {
                case DIRECT: {
                    channelFuture = channelCreator.createUDP(broadcast, handlers, futureResponse);
                    break;
                }
                case RELAY: {
                    ArrayList<PeerSocketAddress> psa = new ArrayList<PeerSocketAddress>(message.recipient().peerSocketAddresses());
                    LOG.debug("send neighbor request to random relay peer {}", psa);
                    if (!psa.isEmpty()) {
                        PeerSocketAddress ps = (PeerSocketAddress)psa.get(this.random.nextInt(psa.size()));
                        message.recipientRelay(message.recipient().changePeerSocketAddress(ps));
                        channelFuture = channelCreator.createUDP(broadcast, handlers, futureResponse);
                        break;
                    }
                    futureResponse.failed("Peer is relayed, but no relay given");
                    return;
                }
                case SELF: {
                    this.sendSelf(futureResponse, message);
                    channelFuture = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("UDP messages are not allowed to send over RCON");
                }
            }
            this.afterConnect(futureResponse, message, channelFuture, handler == null);
        }
        catch (UnsupportedOperationException e) {
            LOG.warn(e.getMessage());
            futureResponse.failed(e);
        }
    }

    public void handleHolePunch(final FutureResponse futureResponse, Message message, ChannelCreator channelCreator, int idleUDPSeconds) {
        FutureDone<Message> fDone = this.peerBean.holePunchInitiator().handleHolePunch(channelCreator, idleUDPSeconds, futureResponse, message);
        fDone.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Message>>(){

            @Override
            public void operationComplete(FutureDone<Message> future) throws Exception {
                if (future.isSuccess()) {
                    futureResponse.response(future.object());
                } else {
                    LOG.error("Message could not be sent with hole punching!");
                    futureResponse.failed(future.failedReason());
                }
            }

            @Override
            public void exceptionCaught(Throwable t) throws Exception {
                futureResponse.failed(t);
            }
        });
    }

    public Map<String, Pair<EventExecutorGroup, ChannelHandler>> configureHandlers(SimpleChannelInboundHandler<Message> handler, FutureResponse futureResponse, int idleUDPSeconds, boolean isFireAndForget) {
        LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>> handlers;
        if (isFireAndForget) {
            int nrTCPHandlers = 3;
            handlers = new LinkedHashMap<String, Pair<EventExecutorGroup, ChannelHandler>>(3);
        } else {
            int nrTCPHandlers = 7;
            handlers = new LinkedHashMap(7);
            TimeoutFactory timeoutHandler = this.createTimeoutHandler(futureResponse, idleUDPSeconds, isFireAndForget);
            handlers.put("timeout0", new Pair<Object, ChannelHandler>(null, timeoutHandler.idleStateHandlerTomP2P()));
            handlers.put("timeout1", new Pair<Object, ChannelHandler>(null, timeoutHandler.timeHandler()));
        }
        handlers.put("decoder", new Pair<Object, TomP2PSinglePacketUDP>(null, new TomP2PSinglePacketUDP(this.channelClientConfiguration.signatureFactory())));
        handlers.put("encoder", new Pair<Object, TomP2POutbound>(null, new TomP2POutbound(false, this.channelClientConfiguration.signatureFactory())));
        if (!isFireAndForget) {
            handlers.put("handler", new Pair<Object, SimpleChannelInboundHandler<Message>>(null, handler));
        }
        return handlers;
    }

    private TimeoutFactory createTimeoutHandler(FutureResponse futureResponse, int idleMillis, boolean fireAndForget) {
        return fireAndForget ? null : new TimeoutFactory(futureResponse, idleMillis, this.peerStatusListeners, "Sender");
    }

    public void afterConnect(final FutureResponse futureResponse, final Message message, ChannelFuture channelFuture, final boolean fireAndForget) {
        if (channelFuture == null) {
            futureResponse.failed("could not create a " + (message.isUdp() ? "UDP" : "TCP") + " channel");
            return;
        }
        LOG.debug("about to connect to {} with channel {}, ff={}", new Object[]{message.recipient(), channelFuture.channel(), fireAndForget});
        final Cancel connectCancel = Sender.createCancel(channelFuture);
        futureResponse.addCancel(connectCancel);
        channelFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                futureResponse.removeCancel(connectCancel);
                if (future.isSuccess()) {
                    ChannelFuture writeFuture = future.channel().writeAndFlush((Object)message);
                    Sender.this.afterSend(writeFuture, futureResponse, fireAndForget);
                } else {
                    LOG.debug("Channel creation failed", future.cause());
                    futureResponse.failed("Channel creation failed " + future.channel() + "/" + future.cause());
                    if (!(future.cause() instanceof CancellationException || future.cause() instanceof ClosedChannelException || future.cause() instanceof ConnectException)) {
                        LOG.warn("Channel creation failed to {} for {}", (Object)future.channel(), (Object)message);
                    }
                }
            }
        });
    }

    private void afterSend(ChannelFuture writeFuture, final FutureResponse futureResponse, final boolean fireAndForget) {
        final Cancel writeCancel = Sender.createCancel(writeFuture);
        writeFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                futureResponse.removeCancel(writeCancel);
                if (!future.isSuccess()) {
                    futureResponse.failedLater(future.cause());
                    Sender.this.reportFailed(futureResponse, future.channel().close());
                    LOG.warn("Failed to write channel the request {} {}", (Object)futureResponse.request(), (Object)future.cause());
                }
                if (fireAndForget) {
                    futureResponse.responseLater(null);
                    LOG.debug("fire and forget, close channel now {}, {}", (Object)futureResponse.request(), (Object)future.channel());
                    Sender.this.reportMessage(futureResponse, future.channel().close());
                }
            }
        });
    }

    private void reportFailed(final FutureResponse futureResponse, ChannelFuture close) {
        close.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture arg0) throws Exception {
                futureResponse.responseNow();
            }
        });
    }

    private void reportMessage(final FutureResponse futureResponse, ChannelFuture close) {
        close.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture arg0) throws Exception {
                futureResponse.responseNow();
            }
        });
    }

    private static Cancel createCancel(final ChannelFuture channelFuture) {
        return new Cancel(){

            @Override
            public void cancel() {
                channelFuture.cancel(true);
            }
        };
    }

    private void removePeerIfFailed(FutureResponse futureResponse, final Message message) {
        futureResponse.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isFailed() && !message.recipient().isRelayed()) {
                    List list = Sender.this.peerStatusListeners;
                    synchronized (list) {
                        for (PeerStatusListener peerStatusListener : Sender.this.peerStatusListeners) {
                            peerStatusListener.peerFailed(message.recipient(), new PeerException(future));
                        }
                    }
                }
            }
        });
    }

    public ConcurrentHashMap<Integer, FutureResponse> cachedRequests() {
        return this.cachedRequests;
    }

    public List<PeerStatusListener> peerStatusListeners() {
        return this.peerStatusListeners;
    }
}

