/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class IdleStateHandlerTomP2P
extends ChannelDuplexHandler {
    private final long allIdleTimeMillis;
    private volatile long lastReadTime;
    private volatile long lastWriteTime;
    private volatile ScheduledFuture<?> allIdleTimeout;
    private volatile int state;

    public IdleStateHandlerTomP2P(int allIdleTimeSeconds) {
        this(allIdleTimeSeconds, TimeUnit.SECONDS);
    }

    public IdleStateHandlerTomP2P(long allIdleTime, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.allIdleTimeMillis = allIdleTime <= 0L ? 0L : Math.max(unit.toMillis(allIdleTime), 1L);
    }

    public long getAllIdleTimeInMillis() {
        return this.allIdleTimeMillis;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            this.initialize(ctx);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive()) {
            this.initialize(ctx);
        }
        super.channelRegistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.lastReadTime = System.currentTimeMillis();
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                IdleStateHandlerTomP2P.this.lastWriteTime = System.currentTimeMillis();
            }
        });
        ctx.write(msg, promise);
    }

    private void initialize(ChannelHandlerContext ctx) {
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        EventExecutor loop = ctx.executor();
        this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
        if (this.allIdleTimeMillis > 0L) {
            this.allIdleTimeout = loop.schedule((Runnable)new AllIdleTimeoutTask(ctx), this.allIdleTimeMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void destroy() {
        this.state = 2;
        if (this.allIdleTimeout != null) {
            this.allIdleTimeout.cancel(false);
            this.allIdleTimeout = null;
        }
    }

    private void channelIdle(ChannelHandlerContext ctx) throws Exception {
        ctx.fireUserEventTriggered((Object)this);
    }

    private final class AllIdleTimeoutTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        AllIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            long lastIoTime = Math.max(IdleStateHandlerTomP2P.this.lastReadTime, IdleStateHandlerTomP2P.this.lastWriteTime);
            long nextDelay = IdleStateHandlerTomP2P.this.allIdleTimeMillis - (currentTime - lastIoTime);
            if (nextDelay <= 0L) {
                IdleStateHandlerTomP2P.this.allIdleTimeout = (ScheduledFuture)this.ctx.executor().schedule((Runnable)this, IdleStateHandlerTomP2P.this.allIdleTimeMillis, TimeUnit.MILLISECONDS);
                try {
                    IdleStateHandlerTomP2P.this.channelIdle(this.ctx);
                }
                catch (Throwable t) {
                    this.ctx.fireExceptionCaught(t);
                }
            } else {
                IdleStateHandlerTomP2P.this.allIdleTimeout = (ScheduledFuture)this.ctx.executor().schedule((Runnable)this, nextDelay, TimeUnit.MILLISECONDS);
            }
        }
    }
}

