/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.tomp2p.connection.ChannelClientConfiguration;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.rpc.RPC;
import net.tomp2p.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelCreator {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelCreator.class);
    private final EventLoopGroup workerGroup;
    private final ChannelGroup recipients = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final int maxPermitsUDP;
    private final int maxPermitsTCP;
    private final Semaphore semaphoreUPD;
    private final Semaphore semaphoreTCP;
    private final ReadWriteLock readWriteLockUDP = new ReentrantReadWriteLock(true);
    private final Lock readUDP = this.readWriteLockUDP.readLock();
    private final Lock writeUDP = this.readWriteLockUDP.writeLock();
    private final ReadWriteLock readWriteLockTCP = new ReentrantReadWriteLock(true);
    private final Lock readTCP = this.readWriteLockTCP.readLock();
    private final Lock writeTCP = this.readWriteLockTCP.writeLock();
    private final FutureDone<Void> futureChannelCreationDone;
    private final ChannelClientConfiguration channelClientConfiguration;
    private EventExecutorGroup handlerExecutor;
    private boolean shutdownUDP = false;
    private boolean shutdownTCP = false;

    ChannelCreator(EventLoopGroup workerGroup, FutureDone<Void> futureChannelCreationDone, int maxPermitsUDP, int maxPermitsTCP, ChannelClientConfiguration channelClientConfiguration) {
        this.workerGroup = workerGroup;
        this.futureChannelCreationDone = futureChannelCreationDone;
        this.maxPermitsUDP = maxPermitsUDP;
        this.maxPermitsTCP = maxPermitsTCP;
        this.semaphoreUPD = new Semaphore(maxPermitsUDP);
        this.semaphoreTCP = new Semaphore(maxPermitsTCP);
        this.channelClientConfiguration = channelClientConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture createUDP(boolean broadcast, Map<String, Pair<EventExecutorGroup, ChannelHandler>> channelHandlers, FutureResponse futureResponse) {
        this.readUDP.lock();
        try {
            if (this.shutdownUDP) {
                ChannelFuture channelFuture = null;
                return channelFuture;
            }
            if (!this.semaphoreUPD.tryAcquire()) {
                LOG.error("Tried to acquire more resources (UDP) than announced! Announced {}", (Object)this.maxPermitsUDP);
                throw new RuntimeException("Tried to acquire more resources (UDP) than announced!");
            }
            Bootstrap b = new Bootstrap();
            b.group(this.workerGroup);
            b.channel(NioDatagramChannel.class);
            b.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(ConnectionBean.UDP_LIMIT));
            if (broadcast) {
                b.option(ChannelOption.SO_BROADCAST, (Object)true);
            }
            Map<String, Pair<EventExecutorGroup, ChannelHandler>> channelHandlers2 = this.channelClientConfiguration.pipelineFilter().filter(channelHandlers, false, true);
            this.addHandlers(b, channelHandlers2);
            ChannelFuture channelFuture = b.bind((SocketAddress)new InetSocketAddress(this.channelClientConfiguration.senderUDP(), 0));
            this.recipients.add((Object)channelFuture.channel());
            this.setupCloseListener(channelFuture, this.semaphoreUPD, futureResponse);
            ChannelFuture channelFuture2 = channelFuture;
            return channelFuture2;
        }
        finally {
            this.readUDP.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture createTCP(SocketAddress socketAddress, int connectionTimeoutMillis, Map<String, Pair<EventExecutorGroup, ChannelHandler>> channelHandlers, FutureResponse futureResponse) {
        this.readTCP.lock();
        try {
            if (this.shutdownTCP) {
                ChannelFuture channelFuture = null;
                return channelFuture;
            }
            if (!this.semaphoreTCP.tryAcquire()) {
                LOG.error("Tried to acquire more resources (TCP) than announced!");
                throw new RuntimeException("Tried to acquire more resources (TCP) than announced!");
            }
            Bootstrap b = new Bootstrap();
            b.group(this.workerGroup);
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectionTimeoutMillis);
            b.option(ChannelOption.TCP_NODELAY, (Object)true);
            b.option(ChannelOption.SO_LINGER, (Object)0);
            b.option(ChannelOption.SO_REUSEADDR, (Object)true);
            Map<String, Pair<EventExecutorGroup, ChannelHandler>> channelHandlers2 = this.channelClientConfiguration.pipelineFilter().filter(channelHandlers, true, true);
            this.addHandlers(b, channelHandlers2);
            ChannelFuture channelFuture = b.connect(socketAddress, (SocketAddress)new InetSocketAddress(this.channelClientConfiguration.senderTCP(), 0));
            this.recipients.add((Object)channelFuture.channel());
            this.setupCloseListener(channelFuture, this.semaphoreTCP, futureResponse);
            ChannelFuture channelFuture2 = channelFuture;
            return channelFuture2;
        }
        finally {
            this.readTCP.unlock();
        }
    }

    private void addHandlers(Bootstrap bootstrap, final Map<String, Pair<EventExecutorGroup, ChannelHandler>> channelHandlers) {
        bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                for (Map.Entry entry : channelHandlers.entrySet()) {
                    if (((String)entry.getKey()).equals("handler")) {
                        ChannelCreator.this.handlerExecutor = (EventExecutorGroup)((Pair)entry.getValue()).element0();
                    }
                    if (((Pair)entry.getValue()).element0() != null) {
                        ch.pipeline().addLast((EventExecutorGroup)((Pair)entry.getValue()).element0(), (String)entry.getKey(), (ChannelHandler)((Pair)entry.getValue()).element1());
                        continue;
                    }
                    ch.pipeline().addLast((String)entry.getKey(), (ChannelHandler)((Pair)entry.getValue()).element1());
                }
            }
        });
    }

    private ChannelFuture setupCloseListener(ChannelFuture channelFuture, final Semaphore semaphore, final FutureResponse futureResponse) {
        channelFuture.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        semaphore.release();
                        Message request = futureResponse.request();
                        if (request != null && futureResponse.responseMessage() == null && request.recipient().isSlow() && request.command() != RPC.Commands.PING.getNr() && request.command() != RPC.Commands.NEIGHBOR.getNr()) {
                            LOG.debug("Ignoring channel close event because recipient is slow peer");
                        } else {
                            futureResponse.responseNow();
                        }
                    }
                };
                if (ChannelCreator.this.handlerExecutor == null) {
                    runner.run();
                } else {
                    ChannelCreator.this.handlerExecutor.submit(runner);
                }
            }
        });
        return channelFuture;
    }

    public ChannelFuture setupCloseListener(ChannelFuture channelFuture, final FutureResponse futureResponse) {
        channelFuture.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                futureResponse.responseNow();
            }
        });
        return channelFuture;
    }

    public boolean isShutdown() {
        return this.shutdownTCP || this.shutdownUDP;
    }

    public FutureDone<Void> shutdown() {
        this.writeUDP.lock();
        this.writeTCP.lock();
        try {
            if (this.shutdownTCP || this.shutdownUDP) {
                this.shutdownFuture().failed("already shutting down");
                FutureDone<Void> futureDone = this.shutdownFuture();
                return futureDone;
            }
            this.shutdownUDP = true;
            this.shutdownTCP = true;
        }
        finally {
            this.writeTCP.unlock();
            this.writeUDP.unlock();
        }
        this.recipients.close().addListener((GenericFutureListener)new GenericFutureListener<ChannelGroupFuture>(){

            public void operationComplete(ChannelGroupFuture future) throws Exception {
                ChannelCreator.this.semaphoreUPD.acquireUninterruptibly(ChannelCreator.this.maxPermitsUDP);
                ChannelCreator.this.semaphoreTCP.acquireUninterruptibly(ChannelCreator.this.maxPermitsTCP);
                ChannelCreator.this.shutdownFuture().done();
            }
        });
        return this.shutdownFuture();
    }

    public FutureDone<Void> shutdownFuture() {
        return this.futureChannelCreationDone;
    }

    public int availableUDPPermits() {
        return this.semaphoreUPD.availablePermits();
    }

    public int availableTCPPermits() {
        return this.semaphoreTCP.availablePermits();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("sem-udp:");
        sb.append(this.semaphoreUPD.availablePermits());
        sb.append(",sem-tcp:");
        sb.append(this.semaphoreTCP.availablePermits());
        sb.append(",addrUDP:");
        sb.append(this.semaphoreUPD);
        return sb.toString();
    }
}

