/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.tracker;

import java.util.concurrent.ScheduledFuture;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.tracker.AddTrackerBuilder;
import net.tomp2p.tracker.DistributedTracker;
import net.tomp2p.tracker.GetTrackerBuilder;
import net.tomp2p.tracker.PeerExchange;
import net.tomp2p.tracker.TrackerRPC;
import net.tomp2p.tracker.TrackerStorage;

public class PeerTracker {
    private final Peer peer;
    private final ScheduledFuture<?> scheduledFuture;
    private final TrackerRPC trackerRPC;
    private final TrackerStorage trackerStorage;
    private final PeerExchange peerExchange;
    private final DistributedTracker distributedTracker;

    public PeerTracker(Peer peer, ScheduledFuture<?> scheduledFuture, TrackerRPC trackerRPC, TrackerStorage trackerStorage, PeerExchange peerExchange, DistributedTracker distributedTracker) {
        this.peer = peer;
        this.scheduledFuture = scheduledFuture;
        this.trackerRPC = trackerRPC;
        this.trackerStorage = trackerStorage;
        this.peerExchange = peerExchange;
        this.distributedTracker = distributedTracker;
    }

    public TrackerRPC trackerRPC() {
        return this.trackerRPC;
    }

    public DistributedTracker distributedTracker() {
        return this.distributedTracker;
    }

    public TrackerStorage trackerStorage() {
        return this.trackerStorage;
    }

    public PeerExchange peerExchange() {
        return this.peerExchange;
    }

    public PeerMap peerMap() {
        return this.peer.peerBean().peerMap();
    }

    public PeerAddress peerAddress() {
        return this.peer.peerAddress();
    }

    public Peer peer() {
        return this.peer;
    }

    public AddTrackerBuilder addTracker(Number160 locationKey) {
        return new AddTrackerBuilder(this, locationKey);
    }

    public GetTrackerBuilder getTracker(Number160 locationKey) {
        return new GetTrackerBuilder(this, locationKey);
    }

    public void shutdown() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
    }
}

