/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.dht;

import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.dht.DHTBuilder;
import net.tomp2p.dht.FutureRemove;
import net.tomp2p.dht.PeerDHT;
import net.tomp2p.p2p.builder.SearchableBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;

public class RemoveBuilder
extends DHTBuilder<RemoveBuilder>
implements SearchableBuilder {
    private static final FutureRemove FUTURE_SHUTDOWN = (FutureRemove)new FutureRemove(null).failed("remove builder - peer is shutting down");
    private Collection<Number160> contentKeys;
    private Collection<Number640> keys;
    private Number160 contentKey;
    private boolean all = false;
    private boolean returnResults = false;
    private Number640 from;
    private Number640 to;
    private boolean fastGet = true;
    private boolean failIfNotFound = false;

    public RemoveBuilder(PeerDHT peer, Number160 locationKey) {
        super(peer, locationKey);
        this.self(this);
    }

    public Collection<Number160> contentKeys() {
        return this.contentKeys;
    }

    public RemoveBuilder contentKeys(Collection<Number160> contentKeys) {
        this.contentKeys = contentKeys;
        return this;
    }

    public Collection<Number640> keys() {
        return this.keys;
    }

    public RemoveBuilder keys(Collection<Number640> keys) {
        this.keys = keys;
        return this;
    }

    public Number160 contentKey() {
        return this.contentKey;
    }

    public RemoveBuilder contentKey(Number160 contentKey) {
        this.contentKey = contentKey;
        return this;
    }

    public boolean isAll() {
        return this.all;
    }

    public RemoveBuilder all(boolean all) {
        this.all = all;
        return this;
    }

    public RemoveBuilder all() {
        this.all = true;
        return this;
    }

    public boolean isReturnResults() {
        return this.returnResults;
    }

    public RemoveBuilder returnResults(boolean returnResults) {
        this.returnResults = returnResults;
        return this;
    }

    public RemoveBuilder returnResults() {
        this.returnResults = true;
        return this;
    }

    public RemoveBuilder from(Number640 from) {
        this.domainKey = from.domainKey();
        this.from = from;
        return this;
    }

    public Number640 from() {
        return this.from;
    }

    public RemoveBuilder to(Number640 to) {
        this.domainKey = to.domainKey();
        this.to = to;
        return this;
    }

    public Number640 to() {
        return this.to;
    }

    public boolean isRange() {
        return this.from != null && this.to != null;
    }

    public boolean isFastGet() {
        return this.fastGet;
    }

    public RemoveBuilder fastGet(boolean fastGet) {
        this.fastGet = fastGet;
        return this;
    }

    public RemoveBuilder fastGet() {
        this.fastGet = true;
        return this;
    }

    public boolean isFailIfNotFound() {
        return this.failIfNotFound;
    }

    public RemoveBuilder failIfNotFound(boolean failIfNotFound) {
        this.failIfNotFound = failIfNotFound;
        return this;
    }

    public RemoveBuilder failIfNotFound() {
        this.failIfNotFound = true;
        return this;
    }

    public FutureRemove start() {
        if (this.peer.peer().isShutdown()) {
            return FUTURE_SHUTDOWN;
        }
        this.preBuild("remove-builder");
        if (this.all) {
            this.contentKeys = null;
        } else if (this.contentKeys == null && !this.all && !this.isRange()) {
            this.contentKeys = new ArrayList<Number160>(1);
            if (this.contentKey == null) {
                this.contentKey = Number160.ZERO;
            }
            this.contentKeys.add(this.contentKey);
        }
        return this.peer.distributedHashTable().remove(this);
    }
}

