/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.tcp.buffered;

import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.buffer.BufferedRelayServer;
import net.tomp2p.relay.buffer.MessageBufferConfiguration;
import net.tomp2p.relay.tcp.TCPRelayServer;
import net.tomp2p.rpc.RPC;

public class BufferedTCPRelayServer
extends BufferedRelayServer {
    private final PeerConnection connection;
    private final TCPRelayServer tcpRelayServer;

    protected BufferedTCPRelayServer(PeerConnection connection, Peer peer, MessageBufferConfiguration bufferConfig) {
        super(peer, connection.remotePeer(), RelayType.BUFFERED_OPENTCP, bufferConfig);
        this.connection = connection;
        this.tcpRelayServer = new TCPRelayServer(connection, peer);
        connection.closeFuture().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

            public void operationComplete(FutureDone<Void> future) throws Exception {
                BufferedTCPRelayServer.this.notifyOfflineListeners();
            }
        });
    }

    @Override
    public void onBufferFull() {
        Buffer messages = this.collectBufferedMessages();
        Message message = this.createMessage(this.connection.remotePeer(), RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_4);
        message.buffer(messages);
        this.tcpRelayServer.forwardToUnreachable(message);
    }

    @Override
    protected void onBufferCollected() {
    }

    @Override
    protected boolean isAlive() {
        return this.connection.isOpen();
    }
}

