/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.relay.BaseRelayClient;
import net.tomp2p.relay.ConcurrentCacheSet;
import net.tomp2p.relay.FutureRelay;
import net.tomp2p.relay.RelayClientConfig;
import net.tomp2p.relay.RelayListener;
import net.tomp2p.relay.RelayRPC;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.relay.buffer.BufferRequestListener;
import net.tomp2p.relay.buffer.BufferedRelayClient;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedRelay
implements BufferRequestListener {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedRelay.class);
    private final Peer peer;
    private final RelayRPC relayRPC;
    private final List<BaseRelayClient> relayClients;
    private final Set<PeerAddress> failedRelays;
    private final Collection<RelayListener> relayListeners;
    private final RelayClientConfig relayConfig;

    public DistributedRelay(Peer peer, RelayRPC relayRPC, RelayClientConfig relayConfig) {
        this.peer = peer;
        this.relayRPC = relayRPC;
        this.relayConfig = relayConfig;
        this.relayClients = Collections.synchronizedList(new ArrayList());
        this.failedRelays = new ConcurrentCacheSet<PeerAddress>(relayConfig.failedRelayWaitTime());
        this.relayListeners = Collections.synchronizedList(new ArrayList(1));
    }

    public RelayClientConfig relayConfig() {
        return this.relayConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseRelayClient> relayClients() {
        List<BaseRelayClient> list = this.relayClients;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<BaseRelayClient>(this.relayClients));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelayListener(RelayListener relayListener) {
        Collection<RelayListener> collection = this.relayListeners;
        synchronized (collection) {
            this.relayListeners.add(relayListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureForkJoin<FutureDone<Void>> shutdown() {
        AtomicReferenceArray<FutureDone<Void>> futureDones;
        Collection<Object> collection = this.relayClients;
        synchronized (collection) {
            futureDones = new AtomicReferenceArray<FutureDone<Void>>(this.relayClients.size());
            for (int i = 0; i < this.relayClients.size(); ++i) {
                futureDones.set(i, this.relayClients.get(i).shutdown());
            }
        }
        collection = this.relayListeners;
        synchronized (collection) {
            this.relayListeners.clear();
        }
        return new FutureForkJoin(futureDones);
    }

    public FutureRelay setupRelays(FutureRelay futureRelay) {
        ArrayList<PeerAddress> relayCandidates;
        if (this.relayConfig.manualRelays().isEmpty()) {
            relayCandidates = this.peer.distributedRouting().peerMap().all();
            relayCandidates.removeAll(this.failedRelays);
        } else {
            relayCandidates = new ArrayList<PeerAddress>(this.relayConfig.manualRelays());
        }
        this.filterRelayCandidates(relayCandidates);
        this.setupPeerConnections(futureRelay, relayCandidates);
        return futureRelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterRelayCandidates(Collection<PeerAddress> relayCandidates) {
        Iterator<PeerAddress> iterator = relayCandidates.iterator();
        while (iterator.hasNext()) {
            PeerAddress pa = iterator.next();
            if (pa.isRelayed()) {
                iterator.remove();
                continue;
            }
            List<BaseRelayClient> list = this.relayClients;
            synchronized (list) {
                for (BaseRelayClient relay : this.relayClients) {
                    if (!relay.relayAddress().equals((Object)pa)) continue;
                    iterator.remove();
                    break;
                }
            }
        }
        LOG.trace("Found {} addtional relay candidates", (Object)relayCandidates.size());
    }

    private void setupPeerConnections(FutureRelay futureRelay, List<PeerAddress> relayCandidates) {
        int nrOfRelays = Math.min(this.relayConfig.type().maxRelayCount() - this.relayClients.size(), relayCandidates.size());
        if (nrOfRelays > 0) {
            LOG.debug("Setting up {} relays", (Object)nrOfRelays);
            FutureDone[] futureDones = new FutureDone[nrOfRelays];
            AtomicReferenceArray<FutureDone<PeerConnection>> relayConnectionFutures = new AtomicReferenceArray<FutureDone<PeerConnection>>(futureDones);
            this.setupPeerConnectionsRecursive(relayConnectionFutures, relayCandidates, nrOfRelays, futureRelay, 0, new StringBuilder());
        } else if (relayCandidates.isEmpty()) {
            futureRelay.failed("done");
        } else {
            futureRelay.done(Collections.<BaseRelayClient>emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPeerConnectionsRecursive(final AtomicReferenceArray<FutureDone<PeerConnection>> futures, final List<PeerAddress> relayCandidates, final int numberOfRelays, final FutureRelay futureRelay, final int fail, final StringBuilder status) {
        int active = 0;
        for (int i = 0; i < numberOfRelays; ++i) {
            if (futures.get(i) == null) {
                PeerAddress candidate = null;
                List<PeerAddress> list = relayCandidates;
                synchronized (list) {
                    if (!relayCandidates.isEmpty()) {
                        candidate = relayCandidates.remove(0);
                    }
                }
                if (candidate == null) continue;
                FutureDone<PeerConnection> futureDone = this.sendMessage(candidate);
                futures.set(i, futureDone);
                ++active;
                continue;
            }
            ++active;
        }
        if (active == 0) {
            this.updatePeerAddress();
            futureRelay.failed("No candidates: " + status.toString());
            return;
        }
        if (fail > this.relayConfig.maxFail()) {
            this.updatePeerAddress();
            futureRelay.failed("Maxfail: " + status.toString());
            return;
        }
        FutureForkJoin ffj = new FutureForkJoin(active, false, futures);
        ffj.addListener((BaseFutureListener)new BaseFutureAdapter<FutureForkJoin<FutureDone<PeerConnection>>>(){

            public void operationComplete(FutureForkJoin<FutureDone<PeerConnection>> futureForkJoin) throws Exception {
                if (futureForkJoin.isSuccess()) {
                    DistributedRelay.this.updatePeerAddress();
                    futureRelay.done(DistributedRelay.this.relayClients());
                } else if (!DistributedRelay.this.peer.isShutdown()) {
                    DistributedRelay.this.setupPeerConnectionsRecursive(futures, relayCandidates, numberOfRelays, futureRelay, fail + 1, status.append(futureForkJoin.failedReason()).append(" "));
                } else {
                    futureRelay.failed((BaseFuture)futureForkJoin);
                }
            }
        });
    }

    private FutureDone<PeerConnection> sendMessage(final PeerAddress candidate) {
        final FutureDone futureDone = new FutureDone();
        final Message message = this.relayRPC.createMessage(candidate, RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_1);
        message.keepAlive(this.relayConfig.type().keepConnectionOpen());
        message.intValue(this.relayConfig.type().ordinal());
        this.relayConfig.prepareSetupMessage(message);
        LOG.debug("Setting up relay connection to peer {}, message {}", (Object)candidate, (Object)message);
        FuturePeerConnection fpc = this.peer.createPeerConnection(candidate);
        fpc.addListener((BaseFutureListener)new BaseFutureAdapter<FuturePeerConnection>(){

            public void operationComplete(FuturePeerConnection futurePeerConnection) throws Exception {
                if (futurePeerConnection.isSuccess()) {
                    final PeerConnection peerConnection = (PeerConnection)futurePeerConnection.object();
                    FutureResponse response = RelayUtils.send(peerConnection, DistributedRelay.this.peer.peerBean(), DistributedRelay.this.peer.connectionBean(), message);
                    response.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                        public void operationComplete(FutureResponse future) throws Exception {
                            if (future.isSuccess()) {
                                DistributedRelay.this.setupAddRelays(peerConnection);
                                futureDone.done((Object)peerConnection);
                            } else {
                                LOG.debug("Peer {} denied relay request", (Object)candidate);
                                DistributedRelay.this.failedRelays.add(candidate);
                                futureDone.failed((BaseFuture)future);
                            }
                        }
                    });
                } else {
                    LOG.debug("Unable to setup a connection to relay peer {}", (Object)candidate);
                    DistributedRelay.this.failedRelays.add(candidate);
                    futureDone.failed((BaseFuture)futurePeerConnection);
                }
            }
        });
        return futureDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupAddRelays(PeerConnection peerConnection) {
        List<BaseRelayClient> list = this.relayClients;
        synchronized (list) {
            if (this.relayClients.size() >= this.relayConfig.type().maxRelayCount()) {
                LOG.warn("The maximum number ({}) of relays is reached", (Object)this.relayConfig.type().maxRelayCount());
                return;
            }
        }
        BaseRelayClient connection = this.relayConfig.createClient(peerConnection, this.peer);
        this.addCloseListener(connection);
        List<BaseRelayClient> list2 = this.relayClients;
        synchronized (list2) {
            LOG.debug("Adding peer {} as a relay", (Object)peerConnection.remotePeer());
            this.relayClients.add(connection);
            this.relayRPC.addClient(connection);
        }
    }

    private void addCloseListener(final BaseRelayClient connection) {
        connection.addCloseListener(new RelayListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void relayFailed(PeerAddress relayAddress) {
                DistributedRelay.this.relayClients.remove(connection);
                DistributedRelay.this.relayRPC.removeClient(connection);
                DistributedRelay.this.failedRelays.add(relayAddress);
                DistributedRelay.this.updatePeerAddress();
                Collection collection = DistributedRelay.this.relayListeners;
                synchronized (collection) {
                    for (RelayListener relayListener : DistributedRelay.this.relayListeners) {
                        relayListener.relayFailed(relayAddress);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePeerAddress() {
        boolean hasRelays = !this.relayClients.isEmpty();
        ArrayList<PeerSocketAddress> socketAddresses = new ArrayList<PeerSocketAddress>(this.relayClients.size());
        List<BaseRelayClient> list = this.relayClients;
        synchronized (list) {
            for (BaseRelayClient relay : this.relayClients) {
                PeerAddress pa = relay.relayAddress();
                socketAddresses.add(new PeerSocketAddress(pa.inetAddress(), pa.tcpPort(), pa.udpPort()));
            }
        }
        PeerAddress newAddress = this.peer.peerAddress().changeFirewalledTCP(!hasRelays).changeFirewalledUDP(!hasRelays).changeRelayed(hasRelays).changePeerSocketAddresses(socketAddresses).changeSlow(hasRelays && this.relayConfig.type().isSlow());
        this.peer.peerBean().serverPeerAddress(newAddress);
        LOG.debug("Updated peer address {}, isrelay = {}", (Object)newAddress, (Object)hasRelays);
    }

    @Override
    public FutureDone<Void> sendBufferRequest(String relayPeerId) {
        for (BaseRelayClient relayConnection : this.relayClients()) {
            String peerId = relayConnection.relayAddress().peerId().toString();
            if (!peerId.equals(relayPeerId) || !(relayConnection instanceof BufferedRelayClient)) continue;
            return ((BufferedRelayClient)relayConnection).sendBufferRequest();
        }
        LOG.warn("No connection to relay {} found. Ignoring the message.", (Object)relayPeerId);
        return (FutureDone)new FutureDone().failed("No connection to relay " + relayPeerId + " found");
    }
}

