/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.tomp2p.utils.ConcurrentCacheMap;

public class ConcurrentCacheSet<E>
implements Set<E> {
    private final Map<E, Boolean> map;

    public ConcurrentCacheSet() {
        this.map = new ConcurrentCacheMap();
    }

    public ConcurrentCacheSet(int timeToLive) {
        this.map = new ConcurrentCacheMap(timeToLive, 1024);
    }

    public ConcurrentCacheSet(int timeToLive, int maxEntries) {
        this.map = new ConcurrentCacheMap(timeToLive, maxEntries);
    }

    public ConcurrentCacheSet(int timeToLive, int maxEntries, boolean refreshTimeout) {
        this.map = new ConcurrentCacheMap(timeToLive, maxEntries, refreshTimeout);
    }

    @Override
    public boolean add(E e) {
        boolean alreadyContained = !this.map.containsKey(e);
        this.map.put(e, false);
        return alreadyContained;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E o : c) {
            changed |= this.add(o);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.keySet().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            changed |= this.remove(it.next());
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Set<E> diff = this.map.keySet();
        diff.removeAll(c);
        return this.removeAll(diff);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    public String toString() {
        return this.map.keySet().toString();
    }
}

