/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.synchronization;

import java.io.Serializable;
import net.tomp2p.storage.DataBuffer;

public class Instruction
implements Serializable {
    private static final long serialVersionUID = 112641683009283845L;
    private final int reference;
    private final DataBuffer literal;

    public Instruction(int reference) {
        this.reference = reference;
        this.literal = null;
    }

    public Instruction(DataBuffer literal) {
        this.reference = -1;
        this.literal = literal;
    }

    public int reference() {
        return this.reference;
    }

    public DataBuffer literal() {
        return this.literal;
    }

    public int length() {
        return this.literal == null ? 0 : this.literal.length();
    }

    public int hashCode() {
        return this.reference ^ (this.literal == null ? 0 : this.literal.hashCode());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Instruction)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Instruction i = (Instruction)obj;
        if (this.reference >= 0) {
            return this.reference == i.reference;
        }
        return this.literal.equals((Object)i.literal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("inst");
        if (this.literal != null) {
            sb.append("->l:");
            sb.append(this.literal.length());
        } else {
            sb.append("->r:");
            sb.append(this.reference);
        }
        return sb.toString();
    }
}

