/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.p2p.DefaultPeerStatisticComparator;
import net.tomp2p.p2p.PeerStatisticComparator;
import net.tomp2p.peers.DefaultMaintenance;
import net.tomp2p.peers.Maintenance;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerMapFilter;

public class PeerMapConfiguration {
    private final Number160 self;
    private int[] bagSizesVerified = new int[160];
    private int[] bagSizesOverflow = new int[160];
    private int offlineTimeout;
    private int shutdownTimeout;
    private int exceptionTimeout;
    private int offlineCount;
    private Collection<PeerMapFilter> peerMapFilters = new ArrayList<PeerMapFilter>(2);
    private Maintenance maintenance;
    private boolean peerVerification;
    private PeerStatisticComparator peerStatisticComparator;

    public PeerMapConfiguration(Number160 self) {
        this.self = self;
        this.setDoublingVerifiedBagSizes();
        this.setDoublingOverflowBagSizes();
        this.offlineTimeout = 60;
        this.shutdownTimeout = 20;
        this.exceptionTimeout = 120;
        this.offlineCount = 3;
        this.maintenance = new DefaultMaintenance(4, new int[]{2, 4, 8, 16, 32, 64});
        this.peerVerification = true;
        this.setPeerStatisticComparator(new DefaultPeerStatisticComparator());
    }

    public Number160 self() {
        return this.self;
    }

    public int getVerifiedBagSize(int bag) {
        return this.bagSizesVerified[bag];
    }

    public int[] getVerifiedBagSizes() {
        return this.bagSizesVerified;
    }

    public PeerMapConfiguration setFixedVerifiedBagSizes(int fixedVerifiedBagSize) {
        for (int i = 0; i < this.bagSizesVerified.length; ++i) {
            this.bagSizesVerified[i] = fixedVerifiedBagSize;
        }
        return this;
    }

    public PeerMapConfiguration setDoublingVerifiedBagSizes() {
        for (int i = 0; i < 160; ++i) {
            this.bagSizesVerified[i] = i < 156 ? 8 : 128 / (int)Math.pow(2.0, 160 - i - 1);
        }
        return this;
    }

    public PeerMapConfiguration setBagSizesVerified(int[] bagSizesVerified) {
        if (bagSizesVerified.length != 160) {
            throw new IllegalArgumentException("The array of bag sizes must have length of 160");
        }
        this.bagSizesVerified = bagSizesVerified;
        return this;
    }

    public int getOverflowBagSize(int bag) {
        return this.bagSizesOverflow[bag];
    }

    public int[] getOverflowBagSizes() {
        return this.bagSizesOverflow;
    }

    public PeerMapConfiguration setFixedOverflowBagSizes(int fixedOverflowBagSize) {
        for (int i = 0; i < this.bagSizesOverflow.length; ++i) {
            this.bagSizesOverflow[i] = fixedOverflowBagSize;
        }
        return this;
    }

    public PeerMapConfiguration setDoublingOverflowBagSizes() {
        for (int i = 0; i < 160; ++i) {
            this.bagSizesOverflow[i] = i < 156 ? 8 : 128 / (int)Math.pow(2.0, 160 - i - 1);
        }
        return this;
    }

    public PeerMapConfiguration setBagSizesOverflow(int[] bagSizesOverflow) {
        if (bagSizesOverflow.length != 160) {
            throw new IllegalArgumentException("The array of bag sizes must have length of 160");
        }
        this.bagSizesOverflow = bagSizesOverflow;
        return this;
    }

    public int offlineTimeout() {
        return this.offlineTimeout;
    }

    public PeerMapConfiguration offlineTimeout(int offlineTimeout) {
        this.offlineTimeout = offlineTimeout;
        return this;
    }

    public int offlineCount() {
        return this.offlineCount;
    }

    public PeerMapConfiguration offlineCount(int offlineCount) {
        this.offlineCount = offlineCount;
        return this;
    }

    public Collection<PeerMapFilter> peerMapFilters() {
        return this.peerMapFilters;
    }

    public PeerMapConfiguration addMapPeerFilter(PeerMapFilter peerMapFilter) {
        this.peerMapFilters.add(peerMapFilter);
        return this;
    }

    public Maintenance maintenance() {
        return this.maintenance;
    }

    public PeerMapConfiguration maintenance(Maintenance maintenance) {
        this.maintenance = maintenance;
        return this;
    }

    public int shutdownTimeout() {
        return this.shutdownTimeout;
    }

    public PeerMapConfiguration shutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
        return this;
    }

    public int exceptionTimeout() {
        return this.exceptionTimeout;
    }

    public PeerMapConfiguration exceptionTimeout(int exceptionTimeout) {
        this.exceptionTimeout = exceptionTimeout;
        return this;
    }

    public boolean isPeerVerification() {
        return this.peerVerification;
    }

    public PeerMapConfiguration peerNoVerification() {
        this.peerVerification = false;
        return this;
    }

    public PeerMapConfiguration peerVerification(boolean reerVerification) {
        this.peerVerification = reerVerification;
        return this;
    }

    public PeerStatisticComparator getPeerStatisticComparator() {
        return this.peerStatisticComparator;
    }

    public PeerMapConfiguration setPeerStatisticComparator(PeerStatisticComparator peerStatisticComparator) {
        this.peerStatisticComparator = peerStatisticComparator;
        return this;
    }
}

