/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.util.ArrayList;
import java.util.Collection;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.utils.Utils;

public class KeyCollection {
    private final Collection<Number640> keys;
    private final Collection<Number160> keysConvert;
    private final Number160 locationKey;
    private final Number160 domainKey;
    private final Number160 versionKey;

    public KeyCollection(Number160 locationKey, Number160 domainKey, Number160 versionKey, Collection<Number160> keysConvert) {
        this.keys = null;
        this.keysConvert = keysConvert;
        this.locationKey = locationKey;
        this.domainKey = domainKey;
        this.versionKey = versionKey;
    }

    public KeyCollection(Collection<Number640> keys) {
        this.keys = keys;
        this.keysConvert = null;
        this.locationKey = null;
        this.domainKey = null;
        this.versionKey = null;
    }

    public Collection<Number640> keys() {
        return this.convert(this);
    }

    public Collection<Number160> keysConvert() {
        return this.keysConvert;
    }

    public Number160 locationKey() {
        return this.locationKey;
    }

    public Number160 domainKey() {
        return this.domainKey;
    }

    public Number160 versionKey() {
        return this.versionKey;
    }

    public int size() {
        if (this.keys != null) {
            return this.keys.size();
        }
        if (this.keysConvert != null) {
            return this.keysConvert.size();
        }
        return 0;
    }

    public boolean isConvert() {
        return this.keysConvert != null;
    }

    public KeyCollection add(Number640 number640) {
        this.keys.add(number640);
        return this;
    }

    private Collection<Number640> convert(KeyCollection k) {
        Collection<Number640> keys3;
        if (k.keysConvert != null) {
            keys3 = new ArrayList<Number640>(k.keysConvert.size());
            for (Number160 n160 : k.keysConvert) {
                keys3.add(new Number640(k.locationKey, k.domainKey, n160, k.versionKey));
            }
        } else {
            keys3 = k.keys;
        }
        return keys3;
    }

    public int hashCode() {
        Collection<Number640> keys = this.convert(this);
        return keys.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyCollection)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        KeyCollection k = (KeyCollection)obj;
        Collection<Number640> keys2 = this.convert(this);
        Collection<Number640> keys3 = this.convert(k);
        return Utils.isSameSets(keys2, keys3);
    }
}

