/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.Cancel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFutureImpl<K extends BaseFuture>
implements BaseFuture {
    private static final Logger LOG = LoggerFactory.getLogger(BaseFutureImpl.class);
    private final List<BaseFutureListener<? extends BaseFuture>> listeners = new ArrayList<BaseFutureListener<? extends BaseFuture>>(1);
    private final List<Cancel> cancels = new ArrayList<Cancel>(0);
    private final CountDownLatch listenersFinished = new CountDownLatch(1);
    protected final Object lock;
    protected boolean completed = false;
    protected BaseFuture.FutureType type = BaseFuture.FutureType.INIT;
    protected String reason = "unknown";
    private K self;
    private boolean cancel = false;

    public BaseFutureImpl() {
        this.lock = this;
    }

    protected void self(K self2) {
        this.self = self2;
    }

    protected K self() {
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K await() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.checkDeadlock();
            while (!this.completed) {
                this.lock.wait();
            }
            return this.self;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K awaitUninterruptibly() {
        Object object = this.lock;
        synchronized (object) {
            this.checkDeadlock();
            while (!this.completed) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    LOG.debug("interrupted, but ignoring", (Throwable)e);
                }
            }
            return this.self;
        }
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(timeoutMillis, true);
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(timeoutMillis, false);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("This should never ever happen.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await0(long timeoutMillis, boolean interrupt) throws InterruptedException {
        long startTime = timeoutMillis <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = timeoutMillis;
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return this.completed;
            }
            if (waitTime <= 0L) {
                return this.completed;
            }
            this.checkDeadlock();
            do {
                block8: {
                    try {
                        this.lock.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        if (!interrupt) break block8;
                        throw e;
                    }
                }
                if (!this.completed) continue;
                return true;
            } while ((waitTime = timeoutMillis - (System.currentTimeMillis() - startTime)) > 0L);
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCompleted() {
        Object object = this.lock;
        synchronized (object) {
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuccess() {
        Object object = this.lock;
        synchronized (object) {
            return this.completed && this.type == BaseFuture.FutureType.OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFailed() {
        Object object = this.lock;
        synchronized (object) {
            return this.completed && this.type != BaseFuture.FutureType.OK;
        }
    }

    public K failed(BaseFuture origin) {
        return this.failed(origin.failedReason());
    }

    public K failed(String failed, BaseFuture origin) {
        StringBuilder sb = new StringBuilder(failed);
        return this.failed(sb.append(" <-> ").append(origin.failedReason()).toString());
    }

    public K failed(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        return this.failed(stringWriter.toString());
    }

    public K failed(String failed, Throwable t) {
        if (t == null) {
            return this.failed("n/a");
        }
        StringBuilder sb = new StringBuilder(failed);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        return this.failed(sb.append(" <-> ").append(stringWriter.toString()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K failed(String failed) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completedAndNotify()) {
                return this.self;
            }
            this.reason = failed;
            this.type = BaseFuture.FutureType.FAILED;
        }
        this.notifyListeners();
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String failedReason() {
        StringBuffer sb = new StringBuffer("Future (compl/canc):");
        Object object = this.lock;
        synchronized (object) {
            sb.append(this.completed).append("/").append(this.cancel).append(", ").append(this.type.name()).append(", ").append(this.reason);
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFuture.FutureType type() {
        Object object = this.lock;
        synchronized (object) {
            return this.type;
        }
    }

    protected boolean completedAndNotify() {
        if (!this.completed) {
            this.completed = true;
            this.lock.notifyAll();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K awaitListeners() throws InterruptedException {
        boolean wait = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners.size() > 0) {
                wait = true;
            }
        }
        if (wait) {
            this.listenersFinished.await();
        }
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K awaitListenersUninterruptibly() {
        boolean wait = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners.size() > 0) {
                wait = true;
            }
        }
        while (wait) {
            try {
                this.listenersFinished.await();
                wait = false;
            }
            catch (InterruptedException e) {
                LOG.debug("interrupted, but ignoring", (Throwable)e);
            }
        }
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K addListener(BaseFutureListener<? extends BaseFuture> listener) {
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                notifyNow = true;
            } else {
                this.listeners.add(listener);
            }
        }
        if (notifyNow) {
            this.callOperationComplete(listener);
        }
        return this.self;
    }

    private void callOperationComplete(BaseFutureListener listener) {
        try {
            listener.operationComplete(this);
        }
        catch (Exception e) {
            try {
                listener.exceptionCaught(e);
                listener.operationComplete(this);
            }
            catch (Exception e1) {
                LOG.error("Unexcpected exception in exceptionCaught()", (Throwable)e1);
            }
        }
    }

    private void checkDeadlock() {
        String currentName = Thread.currentThread().getName();
        if (currentName.startsWith("NETTY-TOMP2P - ")) {
            throw new IllegalStateException("await*() in Netty I/O thread causes a dead lock or sudden performance drop. Use addListener() instead or call await*() from a different thread.");
        }
    }

    protected void notifyListeners() {
        for (BaseFutureListener<? extends BaseFuture> listener : this.listeners) {
            this.callOperationComplete(listener);
        }
        this.listenersFinished.countDown();
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K removeListener(BaseFutureListener<? extends BaseFuture> listener) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completed) {
                this.listeners.remove(listener);
            }
        }
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K addCancel(Cancel cancelListener) {
        List<Cancel> list = this.cancels;
        synchronized (list) {
            if (this.cancel) {
                cancelListener.cancel();
            } else {
                this.cancels.add(cancelListener);
            }
        }
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K removeCancel(Cancel cancelListener) {
        List<Cancel> list = this.cancels;
        synchronized (list) {
            if (!this.cancel) {
                this.cancels.remove(cancelListener);
            }
        }
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        boolean notifyCancel = false;
        List<Cancel> list = this.cancels;
        synchronized (list) {
            if (this.cancel) {
                return;
            }
            this.cancel = true;
            notifyCancel = true;
        }
        if (notifyCancel) {
            for (Cancel cancellable : this.cancels) {
                cancellable.cancel();
            }
        }
    }
}

