/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.List;
import java.util.Map;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerStatistic;

public class Statistics {
    private static final double MAX = Math.pow(2.0, 160.0);
    private double estimatedNumberOfPeers = 1.0;
    private double avgGap = MAX / 2.0;
    private final PeerMap peerMap;

    public Statistics(PeerMap peerMap) {
        this.peerMap = peerMap;
    }

    public double estimatedNumberOfNodes() {
        List<Map<Number160, PeerStatistic>> map = this.peerMap.peerMapVerified();
        double gap = 0.0;
        int gapCount = 0;
        for (int i = 0; i < 160; ++i) {
            Map<Number160, PeerStatistic> peers = map.get(i);
            int numPeers = peers.size();
            if (numPeers > 0 && numPeers < this.peerMap.bagSizeVerified(i)) {
                double currentGap = Math.pow(2.0, i) / (double)numPeers;
                gap += currentGap * (double)numPeers;
                gapCount += numPeers;
                continue;
            }
            if (numPeers != 0 && numPeers != this.peerMap.bagSizeVerified(i)) continue;
        }
        this.avgGap = gap / (double)gapCount;
        this.estimatedNumberOfPeers = MAX / this.avgGap;
        return this.estimatedNumberOfPeers;
    }

    public double avgGap() {
        return this.avgGap;
    }
}

