/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import net.tomp2p.connection.StandardProtocolFamily;

public class Bindings {
    private final List<InetAddress> addresses = new ArrayList<InetAddress>(1);
    private final List<String> interfaceHints = new ArrayList<String>(1);
    private final List<StandardProtocolFamily> protocolHint = new ArrayList<StandardProtocolFamily>(1);
    private boolean listenAny = false;

    public Bindings addAddress(InetAddress address) {
        this.addresses.add(address);
        return this;
    }

    public List<InetAddress> addresses() {
        return this.addresses;
    }

    public Bindings addInterface(String interfaceHint) {
        if (interfaceHint == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.interfaceHints.add(interfaceHint);
        return this;
    }

    public Bindings addProtocol(StandardProtocolFamily protocolFamily) {
        if (protocolFamily == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.protocolHint.add(protocolFamily);
        return this;
    }

    public List<String> interfaceHints() {
        return this.interfaceHints;
    }

    public List<StandardProtocolFamily> protocolHint() {
        return this.protocolHint;
    }

    public void clear() {
        this.interfaceHints.clear();
        this.addresses.clear();
        this.protocolHint.clear();
    }

    public boolean anyInterfaces() {
        return this.interfaceHints.isEmpty();
    }

    public boolean anyProtocols() {
        return this.protocolHint.isEmpty();
    }

    public boolean isIPv4() {
        return this.anyProtocols() || this.protocolHint.contains((Object)StandardProtocolFamily.INET);
    }

    public boolean isIPv6() {
        return this.anyProtocols() || this.protocolHint.contains((Object)StandardProtocolFamily.INET6);
    }

    public boolean isListenAny() {
        return this.listenAny;
    }

    public Bindings listenAny() {
        this.setListenAny(true);
        return this;
    }

    public Bindings setListenAny(boolean listenAny) {
        this.listenAny = listenAny;
        return this;
    }

    public boolean containsInterface(String name) {
        return this.interfaceHints.contains(name);
    }
}

