/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.tcp;

import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.relay.BaseRelayConnection;
import net.tomp2p.relay.RelayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTCPRelayConnection
extends BaseRelayConnection {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTCPRelayConnection.class);
    private final PeerConnection connection;
    private final Peer peer;
    private final ConnectionConfiguration config;

    public OpenTCPRelayConnection(PeerConnection connection, Peer peer, ConnectionConfiguration config) {
        super(connection.remotePeer());
        this.connection = connection;
        this.peer = peer;
        this.config = config;
        this.initCloseListener();
    }

    private void initCloseListener() {
        this.connection.closeFuture().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

            public void operationComplete(FutureDone<Void> future) throws Exception {
                if (!OpenTCPRelayConnection.this.peer.isShutdown()) {
                    LOG.debug("Relay connection {} failed.", (Object)OpenTCPRelayConnection.this.relayAddress());
                    OpenTCPRelayConnection.this.notifyCloseListeners();
                }
            }
        });
    }

    @Override
    public FutureResponse sendToRelay(Message message) {
        if (!this.connection.isOpen()) {
            return (FutureResponse)new FutureResponse(message).failed("Connection to relay has been closed");
        }
        message.keepAlive(true);
        return RelayUtils.send(this.connection, this.peer.peerBean(), this.peer.connectionBean(), this.config, message);
    }

    @Override
    public FutureDone<Void> shutdown() {
        return this.connection.closeFuture().done();
    }

    @Override
    public void onMapUpdateFailed() {
    }

    @Override
    public void onMapUpdateSuccess() {
    }
}

