/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.android.gcm;

import com.google.android.gcm.server.Message;
import com.google.android.gcm.server.Result;
import com.google.android.gcm.server.Sender;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.Peer;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.relay.android.gcm.FutureGCM;
import net.tomp2p.relay.android.gcm.IGCMSender;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCMSenderRPC
extends DispatchHandler
implements IGCMSender {
    private static final Logger LOG = LoggerFactory.getLogger(GCMSenderRPC.class);
    private final Sender sender;
    private final int retries;
    private final ScheduledExecutorService executor;

    public GCMSenderRPC(Peer peer, String authenticationKey, int retries) {
        super(peer.peerBean(), peer.connectionBean());
        this.sender = new Sender(authenticationKey);
        this.retries = retries;
        this.executor = peer.connectionBean().timer();
        this.register(new int[]{RPC.Commands.GCM.getNr()});
    }

    public void handleResponse(net.tomp2p.message.Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        LOG.warn("Received GCM message {}", (Object)message);
        if (message.type() != Message.Type.REQUEST_1 || message.command() != RPC.Commands.GCM.getNr()) {
            LOG.warn("Received invalid GCM message {}", (Object)message);
            throw new IllegalArgumentException("Message content is wrong");
        }
        LOG.debug("Forwarding tickle message over GCM");
        this.handleGCMForward(message, responder);
    }

    private void handleGCMForward(final net.tomp2p.message.Message message, final Responder responder) {
        if (message.bufferList().isEmpty()) {
            LOG.error("GCM message does not contain the registrationID");
            responder.response(this.createResponseMessage(message, Message.Type.EXCEPTION));
            return;
        }
        String registrationId = RelayUtils.decodeString(message.buffer(0));
        if (registrationId == null || registrationId.isEmpty()) {
            LOG.error("RegistrationID of device cannot be read from message");
            responder.response(this.createResponseMessage(message, Message.Type.EXCEPTION));
            return;
        }
        FutureGCM futureGCM = new FutureGCM(null, registrationId, message.sender().peerId());
        this.send(futureGCM);
        futureGCM.addListener((BaseFutureListener)new BaseFutureAdapter<FutureGCM>(){

            public void operationComplete(FutureGCM future) throws Exception {
                if (future.isSuccess()) {
                    LOG.debug("Successfully sent message over GCM");
                    responder.response(GCMSenderRPC.this.createResponseMessage(message, Message.Type.OK));
                } else {
                    LOG.debug("Could not send message over GCM");
                    responder.response(GCMSenderRPC.this.createResponseMessage(message, Message.Type.EXCEPTION));
                }
            }
        });
    }

    @Override
    public void send(final FutureGCM futureGCM) {
        final String registrationId = futureGCM.registrationId();
        final Message tickleMessage = new Message.Builder().collapseKey(futureGCM.senderId().toString()).delayWhileIdle(false).build();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.debug("Send GCM message to the device {}", (Object)registrationId);
                    Result result = GCMSenderRPC.this.sender.send(tickleMessage, registrationId, GCMSenderRPC.this.retries);
                    if (result.getMessageId() == null) {
                        LOG.error("Could not send the tickle messge. Reason: {}", (Object)result.getErrorCodeName());
                        futureGCM.failed("Cannot send message over GCM. Reason: " + result.getErrorCodeName());
                    } else {
                        LOG.debug("Successfully sent the message over GCM");
                        futureGCM.done();
                        if (result.getCanonicalRegistrationId() != null) {
                            LOG.debug("Update the registration id {} to canonical name {}", (Object)registrationId, (Object)result.getCanonicalRegistrationId());
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error("Cannot send tickle message to device {}", (Object)registrationId, (Object)e);
                    futureGCM.failed(e);
                }
            }
        }, "Send-GCM-Tickle-Message");
    }
}

