/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay.android;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.tomp2p.relay.android.MessageBufferConfiguration;
import net.tomp2p.relay.android.MessageBufferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBuffer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageBuffer.class);
    private static final ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();
    private final int messageCountLimit;
    private final long bufferSizeLimit;
    private final long bufferAgeLimitMS;
    private final AtomicLong bufferSize;
    private final List<MessageBufferListener<T>> listeners;
    private final List<T> buffer;
    private BufferAgeRunnable task;

    public MessageBuffer(MessageBufferConfiguration config) {
        this(config.bufferCountLimit(), config.bufferSizeLimit(), config.bufferAgeLimit());
    }

    public MessageBuffer(int bufferCountLimit, long bufferSizeLimit, long bufferAgeLimitMS) {
        this.messageCountLimit = bufferCountLimit;
        this.bufferSizeLimit = bufferSizeLimit;
        this.bufferAgeLimitMS = bufferAgeLimitMS;
        this.listeners = new ArrayList<MessageBufferListener<T>>();
        this.buffer = Collections.synchronizedList(new ArrayList());
        this.bufferSize = new AtomicLong();
    }

    public void addListener(MessageBufferListener<T> listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(T message, long messageSize) {
        List<T> list = this.buffer;
        synchronized (list) {
            if (this.buffer.isEmpty()) {
                this.task = new BufferAgeRunnable();
                worker.schedule(this.task, this.bufferAgeLimitMS, TimeUnit.MILLISECONDS);
            }
            this.buffer.add(message);
        }
        this.bufferSize.addAndGet(messageSize);
        LOG.debug("Added to the buffer: {}", message);
        this.checkFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFull() {
        boolean notify = false;
        if (this.bufferSize.get() >= this.bufferSizeLimit) {
            LOG.debug("The size of the buffer exceeds the limit of {} bytes", (Object)this.bufferSizeLimit);
            notify = true;
        }
        List<T> list = this.buffer;
        synchronized (list) {
            if (this.buffer.size() >= this.messageCountLimit) {
                LOG.debug("The number of messages exceeds the maximum message count of {}", (Object)this.messageCountLimit);
                notify = true;
            }
        }
        if (notify) {
            if (this.task != null) {
                this.task.cancel();
            }
            this.notifyAndClear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAndClear() {
        ArrayList<T> copy;
        List<T> list = this.buffer;
        synchronized (list) {
            if (this.buffer.isEmpty()) {
                LOG.warn("Buffer is empty. Listener won't be notified.");
                return;
            }
            copy = new ArrayList<T>(this.buffer);
            this.buffer.clear();
            this.bufferSize.set(0L);
        }
        for (MessageBufferListener messageBufferListener : this.listeners) {
            messageBufferListener.bufferFull(copy);
        }
    }

    private class BufferAgeRunnable
    implements Runnable {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        @Override
        public void run() {
            if (!this.cancelled.get()) {
                LOG.debug("Buffer age exceeds the limit of {}ms", (Object)MessageBuffer.this.bufferAgeLimitMS);
                MessageBuffer.this.notifyAndClear();
            }
        }

        public void cancel() {
            this.cancelled.set(true);
        }
    }
}

