/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.PeerException;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerStatistic;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.peers.RTT;
import net.tomp2p.relay.RelayType;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRelayForwarderRPC
extends DispatchHandler
implements PeerStatusListener {
    private static final Logger LOG = LoggerFactory.getLogger(BaseRelayForwarderRPC.class);
    private final Number160 relayPeerId;
    private PeerAddress unreachablePeer;
    private List<Map<Number160, PeerStatistic>> peerMap = null;

    public BaseRelayForwarderRPC(Peer peer, PeerAddress unreachablePeer, RelayType relayType) {
        super(peer.peerBean(), peer.connectionBean());
        this.unreachablePeer = unreachablePeer.changeRelayed(true).changeSlow(relayType.isSlow());
        this.relayPeerId = peer.peerID();
    }

    public final PeerAddress unreachablePeerAddress() {
        return this.unreachablePeer;
    }

    protected final Number160 unreachablePeerId() {
        return this.unreachablePeer.peerId();
    }

    public final boolean peerFailed(PeerAddress remotePeer, PeerException exception) {
        return false;
    }

    public final boolean peerFound(PeerAddress remotePeer, PeerAddress referrer, PeerConnection peerConnection, RTT roundTripTime) {
        if ((referrer == null || remotePeer.equals((Object)referrer)) && remotePeer.peerId().equals((Object)this.unreachablePeerId()) && remotePeer.isRelayed()) {
            LOG.trace("Update the unreachable peer to {} based on {}, ref {}", new Object[]{this.unreachablePeerAddress(), remotePeer, referrer});
            this.unreachablePeer = remotePeer;
            return true;
        }
        return false;
    }

    public final Number160 relayPeerId() {
        return this.relayPeerId;
    }

    public final void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        this.handleResponse(message, responder);
    }

    public final void handleResponse(Message message, final Responder responder) {
        if (message.command() == RPC.Commands.PING.getNr()) {
            LOG.debug("Received message {} to handle ping for unreachable peer {}", (Object)message, (Object)this.unreachablePeer);
            this.handlePing(message, responder);
        } else if (message.command() == RPC.Commands.NEIGHBOR.getNr()) {
            LOG.debug("Received message {} to handle neighbor request for unreachable peer {}", (Object)message, (Object)this.unreachablePeer);
            this.handleNeigbhor(message, responder);
        } else {
            LOG.debug("Received message {} to forward to unreachable peer {}", (Object)message, (Object)this.unreachablePeer);
            FutureDone<Message> response = this.forwardToUnreachable(message);
            response.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Message>>(){

                public void operationComplete(FutureDone<Message> future) throws Exception {
                    if (future.isSuccess()) {
                        Message answerMessage = (Message)future.object();
                        LOG.debug("Returing from relay to requester: {}", (Object)answerMessage);
                        responder.response(answerMessage);
                    } else {
                        responder.failed(Message.Type.DENIED, "Relaying message failed: " + future.failedReason());
                    }
                }
            });
        }
    }

    public abstract FutureDone<Message> forwardToUnreachable(Message var1);

    private void handlePing(Message message, Responder responder) {
        Message response = BaseRelayForwarderRPC.createResponseMessage((Message)message, (Message.Type)(this.isAlive() ? Message.Type.OK : Message.Type.EXCEPTION), (PeerAddress)this.unreachablePeerAddress());
        responder.response(response);
    }

    protected abstract boolean isAlive();

    private void handleNeigbhor(Message message, Responder responder) {
        if (message.keyList().size() < 2) {
            throw new IllegalArgumentException("We need the location and domain key at least");
        }
        if (message.type() != Message.Type.REQUEST_1 && message.type() != Message.Type.REQUEST_2 && message.type() != Message.Type.REQUEST_3 && message.type() != Message.Type.REQUEST_4 && message.command() == RPC.Commands.NEIGHBOR.getNr()) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Number160 locationKey = message.key(0);
        SortedSet<PeerAddress> neighbors = this.getNeighbors(locationKey, 30);
        if (neighbors == null) {
            Message response = BaseRelayForwarderRPC.createResponseMessage((Message)message, (Message.Type)Message.Type.NOT_FOUND, (PeerAddress)this.unreachablePeer);
            response.neighborsSet(new NeighborSet(-1, Collections.emptyList()));
            responder.response(response);
            return;
        }
        Message responseMessage = BaseRelayForwarderRPC.createResponseMessage((Message)message, (Message.Type)Message.Type.OK, (PeerAddress)this.unreachablePeer);
        LOG.debug("found the following neighbors {}", neighbors);
        NeighborSet neighborSet = new NeighborSet(1000, neighbors);
        responseMessage.neighborsSet(neighborSet);
        responder.response(responseMessage);
    }

    private SortedSet<PeerAddress> getNeighbors(Number160 id, int atLeast) {
        LOG.trace("Answering routing request on behalf of unreachable peer {}, neighbors of {}", (Object)this.unreachablePeerAddress(), (Object)id);
        if (this.peerMap == null) {
            return null;
        }
        NavigableSet closePeers = PeerMap.closePeers((Number160)this.unreachablePeerId(), (Number160)id, (int)30, this.peerMap, null);
        TreeSet<PeerAddress> result = new TreeSet<PeerAddress>(PeerMap.createXORAddressComparator((Number160)id));
        for (PeerStatistic p : closePeers) {
            result.add(p.peerAddress());
        }
        return result;
    }

    public final Collection<PeerAddress> getPeerMap() {
        ArrayList<PeerAddress> peerAddresses = new ArrayList<PeerAddress>();
        if (this.peerMap == null || this.peerMap.isEmpty()) {
            return peerAddresses;
        }
        ArrayList<PeerStatistic> statistics = new ArrayList<PeerStatistic>();
        for (Map<Number160, PeerStatistic> map : this.peerMap) {
            statistics.addAll(map.values());
        }
        for (PeerStatistic peerStatatistic : statistics) {
            peerAddresses.add(peerStatatistic.peerAddress());
        }
        return peerAddresses;
    }

    public final void setPeerMap(List<Map<Number160, PeerStatistic>> peerMap) {
        this.peerMap = peerMap;
        this.peerMapUpdated();
    }

    protected abstract void peerMapUpdated();
}

