/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.holep;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.holep.DuplicatesHandler;
import net.tomp2p.holep.HolePunchScheduler;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.rpc.RPC;
import net.tomp2p.utils.Pair;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolePuncher {
    private static final Logger LOG = LoggerFactory.getLogger(HolePuncher.class);
    private static final boolean BROADCAST_VALUE = false;
    private static final boolean FIRE_AND_FORGET_VALUE = false;
    private final Peer peer;
    private final int numberOfHoles;
    private final int idleUDPSeconds;
    private boolean initiator = false;
    private final Message originalMessage;
    private List<ChannelFuture> channelFutures = new ArrayList<ChannelFuture>();
    private FutureResponse frResponse;
    private PeerAddress originalSender;
    private List<Pair<Integer, Integer>> portMappings = new ArrayList<Pair<Integer, Integer>>();
    private FutureDone<Message> mainFutureDone;

    public HolePuncher(Peer peer, int numberOfHoles, int idleUDPSeconds, Message originalMessage) {
        this.peer = peer;
        this.numberOfHoles = numberOfHoles;
        this.idleUDPSeconds = idleUDPSeconds;
        this.originalMessage = originalMessage;
        LOG.trace("new HolePuncher created, originalMessage {}", (Object)originalMessage.toString());
    }

    private final FutureDone<List<ChannelFuture>> createChannelFutures(final FutureResponse originalFutureResponse, List<Map<String, Pair<EventExecutorGroup, ChannelHandler>>> handlersList) {
        final FutureDone fDoneChannelFutures = new FutureDone();
        final AtomicInteger countDown = new AtomicInteger(this.numberOfHoles);
        final ArrayList channelFutures = new ArrayList();
        for (int i = 0; i < this.numberOfHoles; ++i) {
            final Map<String, Pair<EventExecutorGroup, ChannelHandler>> handlers = handlersList.get(i);
            FutureChannelCreator fcc = this.peer.connectionBean().reservation().create(1, 0);
            fcc.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        ChannelFuture cF = future.channelCreator().createUDP(false, handlers, originalFutureResponse);
                        cF.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (future.isSuccess()) {
                                    channelFutures.add(future);
                                } else {
                                    HolePuncher.this.handleFail("Error while creating the ChannelFutures!");
                                }
                                countDown.decrementAndGet();
                                if (countDown.get() == 0) {
                                    fDoneChannelFutures.done((Object)channelFutures);
                                }
                            }
                        });
                    } else {
                        countDown.decrementAndGet();
                        HolePuncher.this.handleFail("Error while creating the ChannelFutures!");
                    }
                }
            });
        }
        return fDoneChannelFutures;
    }

    private List<Map<String, Pair<EventExecutorGroup, ChannelHandler>>> prepareHandlers(FutureResponse originalFutureResponse) {
        ArrayList<Map<String, Pair<EventExecutorGroup, ChannelHandler>>> handlerList = new ArrayList<Map<String, Pair<EventExecutorGroup, ChannelHandler>>>(this.numberOfHoles);
        if (this.initiator) {
            for (int i = 0; i < this.numberOfHoles; ++i) {
                SimpleChannelInboundHandler<Message> inboundHandler = this.createAfterHolePHandler();
                Map handlers = this.peer.connectionBean().sender().configureHandlers(inboundHandler, originalFutureResponse, this.idleUDPSeconds, false);
                handlerList.add(handlers);
            }
        } else {
            DuplicatesHandler inboundHandler = new DuplicatesHandler(this.peer.connectionBean().dispatcher());
            for (int i = 0; i < this.numberOfHoles; ++i) {
                Map handlers = this.peer.connectionBean().sender().configureHandlers((SimpleChannelInboundHandler)inboundHandler, originalFutureResponse, this.idleUDPSeconds, false);
                handlerList.add(handlers);
            }
        }
        return handlerList;
    }

    private void handleFail(String failMessage) {
        this.mainFutureDone.failed(failMessage);
    }

    public FutureDone<Message> initiateHolePunch(final ChannelCreator originalChannelCreator, final FutureResponse originalFutureResponse) {
        this.initiator = true;
        this.mainFutureDone = new FutureDone();
        FutureDone<List<ChannelFuture>> fDoneChannelFutures = this.createChannelFutures(originalFutureResponse, this.prepareHandlers(originalFutureResponse));
        fDoneChannelFutures.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<List<ChannelFuture>>>(){

            public void operationComplete(FutureDone<List<ChannelFuture>> future) throws Exception {
                if (future.isSuccess()) {
                    List futures = (List)future.object();
                    HolePuncher.this.peer.connectionBean().sender().sendUDP(HolePuncher.this.createHolePunchInboundHandler(futures, originalFutureResponse), originalFutureResponse, HolePuncher.this.createHolePunchInitMessage(futures), originalChannelCreator, HolePuncher.this.idleUDPSeconds, false);
                    LOG.debug("ChannelFutures successfully created. Initialization of hole punching started.");
                } else {
                    HolePuncher.this.mainFutureDone.failed("No ChannelFuture could be created!");
                }
            }
        });
        return this.mainFutureDone;
    }

    private SimpleChannelInboundHandler<Message> createHolePunchInboundHandler(final List<ChannelFuture> futures, final FutureResponse originalFutureResponse) {
        SimpleChannelInboundHandler<Message> holePunchInboundHandler = new SimpleChannelInboundHandler<Message>(){

            protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
                if (HolePuncher.this.checkReplyValues(msg)) {
                    for (int i = 0; i < msg.intList().size(); ++i) {
                        ChannelFuture channelFuture = HolePuncher.this.extractChannelFuture(futures, (Integer)msg.intList().get(i));
                        if (channelFuture == null) {
                            HolePuncher.this.handleFail("Something went wrong with the portmappings!");
                        }
                        Message sendMessage = HolePuncher.this.createSendOriginalMessage((Integer)msg.intList().get(++i - 1), (Integer)msg.intList().get(i));
                        HolePuncher.this.peer.connectionBean().sender().afterConnect(originalFutureResponse, sendMessage, channelFuture, false);
                        LOG.warn("originalMessage has been sent to the other peer! {}", (Object)sendMessage);
                    }
                }
            }
        };
        LOG.debug("new HolePunchHandler created, waiting now for answer from rendez-vous peer.");
        return holePunchInboundHandler;
    }

    private ChannelFuture extractChannelFuture(List<ChannelFuture> futures, int localPort) {
        for (ChannelFuture future : futures) {
            InetSocketAddress inetSocketAddress;
            if (future.channel().localAddress() == null || (inetSocketAddress = (InetSocketAddress)future.channel().localAddress()).getPort() != localPort) continue;
            return future;
        }
        return null;
    }

    private SimpleChannelInboundHandler<Message> createAfterHolePHandler() {
        SimpleChannelInboundHandler<Message> inboundHandler = new SimpleChannelInboundHandler<Message>(){

            protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
                if (Message.Type.OK == msg.type() && HolePuncher.this.originalMessage.command() == msg.command()) {
                    LOG.debug("Successfully transmitted the original message to peer:[" + msg.sender().toString() + "]. Now here's the reply:[" + msg.toString() + "]");
                    HolePuncher.this.mainFutureDone.done((Object)msg);
                } else if (Message.Type.REQUEST_3 == msg.type() && RPC.Commands.HOLEP.getNr() == msg.command()) {
                    LOG.debug("Holes successfully punched with ports = {localPort = " + msg.recipient().udpPort() + " , remotePort = " + msg.sender().udpPort() + "}!");
                } else {
                    LOG.debug("Holes punche not punched with ports = {localPort = " + msg.recipient().udpPort() + " , remotePort = " + msg.sender().udpPort() + "} yet!");
                }
            }
        };
        return inboundHandler;
    }

    private boolean checkReplyValues(Message msg) {
        boolean ok = false;
        if (msg.command() == RPC.Commands.HOLEP.getNr() && msg.type() == Message.Type.OK) {
            if (msg.intList() != null && !msg.intList().isEmpty()) {
                int rawNumberOfHoles = msg.intList().size();
                if (rawNumberOfHoles % 2 == 0) {
                    ok = true;
                } else {
                    this.handleFail("The number of ports in IntList was odd! This should never happen");
                }
            } else {
                this.handleFail("IntList in replyMessage was null or Empty! No ports available!!!!");
            }
        } else {
            this.handleFail("Could not acquire a connection via hole punching, got: " + msg);
        }
        LOG.debug("ReplyValues of answerMessage from rendez-vous peer are: " + ok);
        return ok;
    }

    private Message createSendOriginalMessage(int localPort, int remotePort) {
        Message sendMessage = new Message();
        PeerAddress sender = this.originalMessage.sender().changePorts(-1, localPort).changeFirewalledTCP(false).changeFirewalledUDP(false).changeRelayed(false);
        PeerAddress recipient = this.originalMessage.recipient().changePorts(-1, remotePort).changeFirewalledTCP(false).changeFirewalledUDP(false).changeRelayed(false);
        sendMessage.recipient(recipient);
        sendMessage.sender(sender);
        sendMessage.version(this.originalMessage.version());
        sendMessage.command(this.originalMessage.command());
        sendMessage.type(this.originalMessage.type());
        sendMessage.intValue(this.originalMessage.messageId());
        sendMessage.udp(true);
        for (Buffer buf : this.originalMessage.bufferList()) {
            sendMessage.buffer(new Buffer(buf.buffer().duplicate()));
        }
        return sendMessage;
    }

    private Message createHolePunchInitMessage(List<ChannelFuture> channelFutures) {
        PeerSocketAddress socketAddress = Utils.extractRandomRelay((Message)this.originalMessage);
        Message holePMessage = new Message();
        PeerAddress recipient = this.originalMessage.recipient().changeAddress(socketAddress.inetAddress()).changePorts(socketAddress.tcpPort(), socketAddress.udpPort()).changeRelayed(false);
        holePMessage.recipient(recipient);
        holePMessage.sender(this.originalMessage.sender());
        holePMessage.version(this.originalMessage.version());
        holePMessage.udp(true);
        holePMessage.command(RPC.Commands.HOLEP.getNr());
        holePMessage.type(Message.Type.REQUEST_1);
        for (int i = 0; i < channelFutures.size(); ++i) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)channelFutures.get(i).channel().localAddress();
            holePMessage.intValue(inetSocketAddress.getPort());
        }
        LOG.debug("Hole punch initMessage created {}", (Object)holePMessage.toString());
        return holePMessage;
    }

    public FutureDone<Message> replyHolePunch() {
        this.originalSender = (PeerAddress)((NeighborSet)this.originalMessage.neighborsSetList().get(0)).neighbors().toArray()[0];
        final FutureDone replyMessageFuture = new FutureDone();
        this.frResponse = new FutureResponse(this.originalMessage);
        final HolePuncher thisInstance = this;
        FutureDone<List<ChannelFuture>> rmfChannelFutures = this.createChannelFutures(this.frResponse, this.prepareHandlers(this.frResponse));
        rmfChannelFutures.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<List<ChannelFuture>>>(){

            public void operationComplete(FutureDone<List<ChannelFuture>> future) throws Exception {
                if (future.isSuccess()) {
                    HolePuncher.this.channelFutures = (List)future.object();
                    HolePuncher.this.doPortMappings();
                    Message replyMessage = HolePuncher.this.createReplyMessage();
                    Thread holePunchScheduler = new Thread(new HolePunchScheduler(10, thisInstance));
                    holePunchScheduler.start();
                    replyMessageFuture.done((Object)replyMessage);
                } else {
                    replyMessageFuture.failed("No ChannelFuture could be created!");
                }
            }
        });
        return replyMessageFuture;
    }

    private void doPortMappings() {
        for (int i = 0; i < this.channelFutures.size(); ++i) {
            InetSocketAddress socket = (InetSocketAddress)this.channelFutures.get(i).channel().localAddress();
            this.portMappings.add((Pair<Integer, Integer>)new Pair(this.originalMessage.intList().get(i), (Object)socket.getPort()));
        }
    }

    private Message createDummyMessage(int i) {
        Message dummyMessage = new Message();
        int remotePort = (Integer)this.portMappings.get(i).element0();
        int localPort = (Integer)this.portMappings.get(i).element1();
        PeerAddress recipient = this.originalSender.changeFirewalledUDP(false).changeRelayed(false).changePorts(-1, remotePort);
        PeerAddress sender = this.peer.peerBean().serverPeerAddress().changePorts(-1, localPort);
        dummyMessage.recipient(recipient);
        dummyMessage.command(RPC.Commands.HOLEP.getNr());
        dummyMessage.type(Message.Type.REQUEST_3);
        dummyMessage.sender(sender);
        dummyMessage.udp(true);
        return dummyMessage;
    }

    private Message createReplyMessage() {
        Message replyMessage = new Message();
        replyMessage.messageId(this.originalMessage.messageId());
        replyMessage.recipient(this.originalMessage.sender());
        replyMessage.sender(this.peer.peerBean().serverPeerAddress());
        replyMessage.command(RPC.Commands.HOLEP.getNr());
        replyMessage.type(Message.Type.OK);
        replyMessage.messageId(this.originalMessage.messageId());
        for (Pair<Integer, Integer> pair : this.portMappings) {
            if (pair == null || pair.isEmpty() || pair.element0() == null || pair.element1() == null) continue;
            replyMessage.intValue(((Integer)pair.element0()).intValue());
            replyMessage.intValue(((Integer)pair.element1()).intValue());
        }
        return replyMessage;
    }

    public void tryConnect() throws Exception {
        if (this.channelFutures.size() != this.portMappings.size()) {
            throw new Exception("the number of channels does not match the number of ports!");
        }
        for (int i = 0; i < this.channelFutures.size(); ++i) {
            Message dummyMessage = this.createDummyMessage(i);
            FutureResponse futureResponse = new FutureResponse(dummyMessage);
            LOG.trace("FIRE! remotePort: " + dummyMessage.recipient().udpPort() + ", localPort: " + dummyMessage.sender().udpPort());
            this.peer.connectionBean().sender().afterConnect(futureResponse, dummyMessage, this.channelFutures.get(i), false);
            this.peer.peerBean().peerMap().peerFound(this.originalSender, this.originalSender, null, null);
        }
    }
}

