/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.connection.Dispatcher;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.BaseRelayForwarderRPC;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RconRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RconRPC.class);
    private final Peer peer;
    private final ConnectionConfiguration config;

    public RconRPC(Peer peer) {
        super(peer.peerBean(), peer.connectionBean());
        this.register(new int[]{RPC.Commands.RCON.getNr()});
        this.peer = peer;
        this.config = new DefaultConnectionConfiguration();
    }

    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        LOG.debug("received RconRPC message {}", (Object)message);
        if (message.type() == Message.Type.REQUEST_1 && message.command() == RPC.Commands.RCON.getNr()) {
            LOG.debug("handle RconForward for message: " + message);
            this.handleRconForward(message, responder);
        } else if (message.type() == Message.Type.REQUEST_2 && message.command() == RPC.Commands.RCON.getNr()) {
            LOG.debug("handle RconSetup for message: " + message);
            this.handleRconSetup(message, responder);
        } else if (message.type() == Message.Type.REQUEST_3 && message.command() == RPC.Commands.RCON.getNr()) {
            LOG.debug("handle RconAfterconnect for message: " + message);
            this.handleRconAfterconnect(message, responder, peerConnection);
        } else {
            LOG.warn("received invalid RconRPC message {}", (Object)message);
            throw new IllegalArgumentException("Message content is wrong");
        }
    }

    private void handleRconForward(Message message, Responder responder) {
        BaseRelayForwarderRPC forwarder = this.extractRelayForwarder(message);
        if (forwarder != null) {
            Message forwardMessage = this.createForwardMessage(message, forwarder.unreachablePeerAddress());
            forwarder.handleResponse(forwardMessage, responder);
        } else {
            this.handleFail(message, responder, "No RelayForwarder registered for peerId=" + message.recipient().peerId().toString());
        }
    }

    private BaseRelayForwarderRPC extractRelayForwarder(Message message) {
        Dispatcher dispatcher = this.peer.connectionBean().dispatcher();
        Map ioHandlers = dispatcher.searchHandlerMap(this.peer.peerID(), message.recipient().peerId());
        for (DispatchHandler handler : ioHandlers.values()) {
            if (!(handler instanceof BaseRelayForwarderRPC)) continue;
            return (BaseRelayForwarderRPC)handler;
        }
        return null;
    }

    private Message createForwardMessage(Message message, PeerAddress recipient) {
        Message forwardMessage = this.createMessage(recipient, RPC.Commands.RCON.getNr(), Message.Type.REQUEST_2);
        NeighborSet ns = new NeighborSet(1, new ArrayList(1));
        ns.add(message.sender());
        forwardMessage.neighborsSet(ns);
        if (!message.intList().isEmpty()) {
            forwardMessage.intValue(message.intAt(0).intValue());
        }
        return forwardMessage;
    }

    private void handleRconSetup(final Message message, final Responder responder) throws TimeoutException {
        if (!message.neighborsSetList().isEmpty()) {
            PeerAddress originalSender = (PeerAddress)((NeighborSet)message.neighborsSetList().get(0)).neighbors().toArray()[0];
            FuturePeerConnection fpc = this.peer.createPeerConnection(originalSender);
            fpc.addListener((BaseFutureListener)new BaseFutureAdapter<FuturePeerConnection>(){

                public void operationComplete(FuturePeerConnection future) throws Exception {
                    if (future.isSuccess() && future.peerConnection() != null) {
                        final PeerConnection peerConnection = future.peerConnection();
                        Message readyMessage = RconRPC.this.createReadyForRequestMessage(message, peerConnection.remotePeer());
                        FutureResponse futureResponse = RelayUtils.send(peerConnection, RconRPC.this.peer.peerBean(), RconRPC.this.peer.connectionBean(), RconRPC.this.config, readyMessage);
                        futureResponse.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                            public void operationComplete(FutureResponse future) throws Exception {
                                if (future.isSuccess()) {
                                    if (message.intList().isEmpty()) {
                                        RconRPC.this.storePeerConnection(message, peerConnection);
                                    }
                                    responder.response(RconRPC.this.createResponseMessage(message, Message.Type.OK).keepAlive(true));
                                } else {
                                    LOG.error("Cannot setup the reverse connection to the peer. Reason: {}", (Object)future.failedReason());
                                    RconRPC.this.handleFail(message, responder, "Exception while setting up the reverse connection from the unreachable to the original peer!");
                                }
                            }
                        });
                    } else {
                        RconRPC.this.handleFail(message, responder, "no channel could be established");
                    }
                }
            });
        } else {
            this.handleFail(message, responder, "the original sender was not transmittet in the neighborsSet!");
        }
    }

    private Message createReadyForRequestMessage(Message message, PeerAddress receiver) {
        Message readyForRequestMessage = this.createMessage(receiver, RPC.Commands.RCON.getNr(), Message.Type.REQUEST_3);
        if (!message.intList().isEmpty()) {
            readyForRequestMessage.intValue(message.intAt(0).intValue());
        }
        readyForRequestMessage.keepAlive(true);
        return readyForRequestMessage;
    }

    private void handleRconAfterconnect(final Message message, final Responder responder, final PeerConnection peerConnection) {
        if (message.intList().isEmpty()) {
            LOG.debug("This reverse connection is used permanently. Store it!");
            this.storePeerConnection(message, peerConnection);
            responder.response(this.createResponseMessage(message, Message.Type.OK).keepAlive(true));
        } else {
            ConcurrentHashMap cachedRequests = this.peer.connectionBean().sender().cachedRequests();
            final FutureResponse cachedRequest = (FutureResponse)cachedRequests.remove(message.intAt(0));
            final Message cachedMessage = cachedRequest.request();
            LOG.debug("This reverse connection is only used for sending a direct message {}", (Object)cachedMessage);
            FutureResponse futureResponse = RelayUtils.send(peerConnection, this.peer.peerBean(), this.peer.connectionBean(), this.config, cachedMessage);
            futureResponse.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                public void operationComplete(FutureResponse future) throws Exception {
                    if (future.isSuccess()) {
                        LOG.debug("Successfully transmitted request message {} to unreachablePeer {}", (Object)cachedMessage, (Object)peerConnection.remotePeer());
                        cachedRequest.response(future.responseMessage());
                        Message responseMessage = RconRPC.this.createResponseMessage(message, Message.Type.OK).keepAlive(false);
                        LOG.debug("Returning OK for delivering single message over reverse connection {}", (Object)responseMessage);
                        responder.response(responseMessage);
                        peerConnection.close();
                    } else {
                        cachedRequest.failed("Cannot send the request message", (BaseFuture)future);
                        RconRPC.this.handleFail(message, responder, "The AfterConnectMessage could not be sent!");
                    }
                }
            });
        }
    }

    private void storePeerConnection(final Message message, final PeerConnection peerConnection) {
        peerConnection.closeFuture().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

            public void operationComplete(FutureDone<Void> future) throws Exception {
                LOG.warn("Permanent PeerConnection {} to peer {} has been closed.", (Object)peerConnection, (Object)message.sender());
                RconRPC.this.peer.peerBean().openPeerConnections().remove(message.sender().peerId());
            }
        });
        LOG.debug("Storing peerconnection {} to peer {} permanently: {}", (Object)peerConnection, (Object)message.sender().peerId());
        ConcurrentHashMap openPeerConnections = this.peer.peerBean().openPeerConnections();
        openPeerConnections.put(message.sender().peerId(), peerConnection);
    }

    private void handleFail(Message message, Responder responder, String failReason) {
        LOG.error(failReason);
        responder.response(this.createResponseMessage(message, Message.Type.EXCEPTION));
    }
}

