/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.relay.BaseRelayConnection;
import net.tomp2p.relay.ConcurrentCacheSet;
import net.tomp2p.relay.FutureRelay;
import net.tomp2p.relay.RelayConfig;
import net.tomp2p.relay.RelayListener;
import net.tomp2p.relay.RelayRPC;
import net.tomp2p.relay.RelayType;
import net.tomp2p.relay.RelayUtils;
import net.tomp2p.relay.android.AndroidRelayConnection;
import net.tomp2p.relay.android.MessageBuffer;
import net.tomp2p.relay.android.MessageBufferListener;
import net.tomp2p.relay.android.gcm.GCMMessageHandler;
import net.tomp2p.relay.tcp.OpenTCPRelayConnection;
import net.tomp2p.rpc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedRelay
implements GCMMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedRelay.class);
    private final Peer peer;
    private final RelayRPC relayRPC;
    private final ConnectionConfiguration config;
    private final List<BaseRelayConnection> relays;
    private final Set<PeerAddress> failedRelays;
    private final Collection<RelayListener> relayListeners;
    private final RelayConfig relayConfig;
    private MessageBuffer<String> gcmBuffer;

    public DistributedRelay(Peer peer, RelayRPC relayRPC, ConnectionConfiguration config, RelayConfig relayConfig) {
        this.peer = peer;
        this.relayRPC = relayRPC;
        this.config = config;
        this.relayConfig = relayConfig;
        this.relays = Collections.synchronizedList(new ArrayList());
        this.failedRelays = new ConcurrentCacheSet<PeerAddress>(relayConfig.failedRelayWaitTime());
        this.relayListeners = Collections.synchronizedList(new ArrayList(1));
        if (relayConfig.type() == RelayType.ANDROID && relayConfig.bufferConfiguration() != null) {
            this.gcmBuffer = new MessageBuffer(relayConfig.bufferConfiguration());
            this.gcmBuffer.addListener(new MessageBufferListener<String>(){

                @Override
                public void bufferFull(List<String> messages) {
                    HashSet<String> relayIds = new HashSet<String>(messages);
                    for (String peerId : relayIds) {
                        DistributedRelay.this.sendBufferRequest(peerId);
                    }
                }
            });
        }
    }

    public RelayConfig relayConfig() {
        return this.relayConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseRelayConnection> relays() {
        List<BaseRelayConnection> list = this.relays;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<BaseRelayConnection>(this.relays));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelayListener(RelayListener relayListener) {
        Collection<RelayListener> collection = this.relayListeners;
        synchronized (collection) {
            this.relayListeners.add(relayListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureForkJoin<FutureDone<Void>> shutdown() {
        AtomicReferenceArray<FutureDone<Void>> futureDones;
        Collection<Object> collection = this.relays;
        synchronized (collection) {
            futureDones = new AtomicReferenceArray<FutureDone<Void>>(this.relays.size());
            for (int i = 0; i < this.relays.size(); ++i) {
                futureDones.set(i, this.relays.get(i).shutdown());
            }
        }
        collection = this.relayListeners;
        synchronized (collection) {
            this.relayListeners.clear();
        }
        return new FutureForkJoin(futureDones);
    }

    public FutureRelay setupRelays(FutureRelay futureRelay) {
        ArrayList<PeerAddress> relayCandidates;
        if (this.relayConfig.manualRelays().isEmpty()) {
            relayCandidates = this.peer.distributedRouting().peerMap().all();
            relayCandidates.removeAll(this.failedRelays);
        } else {
            relayCandidates = new ArrayList<PeerAddress>(this.relayConfig.manualRelays());
        }
        this.filterRelayCandidates(relayCandidates);
        this.setupPeerConnections(futureRelay, relayCandidates);
        return futureRelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterRelayCandidates(Collection<PeerAddress> relayCandidates) {
        Iterator<PeerAddress> iterator = relayCandidates.iterator();
        while (iterator.hasNext()) {
            PeerAddress pa = iterator.next();
            if (pa.isRelayed()) {
                iterator.remove();
                continue;
            }
            List<BaseRelayConnection> list = this.relays;
            synchronized (list) {
                for (BaseRelayConnection relay : this.relays) {
                    if (!relay.relayAddress().equals((Object)pa)) continue;
                    iterator.remove();
                    break;
                }
            }
        }
        LOG.trace("Found {} addtional relay candidates", (Object)relayCandidates.size());
    }

    private void setupPeerConnections(FutureRelay futureRelay, List<PeerAddress> relayCandidates) {
        int nrOfRelays = Math.min(this.relayConfig.type().maxRelayCount() - this.relays.size(), relayCandidates.size());
        if (nrOfRelays > 0) {
            LOG.debug("Setting up {} relays", (Object)nrOfRelays);
            FutureDone[] futureDones = new FutureDone[nrOfRelays];
            AtomicReferenceArray<FutureDone<PeerConnection>> relayConnectionFutures = new AtomicReferenceArray<FutureDone<PeerConnection>>(futureDones);
            this.setupPeerConnectionsRecursive(relayConnectionFutures, relayCandidates, nrOfRelays, futureRelay, 0, new StringBuilder());
        } else if (relayCandidates.isEmpty()) {
            futureRelay.failed("done");
        } else {
            futureRelay.done(Collections.<BaseRelayConnection>emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPeerConnectionsRecursive(final AtomicReferenceArray<FutureDone<PeerConnection>> futures, final List<PeerAddress> relayCandidates, final int numberOfRelays, final FutureRelay futureRelay, final int fail, final StringBuilder status) {
        int active = 0;
        for (int i = 0; i < numberOfRelays; ++i) {
            if (futures.get(i) == null) {
                PeerAddress candidate = null;
                List<PeerAddress> list = relayCandidates;
                synchronized (list) {
                    if (!relayCandidates.isEmpty()) {
                        candidate = relayCandidates.remove(0);
                    }
                }
                if (candidate == null) continue;
                FutureDone<PeerConnection> futureDone = this.sendMessage(candidate);
                futures.set(i, futureDone);
                ++active;
                continue;
            }
            ++active;
        }
        if (active == 0) {
            this.updatePeerAddress();
            futureRelay.failed("No candidates: " + status.toString());
            return;
        }
        if (fail > this.relayConfig.maxFail()) {
            this.updatePeerAddress();
            futureRelay.failed("Maxfail: " + status.toString());
            return;
        }
        FutureForkJoin ffj = new FutureForkJoin(active, false, futures);
        ffj.addListener((BaseFutureListener)new BaseFutureAdapter<FutureForkJoin<FutureDone<PeerConnection>>>(){

            public void operationComplete(FutureForkJoin<FutureDone<PeerConnection>> futureForkJoin) throws Exception {
                if (futureForkJoin.isSuccess()) {
                    DistributedRelay.this.updatePeerAddress();
                    futureRelay.done(DistributedRelay.this.relays());
                } else if (!DistributedRelay.this.peer.isShutdown()) {
                    DistributedRelay.this.setupPeerConnectionsRecursive(futures, relayCandidates, numberOfRelays, futureRelay, fail + 1, status.append(futureForkJoin.failedReason()).append(" "));
                } else {
                    futureRelay.failed((BaseFuture)futureForkJoin);
                }
            }
        });
    }

    private FutureDone<PeerConnection> sendMessage(final PeerAddress candidate) {
        final FutureDone futureDone = new FutureDone();
        final Message message = this.relayRPC.createMessage(candidate, RPC.Commands.RELAY.getNr(), Message.Type.REQUEST_1);
        message.keepAlive(this.relayConfig.type().keepConnectionOpen());
        message.intValue(this.relayConfig.type().ordinal());
        if (this.relayConfig.type() == RelayType.ANDROID) {
            if (this.relayConfig.registrationId() == null) {
                LOG.error("Registration ID must be provided when using Android mode");
                return (FutureDone)futureDone.failed("No GCM registration ID provided");
            }
            message.buffer(RelayUtils.encodeString(this.relayConfig.registrationId()));
            message.intValue(this.relayConfig.peerMapUpdateInterval());
            if (this.relayConfig.gcmServers() != null && !this.relayConfig.gcmServers().isEmpty()) {
                message.neighborsSet(new NeighborSet(-1, this.relayConfig.gcmServers()));
            }
        }
        LOG.debug("Setting up relay connection to peer {}, message {}", (Object)candidate, (Object)message);
        FuturePeerConnection fpc = this.peer.createPeerConnection(candidate);
        fpc.addListener((BaseFutureListener)new BaseFutureAdapter<FuturePeerConnection>(){

            public void operationComplete(FuturePeerConnection futurePeerConnection) throws Exception {
                if (futurePeerConnection.isSuccess()) {
                    final PeerConnection peerConnection = (PeerConnection)futurePeerConnection.object();
                    FutureResponse response = RelayUtils.send(peerConnection, DistributedRelay.this.peer.peerBean(), DistributedRelay.this.peer.connectionBean(), DistributedRelay.this.config, message);
                    response.addListener((BaseFutureListener)new BaseFutureAdapter<FutureResponse>(){

                        public void operationComplete(FutureResponse future) throws Exception {
                            if (future.isSuccess()) {
                                DistributedRelay.this.setupAddRelays(candidate, peerConnection);
                                futureDone.done((Object)peerConnection);
                            } else {
                                LOG.debug("Peer {} denied relay request", (Object)candidate);
                                DistributedRelay.this.failedRelays.add(candidate);
                                futureDone.failed((BaseFuture)future);
                            }
                        }
                    });
                } else {
                    LOG.debug("Unable to setup a connection to relay peer {}", (Object)candidate);
                    DistributedRelay.this.failedRelays.add(candidate);
                    futureDone.failed((BaseFuture)futurePeerConnection);
                }
            }
        });
        return futureDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupAddRelays(PeerAddress relayAddress, PeerConnection peerConnection) {
        List<BaseRelayConnection> list = this.relays;
        synchronized (list) {
            if (this.relays.size() >= this.relayConfig.type().maxRelayCount()) {
                LOG.warn("The maximum number ({}) of relays is reached", (Object)this.relayConfig.type().maxRelayCount());
                return;
            }
        }
        BaseRelayConnection connection = null;
        switch (this.relayConfig.type()) {
            case OPENTCP: {
                connection = new OpenTCPRelayConnection(peerConnection, this.peer, this.config);
                break;
            }
            case ANDROID: {
                connection = new AndroidRelayConnection(relayAddress, this.relayRPC, this.peer, this.config);
                break;
            }
            default: {
                LOG.error("Unknown relay type {}", (Object)this.relayConfig);
                return;
            }
        }
        this.addCloseListener(connection);
        List<BaseRelayConnection> list2 = this.relays;
        synchronized (list2) {
            LOG.debug("Adding peer {} as a relay", (Object)relayAddress);
            this.relays.add(connection);
        }
    }

    private void addCloseListener(final BaseRelayConnection connection) {
        connection.addCloseListener(new RelayListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void relayFailed(PeerAddress relayAddress) {
                DistributedRelay.this.relays.remove(connection);
                DistributedRelay.this.failedRelays.add(relayAddress);
                DistributedRelay.this.updatePeerAddress();
                Collection collection = DistributedRelay.this.relayListeners;
                synchronized (collection) {
                    for (RelayListener relayListener : DistributedRelay.this.relayListeners) {
                        relayListener.relayFailed(relayAddress);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePeerAddress() {
        boolean hasRelays = !this.relays.isEmpty();
        ArrayList<PeerSocketAddress> socketAddresses = new ArrayList<PeerSocketAddress>(this.relays.size());
        List<BaseRelayConnection> list = this.relays;
        synchronized (list) {
            for (BaseRelayConnection relay : this.relays) {
                PeerAddress pa = relay.relayAddress();
                socketAddresses.add(new PeerSocketAddress(pa.inetAddress(), pa.tcpPort(), pa.udpPort()));
            }
        }
        PeerAddress newAddress = this.peer.peerAddress().changeFirewalledTCP(!hasRelays).changeFirewalledUDP(!hasRelays).changeRelayed(hasRelays).changePeerSocketAddresses(socketAddresses).changeSlow(hasRelays && this.relayConfig.type().isSlow());
        this.peer.peerBean().serverPeerAddress(newAddress);
        LOG.debug("Updated peer address {}, isrelay = {}", (Object)newAddress, (Object)hasRelays);
    }

    @Override
    public void onGCMMessageArrival(String peerId) {
        if (this.relayConfig.type() != RelayType.ANDROID) {
            throw new UnsupportedOperationException("Must be of type 'Android' to access this method");
        }
        if (this.gcmBuffer == null) {
            LOG.trace("GCM messages are unbuffered. Ask relay {} for messages now", (Object)peerId);
            this.sendBufferRequest(peerId);
        } else {
            LOG.trace("Add the GCM message into the buffer before processing it.");
            this.gcmBuffer.addMessage(peerId, 1L);
        }
    }

    private void sendBufferRequest(String relayPeerId) {
        for (BaseRelayConnection relayConnection : this.relays()) {
            String peerId = relayConnection.relayAddress().peerId().toString();
            if (!peerId.equals(relayPeerId) || !(relayConnection instanceof AndroidRelayConnection)) continue;
            ((AndroidRelayConnection)relayConnection).sendBufferRequest();
            return;
        }
        LOG.warn("No connection to relay {} found. Ignoring the message.", (Object)relayPeerId);
    }
}

