/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.security.KeyPair;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.p2p.builder.RoutingBuilder;
import net.tomp2p.p2p.builder.SignatureBuilder;
import net.tomp2p.utils.Utils;

public class ShutdownBuilder
extends DefaultConnectionConfiguration
implements SignatureBuilder<ShutdownBuilder> {
    private static final FutureDone<Void> FUTURE_SHUTDOWN = (FutureDone)new FutureDone().failed("shutdown");
    private final Peer peer;
    private KeyPair keyPair = null;
    private RoutingConfiguration routingConfiguration;
    private boolean forceRoutingOnlyToSelf = false;

    public ShutdownBuilder(Peer peer) {
        this.peer = peer;
    }

    public FutureDone<Void> start() {
        if (this.peer.isShutdown()) {
            return FUTURE_SHUTDOWN;
        }
        this.forceUDP();
        if (this.routingConfiguration == null) {
            this.routingConfiguration = new RoutingConfiguration(8, 10, 2);
        }
        int conn = this.routingConfiguration.parallel();
        FutureChannelCreator fcc = this.peer.connectionBean().reservation().create(conn, 0);
        final FutureDone<Void> futureShutdown = new FutureDone<Void>();
        Utils.addReleaseListener(fcc, futureShutdown);
        fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator futureChannelCreator) throws Exception {
                if (futureChannelCreator.isSuccess()) {
                    ChannelCreator cc = futureChannelCreator.channelCreator();
                    RoutingBuilder routingBuilder = BootstrapBuilder.createBuilder(ShutdownBuilder.this.routingConfiguration, ShutdownBuilder.this.forceRoutingOnlyToSelf);
                    routingBuilder.locationKey(ShutdownBuilder.this.peer.peerID());
                    FutureRouting futureRouting = ShutdownBuilder.this.peer.distributedRouting().quit(routingBuilder, cc);
                    futureRouting.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

                        @Override
                        public void operationComplete(FutureRouting future) throws Exception {
                            if (future.isSuccess()) {
                                futureShutdown.done();
                            } else {
                                futureShutdown.failed(future);
                            }
                        }
                    });
                } else {
                    futureShutdown.failed(futureChannelCreator);
                }
            }
        });
        return futureShutdown;
    }

    @Override
    public boolean isSign() {
        return this.keyPair != null;
    }

    @Override
    public ShutdownBuilder sign(boolean signMessage) {
        if (signMessage) {
            this.sign();
        } else {
            this.keyPair = null;
        }
        return this;
    }

    @Override
    public ShutdownBuilder sign() {
        this.keyPair = this.peer.peerBean().keyPair();
        return this;
    }

    @Override
    public ShutdownBuilder keyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    @Override
    public KeyPair keyPair() {
        return this.keyPair;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public ShutdownBuilder routingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public boolean isForceRoutingOnlyToSelf() {
        return this.forceRoutingOnlyToSelf;
    }

    public ShutdownBuilder forceRoutingOnlyToSelf() {
        this.forceRoutingOnlyToSelf = true;
        return this;
    }

    public ShutdownBuilder forceRoutingOnlyToSelf(boolean forceRoutingOnlyToSelf) {
        this.forceRoutingOnlyToSelf = forceRoutingOnlyToSelf;
        return this;
    }
}

