/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.security.KeyPair;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDirect;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.ProgressListener;
import net.tomp2p.message.Buffer;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.SignatureBuilder;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.SendDirectBuilderI;
import net.tomp2p.utils.Utils;

public class SendDirectBuilder
implements ConnectionConfiguration,
SendDirectBuilderI,
SignatureBuilder<SendDirectBuilder> {
    private static final FutureDirect FUTURE_REQUEST_SHUTDOWN = new FutureDirect("Peer is shutting down");
    private final Peer peer;
    private final PeerAddress recipientAddress;
    private Buffer buffer;
    private FuturePeerConnection recipientConnection;
    private PeerConnection peerConnection;
    private Object object;
    private FutureChannelCreator futureChannelCreator;
    private boolean streaming = false;
    private boolean forceUDP = false;
    private KeyPair keyPair = null;
    private int idleTCPSeconds = ConnectionBean.DEFAULT_TCP_IDLE_SECONDS;
    private int idleUDPSeconds = ConnectionBean.DEFAULT_UDP_IDLE_SECONDS;
    private int connectionTimeoutTCPMillis = ConnectionBean.DEFAULT_CONNECTION_TIMEOUT_TCP;
    private int slowResponseTimeoutSeconds = ConnectionBean.DEFAULT_SLOW_RESPONSE_TIMEOUT_SECONDS;
    private boolean forceTCP = false;
    private ProgressListener progressListener;

    public SendDirectBuilder(Peer peer, PeerAddress recipientAddress) {
        this.peer = peer;
        this.recipientAddress = recipientAddress;
        this.recipientConnection = null;
    }

    public SendDirectBuilder(Peer peer, FuturePeerConnection recipientConnection) {
        this.peer = peer;
        this.recipientAddress = null;
        this.recipientConnection = recipientConnection;
    }

    public SendDirectBuilder(Peer peer, PeerConnection peerConnection) {
        this.peer = peer;
        this.recipientAddress = null;
        this.peerConnection = peerConnection;
    }

    public PeerAddress recipient() {
        return this.recipientAddress;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    public SendDirectBuilder buffer(Buffer buffer) {
        this.buffer = buffer;
        return this;
    }

    public FuturePeerConnection connection() {
        return this.recipientConnection;
    }

    public SendDirectBuilder connection(FuturePeerConnection connection) {
        this.recipientConnection = connection;
        return this;
    }

    public PeerConnection peerConnection() {
        return this.peerConnection;
    }

    public SendDirectBuilder peerConnection(PeerConnection peerConnection) {
        this.peerConnection = peerConnection;
        return this;
    }

    @Override
    public Object object() {
        return this.object;
    }

    public SendDirectBuilder object(Object object) {
        this.object = object;
        return this;
    }

    public FutureChannelCreator futureChannelCreator() {
        return this.futureChannelCreator;
    }

    public SendDirectBuilder futureChannelCreator(FutureChannelCreator futureChannelCreator) {
        this.futureChannelCreator = futureChannelCreator;
        return this;
    }

    public SendDirectBuilder streaming(boolean streaming) {
        this.streaming = streaming;
        return this;
    }

    @Override
    public boolean isStreaming() {
        return this.streaming;
    }

    public SendDirectBuilder streaming() {
        this.streaming = true;
        return this;
    }

    @Override
    public boolean isRaw() {
        return this.object == null;
    }

    public FutureDirect start() {
        PeerAddress remotePeer;
        boolean keepAlive;
        if (this.peer.isShutdown()) {
            return FUTURE_REQUEST_SHUTDOWN;
        }
        if (this.recipientAddress != null && this.recipientConnection == null) {
            keepAlive = false;
            remotePeer = this.recipientAddress;
        } else if (this.recipientAddress == null && this.recipientConnection != null) {
            keepAlive = true;
            remotePeer = this.recipientConnection.remotePeer();
        } else if (this.peerConnection != null) {
            keepAlive = true;
            remotePeer = this.peerConnection.remotePeer();
        } else {
            throw new IllegalArgumentException("either remotePeer or connection has to be set");
        }
        if (this.futureChannelCreator == null) {
            this.futureChannelCreator = this.peer.connectionBean().reservation().create(this.isForceUDP() ? 1 : 0, this.isForceUDP() ? 0 : 1);
        }
        final RequestHandler<FutureResponse> request = this.peer.directDataRPC().sendInternal(remotePeer, this);
        if (keepAlive) {
            if (this.peerConnection != null) {
                SendDirectBuilder.sendDirectRequest(request, this.peerConnection);
            } else {
                this.recipientConnection.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FuturePeerConnection>(){

                    @Override
                    public void operationComplete(FuturePeerConnection future) throws Exception {
                        if (future.isSuccess()) {
                            SendDirectBuilder.sendDirectRequest(request, future.peerConnection());
                        } else {
                            ((BaseFutureImpl)request.futureResponse()).failed("Could not acquire channel (1)", future);
                        }
                    }
                });
            }
        } else {
            Utils.addReleaseListener(this.futureChannelCreator, (BaseFuture)request.futureResponse());
            this.futureChannelCreator.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        request.sendTCP(future.channelCreator());
                    } else {
                        ((BaseFutureImpl)request.futureResponse()).failed("could not create channel", future);
                    }
                }
            });
        }
        return new FutureDirect(request.futureResponse());
    }

    private static void sendDirectRequest(final RequestHandler<FutureResponse> request, final PeerConnection peerConnection) {
        FutureChannelCreator futureChannelCreator2 = peerConnection.acquire(request.futureResponse());
        futureChannelCreator2.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    ((FutureResponse)request.futureResponse()).request().keepAlive(true);
                    request.sendTCP(peerConnection.channelCreator(), peerConnection);
                } else {
                    ((BaseFutureImpl)request.futureResponse()).failed("Could not acquire channel (2)", future);
                }
            }
        });
    }

    @Override
    public boolean isForceUDP() {
        return this.forceUDP;
    }

    public SendDirectBuilder forceUDP(boolean forceUDP) {
        this.forceUDP = forceUDP;
        return this;
    }

    public SendDirectBuilder forceUDP() {
        this.forceUDP = true;
        return this;
    }

    @Override
    public int idleTCPSeconds() {
        return this.idleTCPSeconds;
    }

    public SendDirectBuilder idleTCPSeconds(int idleTCPSeconds) {
        this.idleTCPSeconds = idleTCPSeconds;
        return this;
    }

    @Override
    public int idleUDPSeconds() {
        return this.idleUDPSeconds;
    }

    public SendDirectBuilder idleUDPSeconds(int idleUDPSeconds) {
        this.idleUDPSeconds = idleUDPSeconds;
        return this;
    }

    public SendDirectBuilder connectionTimeoutTCPMillis(int connectionTimeoutTCPMillis) {
        this.connectionTimeoutTCPMillis = connectionTimeoutTCPMillis;
        return this;
    }

    @Override
    public int connectionTimeoutTCPMillis() {
        return this.connectionTimeoutTCPMillis;
    }

    @Override
    public boolean isForceTCP() {
        return this.forceTCP;
    }

    public SendDirectBuilder forceTCP(boolean forceTCP) {
        this.forceTCP = forceTCP;
        return this;
    }

    public SendDirectBuilder forceTCP() {
        this.forceTCP = true;
        return this;
    }

    @Override
    public int slowResponseTimeoutSeconds() {
        return this.slowResponseTimeoutSeconds;
    }

    public SendDirectBuilder slowResponseTimeoutSeconds(int slowResponseTimeoutSeconds) {
        this.slowResponseTimeoutSeconds = slowResponseTimeoutSeconds;
        return this;
    }

    public SendDirectBuilder progressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    @Override
    public ProgressListener progressListener() {
        return this.progressListener;
    }

    @Override
    public boolean isSign() {
        return this.keyPair != null;
    }

    @Override
    public SendDirectBuilder sign(boolean signMessage) {
        if (signMessage) {
            this.sign();
        } else {
            this.keyPair = null;
        }
        return this;
    }

    @Override
    public SendDirectBuilder sign() {
        this.keyPair = this.peer.peerBean().keyPair();
        return this;
    }

    @Override
    public SendDirectBuilder keyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    @Override
    public KeyPair keyPair() {
        return this.keyPair;
    }
}

