/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.net.InetSocketAddress;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.DataMap;
import net.tomp2p.message.KeyCollection;
import net.tomp2p.message.KeyMap640Keys;
import net.tomp2p.message.KeyMapByte;
import net.tomp2p.message.MessageContentIndex;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.message.SignatureCodec;
import net.tomp2p.message.TrackerData;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.rpc.RPC;
import net.tomp2p.rpc.SimpleBloomFilter;

public class Message {
    private static final transient Random RND = new Random();
    public static final int CONTENT_TYPE_LENGTH = 8;
    private int messageId;
    private int version;
    private Type type;
    private byte command;
    private PeerAddress sender;
    private PeerAddress recipient;
    private transient PeerAddress recipientRelay;
    private int options = 0;
    private Content[] contentTypes = new Content[8];
    private final Queue<MessageContentIndex> contentReferences = new LinkedList<MessageContentIndex>();
    private List<NeighborSet> neighborsList = null;
    private List<Number160> keyList = null;
    private List<SimpleBloomFilter<Number160>> bloomFilterList = null;
    private List<DataMap> dataMapList = null;
    private List<Integer> integerList = null;
    private List<Long> longList = null;
    private List<KeyCollection> keyCollectionList = null;
    private List<KeyMap640Keys> keyMap640KeysList = null;
    private List<KeyMapByte> keyMapByteList = null;
    private List<Buffer> bufferList = null;
    private List<TrackerData> trackerDataList = null;
    private List<PublicKey> publicKeyList = null;
    private List<PeerSocketAddress> peerSocketAddressList = null;
    private SignatureCodec signatureEncode = null;
    private transient boolean presetContentTypes = false;
    private transient PrivateKey privateKey;
    private transient InetSocketAddress senderSocket;
    private transient InetSocketAddress recipientSocket;
    private transient boolean udp = false;
    private transient boolean done = false;
    private transient boolean sign = false;
    private transient boolean content = false;
    private transient boolean verified = false;

    public Message() {
        this.messageId = RND.nextInt();
    }

    public int messageId() {
        return this.messageId;
    }

    public Message messageId(int messageId) {
        this.messageId = messageId;
        return this;
    }

    public int version() {
        return this.version;
    }

    public Message version(int version) {
        this.version = version;
        return this;
    }

    public Type type() {
        return this.type;
    }

    public Message type(Type type) {
        this.type = type;
        return this;
    }

    public byte command() {
        return this.command;
    }

    public Message command(byte command) {
        this.command = command;
        return this;
    }

    public PeerAddress sender() {
        return this.sender;
    }

    public Message sender(PeerAddress sender) {
        this.sender = sender;
        return this;
    }

    public PeerAddress recipient() {
        return this.recipient;
    }

    public Message recipient(PeerAddress recipient) {
        this.recipient = recipient;
        return this;
    }

    public PeerAddress recipientRelay() {
        return this.recipientRelay;
    }

    public Message recipientRelay(PeerAddress recipientRelay) {
        this.recipientRelay = recipientRelay;
        return this;
    }

    public Content[] contentTypes() {
        return this.contentTypes;
    }

    public Message contentType(Content contentType) {
        int reference = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.contentTypes[i] == null) {
                if (contentType == Content.PUBLIC_KEY_SIGNATURE && i != 0) {
                    throw new IllegalStateException("The public key needs to be the first to be set");
                }
                this.contentTypes[i] = contentType;
                this.contentReferences.add(new MessageContentIndex(reference, contentType));
                return this;
            }
            if (this.contentTypes[i] == contentType) {
                ++reference;
                continue;
            }
            if (this.contentTypes[i] != Content.PUBLIC_KEY_SIGNATURE && this.contentTypes[i] != Content.PUBLIC_KEY || contentType != Content.PUBLIC_KEY_SIGNATURE && contentType != Content.PUBLIC_KEY) continue;
            ++reference;
        }
        throw new IllegalStateException("Already set 8 content types");
    }

    public void restoreContentReferences() {
        HashMap<Content, Integer> refs = new HashMap<Content, Integer>(this.contentTypes.length * 2);
        for (Content contentType : this.contentTypes) {
            if (contentType == Content.EMPTY || contentType == null) {
                return;
            }
            int index = 0;
            if (contentType == Content.PUBLIC_KEY_SIGNATURE || contentType == Content.PUBLIC_KEY) {
                Integer i1 = (Integer)refs.get((Object)Content.PUBLIC_KEY_SIGNATURE);
                if (i1 != null) {
                    index = i1;
                } else {
                    i1 = (Integer)refs.get((Object)Content.PUBLIC_KEY);
                    if (i1 != null) {
                        index = i1;
                    }
                }
            }
            if (!refs.containsKey((Object)contentType)) {
                refs.put(contentType, index);
            } else {
                index = (Integer)refs.get((Object)contentType);
            }
            this.contentReferences.add(new MessageContentIndex(index, contentType));
            refs.put(contentType, index + 1);
        }
    }

    public void restoreBuffers() {
        for (Buffer buffer : this.bufferList()) {
            buffer.reset();
        }
    }

    public Message contentType(int index, Content contentType) {
        this.contentTypes[index] = contentType;
        return this;
    }

    public Message contentTypes(Content[] contentTypes) {
        this.contentTypes = contentTypes;
        return this;
    }

    public Queue<MessageContentIndex> contentReferences() {
        return this.contentReferences;
    }

    public boolean hasContent() {
        return this.contentReferences.size() > 0 || this.content;
    }

    public Message hasContent(boolean content) {
        this.content = content;
        return this;
    }

    public boolean isRequest() {
        return this.type == Type.REQUEST_1 || this.type == Type.REQUEST_2 || this.type == Type.REQUEST_3 || this.type == Type.REQUEST_4 || this.type == Type.REQUEST_5 || this.type == Type.REQUEST_FF_1 || this.type == Type.REQUEST_FF_2;
    }

    public boolean isFireAndForget() {
        return this.type == Type.REQUEST_FF_1 || this.type == Type.REQUEST_FF_2;
    }

    public boolean isOk() {
        return this.type == Type.OK || this.type == Type.PARTIALLY_OK;
    }

    public boolean isNotOk() {
        return this.type == Type.NOT_FOUND || this.type == Type.DENIED;
    }

    public boolean isError() {
        return Message.isError(this.type);
    }

    public static boolean isError(Type type) {
        return type == Type.UNKNOWN_ID || type == Type.EXCEPTION || type == Type.CANCEL;
    }

    public Message options(int options) {
        this.options = options;
        return this;
    }

    public int options() {
        return this.options;
    }

    public Message keepAlive(boolean isKeepAlive) {
        this.options = isKeepAlive ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
        return this;
    }

    public boolean isKeepAlive() {
        return (this.options & 1) > 0;
    }

    public Message streaming() {
        return this.streaming(true);
    }

    public Message streaming(boolean streaming) {
        this.options = streaming ? (this.options |= 2) : (this.options &= 0xFFFFFFFD);
        return this;
    }

    public boolean isStreaming() {
        return (this.options & 2) > 0;
    }

    public Message key(Number160 key) {
        if (!this.presetContentTypes) {
            this.contentType(Content.KEY);
        }
        if (this.keyList == null) {
            this.keyList = new ArrayList<Number160>(1);
        }
        this.keyList.add(key);
        return this;
    }

    public List<Number160> keyList() {
        if (this.keyList == null) {
            return Collections.emptyList();
        }
        return this.keyList;
    }

    public Number160 key(int index) {
        if (this.keyList == null || index > this.keyList.size() - 1) {
            return null;
        }
        return this.keyList.get(index);
    }

    public Message bloomFilter(SimpleBloomFilter<Number160> bloomFilter) {
        if (!this.presetContentTypes) {
            this.contentType(Content.BLOOM_FILTER);
        }
        if (this.bloomFilterList == null) {
            this.bloomFilterList = new ArrayList<SimpleBloomFilter<Number160>>(1);
        }
        this.bloomFilterList.add(bloomFilter);
        return this;
    }

    public List<SimpleBloomFilter<Number160>> bloomFilterList() {
        if (this.bloomFilterList == null) {
            return Collections.emptyList();
        }
        return this.bloomFilterList;
    }

    public SimpleBloomFilter<Number160> bloomFilter(int index) {
        if (this.bloomFilterList == null || index > this.bloomFilterList.size() - 1) {
            return null;
        }
        return this.bloomFilterList.get(index);
    }

    public Message publicKeyAndSign(KeyPair keyPair) {
        if (!this.presetContentTypes) {
            this.contentType(Content.PUBLIC_KEY_SIGNATURE);
        }
        this.publicKey0(keyPair.getPublic());
        this.privateKey = keyPair.getPrivate();
        return this;
    }

    public Message intValue(int integer) {
        if (!this.presetContentTypes) {
            this.contentType(Content.INTEGER);
        }
        if (this.integerList == null) {
            this.integerList = new ArrayList<Integer>(1);
        }
        this.integerList.add(integer);
        return this;
    }

    public List<Integer> intList() {
        if (this.integerList == null) {
            return Collections.emptyList();
        }
        return this.integerList;
    }

    public Integer intAt(int index) {
        if (this.integerList == null || index > this.integerList.size() - 1) {
            return null;
        }
        return this.integerList.get(index);
    }

    public Message longValue(long long0) {
        if (!this.presetContentTypes) {
            this.contentType(Content.LONG);
        }
        if (this.longList == null) {
            this.longList = new ArrayList<Long>(1);
        }
        this.longList.add(long0);
        return this;
    }

    public List<Long> longList() {
        if (this.longList == null) {
            return Collections.emptyList();
        }
        return this.longList;
    }

    public Long longAt(int index) {
        if (this.longList == null || index > this.longList.size() - 1) {
            return null;
        }
        return this.longList.get(index);
    }

    public Message neighborsSet(NeighborSet neighborSet) {
        if (!this.presetContentTypes) {
            this.contentType(Content.SET_NEIGHBORS);
        }
        if (this.neighborsList == null) {
            this.neighborsList = new ArrayList<NeighborSet>(1);
        }
        this.neighborsList.add(neighborSet);
        return this;
    }

    public List<NeighborSet> neighborsSetList() {
        if (this.neighborsList == null) {
            return Collections.emptyList();
        }
        return this.neighborsList;
    }

    public NeighborSet neighborsSet(int index) {
        if (this.neighborsList == null || index > this.neighborsList.size() - 1) {
            return null;
        }
        return this.neighborsList.get(index);
    }

    public Message setDataMap(DataMap dataMap) {
        if (!this.presetContentTypes) {
            this.contentType(Content.MAP_KEY640_DATA);
        }
        if (this.dataMapList == null) {
            this.dataMapList = new ArrayList<DataMap>(1);
        }
        this.dataMapList.add(dataMap);
        return this;
    }

    public List<DataMap> dataMapList() {
        if (this.dataMapList == null) {
            return Collections.emptyList();
        }
        return this.dataMapList;
    }

    public DataMap dataMap(int index) {
        if (this.dataMapList == null || index > this.dataMapList.size() - 1) {
            return null;
        }
        return this.dataMapList.get(index);
    }

    public Message keyCollection(KeyCollection key) {
        if (!this.presetContentTypes) {
            this.contentType(Content.SET_KEY640);
        }
        if (this.keyCollectionList == null) {
            this.keyCollectionList = new ArrayList<KeyCollection>(1);
        }
        this.keyCollectionList.add(key);
        return this;
    }

    public List<KeyCollection> keyCollectionList() {
        if (this.keyCollectionList == null) {
            return Collections.emptyList();
        }
        return this.keyCollectionList;
    }

    public KeyCollection keyCollection(int index) {
        if (this.keyCollectionList == null || index > this.keyCollectionList.size() - 1) {
            return null;
        }
        return this.keyCollectionList.get(index);
    }

    public Message keyMap640Keys(KeyMap640Keys keyMap) {
        if (!this.presetContentTypes) {
            this.contentType(Content.MAP_KEY640_KEYS);
        }
        if (this.keyMap640KeysList == null) {
            this.keyMap640KeysList = new ArrayList<KeyMap640Keys>(1);
        }
        this.keyMap640KeysList.add(keyMap);
        return this;
    }

    public List<KeyMap640Keys> keyMap640KeysList() {
        if (this.keyMap640KeysList == null) {
            return Collections.emptyList();
        }
        return this.keyMap640KeysList;
    }

    public KeyMap640Keys keyMap640Keys(int index) {
        if (this.keyMap640KeysList == null || index > this.keyMap640KeysList.size() - 1) {
            return null;
        }
        return this.keyMap640KeysList.get(index);
    }

    public Message keyMapByte(KeyMapByte keyMap) {
        if (!this.presetContentTypes) {
            this.contentType(Content.MAP_KEY640_BYTE);
        }
        if (this.keyMapByteList == null) {
            this.keyMapByteList = new ArrayList<KeyMapByte>(1);
        }
        this.keyMapByteList.add(keyMap);
        return this;
    }

    public List<KeyMapByte> keyMapByteList() {
        if (this.keyMapByteList == null) {
            return Collections.emptyList();
        }
        return this.keyMapByteList;
    }

    public KeyMapByte keyMapByte(int index) {
        if (this.keyMapByteList == null || index > this.keyMapByteList.size() - 1) {
            return null;
        }
        return this.keyMapByteList.get(index);
    }

    public Message publicKey(PublicKey publicKey) {
        if (!this.presetContentTypes) {
            this.contentType(Content.PUBLIC_KEY);
        }
        if (this.publicKeyList == null) {
            this.publicKeyList = new ArrayList<PublicKey>(1);
        }
        this.publicKeyList.add(publicKey);
        return this;
    }

    private Message publicKey0(PublicKey publicKey) {
        if (this.publicKeyList == null) {
            this.publicKeyList = new ArrayList<PublicKey>(1);
        }
        this.publicKeyList.add(publicKey);
        return this;
    }

    public List<PublicKey> publicKeyList() {
        if (this.publicKeyList == null) {
            return Collections.emptyList();
        }
        return this.publicKeyList;
    }

    public PublicKey publicKey(int index) {
        if (this.publicKeyList == null || index > this.publicKeyList.size() - 1) {
            return null;
        }
        return this.publicKeyList.get(index);
    }

    public Message peerSocketAddresses(Collection<PeerSocketAddress> peerSocketAddresses) {
        if (!this.presetContentTypes) {
            this.contentType(Content.SET_PEER_SOCKET);
        }
        if (this.peerSocketAddressList == null) {
            this.peerSocketAddressList = new ArrayList<PeerSocketAddress>(peerSocketAddresses.size());
        }
        this.peerSocketAddressList.addAll(peerSocketAddresses);
        return this;
    }

    public List<PeerSocketAddress> peerSocketAddresses() {
        if (this.peerSocketAddressList == null) {
            return Collections.emptyList();
        }
        return this.peerSocketAddressList;
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }

    public Message buffer(Buffer byteBuf) {
        if (!this.presetContentTypes) {
            this.contentType(Content.BYTE_BUFFER);
        }
        if (this.bufferList == null) {
            this.bufferList = new ArrayList<Buffer>(1);
        }
        this.bufferList.add(byteBuf);
        return this;
    }

    public List<Buffer> bufferList() {
        if (this.bufferList == null) {
            return Collections.emptyList();
        }
        return this.bufferList;
    }

    public Buffer buffer(int index) {
        if (this.bufferList == null || index > this.bufferList.size() - 1) {
            return null;
        }
        return this.bufferList.get(index);
    }

    public Message trackerData(TrackerData trackerData) {
        if (!this.presetContentTypes) {
            this.contentType(Content.SET_TRACKER_DATA);
        }
        if (this.trackerDataList == null) {
            this.trackerDataList = new ArrayList<TrackerData>(1);
        }
        this.trackerDataList.add(trackerData);
        return this;
    }

    public List<TrackerData> trackerDataList() {
        if (this.trackerDataList == null) {
            return Collections.emptyList();
        }
        return this.trackerDataList;
    }

    public TrackerData trackerData(int index) {
        if (this.trackerDataList == null || index > this.trackerDataList.size() - 1) {
            return null;
        }
        return this.trackerDataList.get(index);
    }

    public Message receivedSignature(SignatureCodec signatureEncode) {
        this.signatureEncode = signatureEncode;
        return this;
    }

    public SignatureCodec receivedSignature() {
        return this.signatureEncode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("msgid=");
        return sb.append(this.messageId()).append(",t=").append(this.type.toString()).append(",c=").append(RPC.Commands.find(this.command).toString()).append(",").append(this.isUdp() ? "udp" : "tcp").append(",s=").append(this.sender).append(",r=").append(this.recipient).toString();
    }

    public Message presetContentTypes(boolean presetContentTypes) {
        this.presetContentTypes = presetContentTypes;
        return this;
    }

    public Message senderSocket(InetSocketAddress senderSocket) {
        this.senderSocket = senderSocket;
        return this;
    }

    public InetSocketAddress senderSocket() {
        return this.senderSocket;
    }

    public Message recipientSocket(InetSocketAddress recipientSocket) {
        this.recipientSocket = recipientSocket;
        return this;
    }

    public InetSocketAddress recipientSocket() {
        return this.recipientSocket;
    }

    public Message setHintSign() {
        this.sign = true;
        return this;
    }

    public boolean isSign() {
        return this.sign || this.privateKey != null;
    }

    public Message udp(boolean udp) {
        this.udp = udp;
        return this;
    }

    public boolean isUdp() {
        return this.udp;
    }

    public Message verified(boolean verified) {
        this.verified = verified;
        return this;
    }

    public boolean verified() {
        return this.verified;
    }

    public Message setVerified() {
        this.verified = true;
        return this;
    }

    public Message setDone(boolean done) {
        this.done = done;
        return this;
    }

    public Message setDone() {
        return this.setDone(true);
    }

    public boolean isDone() {
        return this.done;
    }

    public static enum Type {
        REQUEST_1,
        REQUEST_2,
        REQUEST_3,
        REQUEST_4,
        REQUEST_5,
        REQUEST_FF_1,
        REQUEST_FF_2,
        OK,
        PARTIALLY_OK,
        NOT_FOUND,
        DENIED,
        UNKNOWN_ID,
        EXCEPTION,
        CANCEL,
        RESERVED1;

    }

    public static enum Content {
        EMPTY,
        KEY,
        MAP_KEY640_DATA,
        MAP_KEY640_KEYS,
        SET_KEY640,
        SET_NEIGHBORS,
        BYTE_BUFFER,
        LONG,
        INTEGER,
        PUBLIC_KEY_SIGNATURE,
        SET_TRACKER_DATA,
        BLOOM_FILTER,
        MAP_KEY640_BYTE,
        PUBLIC_KEY,
        SET_PEER_SOCKET,
        USER1;

    }
}

