/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramChannel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.TreeMap;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.connection.TimeoutFactory;
import net.tomp2p.message.Buffer;
import net.tomp2p.message.DataMap;
import net.tomp2p.message.KeyCollection;
import net.tomp2p.message.KeyMap640Keys;
import net.tomp2p.message.KeyMapByte;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageHeaderCodec;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.message.SignatureCodec;
import net.tomp2p.message.TrackerData;
import net.tomp2p.p2p.PeerBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.DataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decoder {
    public static final AttributeKey<InetSocketAddress> INET_ADDRESS_KEY = AttributeKey.valueOf((String)"inet-addr");
    public static final AttributeKey<PeerAddress> PEER_ADDRESS_KEY = AttributeKey.valueOf((String)"peer-addr");
    private static final Logger LOG = LoggerFactory.getLogger(Decoder.class);
    private final Queue<Message.Content> contentTypes = new LinkedList<Message.Content>();
    private Message message = null;
    private int neighborSize = -1;
    private NeighborSet neighborSet = null;
    private int peerSocketAddressSize = -1;
    private List<PeerSocketAddress> peerSocketAddresses = null;
    private int keyCollectionSize = -1;
    private KeyCollection keyCollection = null;
    private int mapSize = -1;
    private DataMap dataMap = null;
    private Data data = null;
    private Number640 key = null;
    private int keyMap640KeysSize = -1;
    private KeyMap640Keys keyMap640Keys = null;
    private int keyMapByteSize = -1;
    private KeyMapByte keyMapByte = null;
    private int bufferSize = -1;
    private DataBuffer buffer = null;
    private int trackerDataSize = -1;
    private TrackerData trackerData = null;
    private Data currentTrackerData = null;
    private Message.Content lastContent = null;
    private final SignatureFactory signatureFactory;

    public Decoder(SignatureFactory signatureFactory) {
        this.signatureFactory = signatureFactory;
    }

    public boolean decode(ChannelHandlerContext ctx, ByteBuf buf, InetSocketAddress recipient, InetSocketAddress sender) {
        LOG.debug("Decoding of TomP2P starts now. Readable: {}.", (Object)buf.readableBytes());
        try {
            boolean isRelay;
            int readerBefore = buf.readerIndex();
            Attribute attributeInet = ctx.attr(INET_ADDRESS_KEY);
            attributeInet.set((Object)sender);
            if (this.message == null) {
                boolean doneHeader = this.decodeHeader(buf, recipient, sender);
                if (doneHeader) {
                    Attribute attributePeerAddress = ctx.attr(PEER_ADDRESS_KEY);
                    attributePeerAddress.set((Object)this.message.sender());
                    this.message.udp(ctx.channel() instanceof DatagramChannel);
                    if (this.message.isFireAndForget() && this.message.isUdp()) {
                        TimeoutFactory.removeTimeout(ctx);
                    }
                } else {
                    return false;
                }
            }
            boolean donePayload = this.decodePayload(buf);
            this.decodeSignature(buf, readerBefore, donePayload);
            if (donePayload && (isRelay = this.message.sender().isRelayed()) && !this.message.peerSocketAddresses().isEmpty()) {
                PeerAddress tmpSender = this.message.sender().changePeerSocketAddresses(this.message.peerSocketAddresses());
                this.message.sender(tmpSender);
            }
            buf.discardSomeReadBytes();
            return donePayload;
        }
        catch (Exception e) {
            ctx.fireExceptionCaught((Throwable)e);
            e.printStackTrace();
            return true;
        }
    }

    public void decodeSignature(ByteBuf buf, int readerBefore, boolean donePayload) throws InvalidKeyException, SignatureException, IOException {
        int readerAfter = buf.readerIndex();
        int len = readerAfter - readerBefore;
        if (len > 0) {
            this.verifySignature(buf, readerBefore, len, donePayload);
        }
    }

    private void verifySignature(ByteBuf buf, int readerBefore, int len, boolean donePayload) throws SignatureException, IOException, InvalidKeyException {
        if (!this.message.isSign()) {
            return;
        }
        int length = donePayload ? len - 40 : len;
        ByteBuffer[] byteBuffers = buf.nioBuffers(readerBefore, length);
        Signature signature = this.signatureFactory.update(this.message.publicKey(0), byteBuffers);
        if (donePayload) {
            byte[] signatureReceived = this.message.receivedSignature().encode();
            if (signature.verify(signatureReceived)) {
                this.message.setVerified();
                LOG.debug("Signature check OK.");
            } else {
                LOG.warn("Signature check NOT OK. Message: {}.", (Object)this.message);
            }
        }
    }

    public boolean decodeHeader(ByteBuf buf, InetSocketAddress recipient, InetSocketAddress sender) {
        if (this.message == null) {
            if (buf.readableBytes() < 58) {
                return false;
            }
            this.message = MessageHeaderCodec.decodeHeader(buf, recipient, sender);
            this.message.presetContentTypes(true);
            for (Message.Content content : this.message.contentTypes()) {
                if (content == Message.Content.EMPTY) break;
                if (content == Message.Content.PUBLIC_KEY_SIGNATURE) {
                    this.message.setHintSign();
                }
                this.contentTypes.offer(content);
            }
            LOG.debug("Parsed message {}.", (Object)this.message);
            return true;
        }
        return false;
    }

    public boolean decodePayload(ByteBuf buf) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        int size;
        LOG.debug("About to pass message {} to {}. Buffer to read: {}.", new Object[]{this.message, this.message.senderSocket(), buf.readableBytes()});
        if (!this.message.hasContent()) {
            return true;
        }
        while (this.contentTypes.size() > 0) {
            Message.Content content = this.contentTypes.peek();
            LOG.debug("Go for content: {}.", (Object)content);
            switch (content) {
                case INTEGER: {
                    if (buf.readableBytes() < 4) {
                        return false;
                    }
                    this.message.intValue(buf.readInt());
                    this.lastContent = this.contentTypes.poll();
                    break;
                }
                case LONG: {
                    if (buf.readableBytes() < 8) {
                        return false;
                    }
                    this.message.longValue(buf.readLong());
                    this.lastContent = this.contentTypes.poll();
                    break;
                }
                case KEY: {
                    if (buf.readableBytes() < 20) {
                        return false;
                    }
                    byte[] me = new byte[20];
                    buf.readBytes(me);
                    this.message.key(new Number160(me));
                    this.lastContent = this.contentTypes.poll();
                    break;
                }
                case BLOOM_FILTER: {
                    if (buf.readableBytes() < 2) {
                        return false;
                    }
                    size = buf.getUnsignedShort(buf.readerIndex());
                    if (buf.readableBytes() < size) {
                        return false;
                    }
                    this.message.bloomFilter(new SimpleBloomFilter<Number160>(buf));
                    this.lastContent = this.contentTypes.poll();
                    break;
                }
                case SET_NEIGHBORS: {
                    int i;
                    if (this.neighborSize == -1 && buf.readableBytes() < 1) {
                        return false;
                    }
                    if (this.neighborSize == -1) {
                        this.neighborSize = buf.readUnsignedByte();
                    }
                    if (this.neighborSet == null) {
                        this.neighborSet = new NeighborSet(-1, new ArrayList<PeerAddress>(this.neighborSize));
                    }
                    for (i = this.neighborSet.size(); i < this.neighborSize; ++i) {
                        if (buf.readableBytes() < 2) {
                            return false;
                        }
                        int header = buf.getUnsignedShort(buf.readerIndex());
                        size = PeerAddress.size(header);
                        if (buf.readableBytes() < size) {
                            return false;
                        }
                        PeerAddress pa = new PeerAddress(buf);
                        this.neighborSet.add(pa);
                    }
                    this.message.neighborsSet(this.neighborSet);
                    this.lastContent = this.contentTypes.poll();
                    this.neighborSize = -1;
                    this.neighborSet = null;
                    break;
                }
                case SET_PEER_SOCKET: {
                    int i;
                    if (this.peerSocketAddressSize == -1 && buf.readableBytes() < 1) {
                        return false;
                    }
                    if (this.peerSocketAddressSize == -1) {
                        this.peerSocketAddressSize = buf.readUnsignedByte();
                    }
                    if (this.peerSocketAddresses == null) {
                        this.peerSocketAddresses = new ArrayList<PeerSocketAddress>(this.peerSocketAddressSize);
                    }
                    for (i = this.peerSocketAddresses.size(); i < this.peerSocketAddressSize; ++i) {
                        if (buf.readableBytes() < 1) {
                            return false;
                        }
                        short header = buf.getUnsignedByte(buf.readerIndex());
                        boolean isIPv4 = header == 0;
                        size = PeerSocketAddress.size(isIPv4);
                        if (buf.readableBytes() < size + 1) {
                            return false;
                        }
                        buf.skipBytes(1);
                        this.peerSocketAddresses.add(PeerSocketAddress.create(buf, isIPv4));
                    }
                    this.message.peerSocketAddresses(this.peerSocketAddresses);
                    this.lastContent = this.contentTypes.poll();
                    this.peerSocketAddressSize = -1;
                    this.peerSocketAddresses = null;
                    break;
                }
                case SET_KEY640: {
                    Number160 domainKey;
                    int i;
                    if (this.keyCollectionSize == -1 && buf.readableBytes() < 4) {
                        return false;
                    }
                    if (this.keyCollectionSize == -1) {
                        this.keyCollectionSize = buf.readInt();
                    }
                    if (this.keyCollection == null) {
                        this.keyCollection = new KeyCollection(new ArrayList<Number640>(this.keyCollectionSize));
                    }
                    for (i = this.keyCollection.size(); i < this.keyCollectionSize; ++i) {
                        if (buf.readableBytes() < 80) {
                            return false;
                        }
                        byte[] me2 = new byte[20];
                        buf.readBytes(me2);
                        Number160 locationKey = new Number160(me2);
                        buf.readBytes(me2);
                        domainKey = new Number160(me2);
                        buf.readBytes(me2);
                        Number160 contentKey = new Number160(me2);
                        buf.readBytes(me2);
                        Number160 versionKey = new Number160(me2);
                        this.keyCollection.add(new Number640(locationKey, domainKey, contentKey, versionKey));
                    }
                    this.message.keyCollection(this.keyCollection);
                    this.lastContent = this.contentTypes.poll();
                    this.keyCollectionSize = -1;
                    this.keyCollection = null;
                    break;
                }
                case MAP_KEY640_DATA: {
                    Number160 domainKey;
                    int i;
                    if (this.mapSize == -1 && buf.readableBytes() < 4) {
                        return false;
                    }
                    if (this.mapSize == -1) {
                        this.mapSize = buf.readInt();
                    }
                    if (this.dataMap == null) {
                        this.dataMap = new DataMap(new HashMap<Number640, Data>(2 * this.mapSize));
                    }
                    if (this.data != null) {
                        if (!this.data.decodeBuffer(buf)) {
                            return false;
                        }
                        if (!this.data.decodeDone(buf, this.message.publicKey(0), this.signatureFactory)) {
                            return false;
                        }
                        this.data = null;
                        this.key = null;
                    }
                    for (i = this.dataMap.size(); i < this.mapSize; ++i) {
                        if (this.key == null) {
                            if (buf.readableBytes() < 80) {
                                return false;
                            }
                            byte[] me3 = new byte[20];
                            buf.readBytes(me3);
                            Number160 locationKey = new Number160(me3);
                            buf.readBytes(me3);
                            domainKey = new Number160(me3);
                            buf.readBytes(me3);
                            Number160 contentKey = new Number160(me3);
                            buf.readBytes(me3);
                            Number160 versionKey = new Number160(me3);
                            this.key = new Number640(locationKey, domainKey, contentKey, versionKey);
                        }
                        this.data = Data.decodeHeader(buf, this.signatureFactory);
                        if (this.data == null) {
                            return false;
                        }
                        this.dataMap.dataMap().put(this.key, this.data);
                        if (!this.data.decodeBuffer(buf)) {
                            return false;
                        }
                        if (!this.data.decodeDone(buf, this.message.publicKey(0), this.signatureFactory)) {
                            return false;
                        }
                        if (this.message.isSign() && this.message.publicKey(0) != null && this.data.hasPublicKey() && (this.data.publicKey() == null || this.data.publicKey() == PeerBuilder.EMPTY_PUBLIC_KEY)) {
                            this.data.publicKey(this.message.publicKey(0));
                        }
                        this.data = null;
                        this.key = null;
                    }
                    this.message.setDataMap(this.dataMap);
                    this.lastContent = this.contentTypes.poll();
                    this.mapSize = -1;
                    this.dataMap = null;
                    break;
                }
                case MAP_KEY640_KEYS: {
                    Number160 versionKey;
                    Number160 locationKey;
                    int i;
                    if (this.keyMap640KeysSize == -1 && buf.readableBytes() < 4) {
                        return false;
                    }
                    if (this.keyMap640KeysSize == -1) {
                        this.keyMap640KeysSize = buf.readInt();
                    }
                    if (this.keyMap640Keys == null) {
                        this.keyMap640Keys = new KeyMap640Keys(new TreeMap<Number640, Collection<Number160>>());
                    }
                    int meta = 80;
                    for (i = this.keyMap640Keys.size(); i < this.keyMap640KeysSize; ++i) {
                        if (buf.readableBytes() < 81) {
                            return false;
                        }
                        size = buf.getUnsignedByte(buf.readerIndex() + 80);
                        if (buf.readableBytes() < 81 + size * 20) {
                            return false;
                        }
                        byte[] me3 = new byte[20];
                        buf.readBytes(me3);
                        locationKey = new Number160(me3);
                        buf.readBytes(me3);
                        Number160 domainKey = new Number160(me3);
                        buf.readBytes(me3);
                        Number160 contentKey = new Number160(me3);
                        buf.readBytes(me3);
                        versionKey = new Number160(me3);
                        int numBasedOn = buf.readByte();
                        HashSet<Number160> value = new HashSet<Number160>(numBasedOn);
                        for (int j = 0; j < numBasedOn; ++j) {
                            buf.readBytes(me3);
                            Number160 basedOnKey = new Number160(me3);
                            value.add(basedOnKey);
                        }
                        this.keyMap640Keys.put(new Number640(locationKey, domainKey, contentKey, versionKey), value);
                    }
                    this.message.keyMap640Keys(this.keyMap640Keys);
                    this.lastContent = this.contentTypes.poll();
                    this.keyMap640KeysSize = -1;
                    this.keyMap640Keys = null;
                    break;
                }
                case MAP_KEY640_BYTE: {
                    Number160 versionKey;
                    Number160 locationKey;
                    int i;
                    if (this.keyMapByteSize == -1 && buf.readableBytes() < 4) {
                        return false;
                    }
                    if (this.keyMapByteSize == -1) {
                        this.keyMapByteSize = buf.readInt();
                    }
                    if (this.keyMapByte == null) {
                        this.keyMapByte = new KeyMapByte(new HashMap<Number640, Byte>(2 * this.keyMapByteSize));
                    }
                    for (i = this.keyMapByte.size(); i < this.keyMapByteSize; ++i) {
                        if (buf.readableBytes() < 81) {
                            return false;
                        }
                        byte[] me3 = new byte[20];
                        buf.readBytes(me3);
                        locationKey = new Number160(me3);
                        buf.readBytes(me3);
                        Number160 domainKey = new Number160(me3);
                        buf.readBytes(me3);
                        Number160 contentKey = new Number160(me3);
                        buf.readBytes(me3);
                        versionKey = new Number160(me3);
                        byte value = buf.readByte();
                        this.keyMapByte.put(new Number640(locationKey, domainKey, contentKey, versionKey), value);
                    }
                    this.message.keyMapByte(this.keyMapByte);
                    this.lastContent = this.contentTypes.poll();
                    this.keyMapByteSize = -1;
                    this.keyMapByte = null;
                    break;
                }
                case BYTE_BUFFER: {
                    int read;
                    int already;
                    int remaining;
                    if (this.bufferSize == -1 && buf.readableBytes() < 4) {
                        return false;
                    }
                    if (this.bufferSize == -1) {
                        this.bufferSize = buf.readInt();
                    }
                    if (this.buffer == null) {
                        this.buffer = new DataBuffer();
                    }
                    if ((remaining = this.bufferSize - (already = this.buffer.alreadyTransferred())) != 0 && (read = this.buffer.transferFrom(buf, remaining)) != remaining) {
                        LOG.debug("Still looking for data. Indicating that its not finished yet. Read = {}, Size = {}.", (Object)this.buffer.alreadyTransferred(), (Object)this.bufferSize);
                        return false;
                    }
                    AlternativeCompositeByteBuf buf2 = AlternativeCompositeByteBuf.compBuffer(this.buffer.toByteBufs());
                    this.message.buffer(new Buffer(buf2, this.bufferSize));
                    this.lastContent = this.contentTypes.poll();
                    this.bufferSize = -1;
                    this.buffer = null;
                    break;
                }
                case SET_TRACKER_DATA: {
                    if (this.trackerDataSize == -1 && buf.readableBytes() < 1) {
                        return false;
                    }
                    if (this.trackerDataSize == -1) {
                        this.trackerDataSize = buf.readUnsignedByte();
                    }
                    if (this.trackerData == null) {
                        this.trackerData = new TrackerData(new HashMap<PeerAddress, Data>(2 * this.trackerDataSize));
                    }
                    if (this.currentTrackerData != null) {
                        if (!this.currentTrackerData.decodeBuffer(buf)) {
                            return false;
                        }
                        if (!this.currentTrackerData.decodeDone(buf, this.message.publicKey(0), this.signatureFactory)) {
                            return false;
                        }
                        this.currentTrackerData = null;
                    }
                    for (int i = this.trackerData.size(); i < this.trackerDataSize; ++i) {
                        if (buf.readableBytes() < 2) {
                            return false;
                        }
                        int header = buf.getUnsignedShort(buf.readerIndex());
                        size = PeerAddress.size(header);
                        if (buf.readableBytes() < size) {
                            return false;
                        }
                        PeerAddress pa = new PeerAddress(buf);
                        this.currentTrackerData = Data.decodeHeader(buf, this.signatureFactory);
                        if (this.currentTrackerData == null) {
                            return false;
                        }
                        this.trackerData.peerAddresses().put(pa, this.currentTrackerData);
                        if (this.message.isSign()) {
                            this.currentTrackerData.publicKey(this.message.publicKey(0));
                        }
                        if (!this.currentTrackerData.decodeBuffer(buf)) {
                            return false;
                        }
                        if (!this.currentTrackerData.decodeDone(buf, this.message.publicKey(0), this.signatureFactory)) {
                            return false;
                        }
                        this.currentTrackerData = null;
                    }
                    this.message.trackerData(this.trackerData);
                    this.lastContent = this.contentTypes.poll();
                    this.trackerDataSize = -1;
                    this.trackerData = null;
                    break;
                }
                case PUBLIC_KEY: 
                case PUBLIC_KEY_SIGNATURE: {
                    PublicKey receivedPublicKey = this.signatureFactory.decodePublicKey(buf);
                    if (content == Message.Content.PUBLIC_KEY_SIGNATURE && receivedPublicKey == PeerBuilder.EMPTY_PUBLIC_KEY) {
                        throw new InvalidKeyException("The public key cannot be empty");
                    }
                    if (receivedPublicKey == null) {
                        return false;
                    }
                    this.message.publicKey(receivedPublicKey);
                    this.lastContent = this.contentTypes.poll();
                    break;
                }
            }
        }
        if (this.message.isSign()) {
            SignatureCodec signatureEncode = this.signatureFactory.signatureCodec();
            size = signatureEncode.signatureSize();
            if (buf.readableBytes() < size) {
                return false;
            }
            signatureEncode.read(buf);
            this.message.receivedSignature(signatureEncode);
        }
        return true;
    }

    public Message prepareFinish() {
        Message ret = this.message;
        this.message.setDone();
        this.contentTypes.clear();
        this.message = null;
        this.neighborSize = -1;
        this.neighborSet = null;
        this.keyCollectionSize = -1;
        this.keyCollection = null;
        this.mapSize = -1;
        this.dataMap = null;
        this.data = null;
        this.keyMap640KeysSize = -1;
        this.keyMap640Keys = null;
        this.bufferSize = -1;
        this.buffer = null;
        return ret;
    }

    public Message message() {
        return this.message;
    }

    public Message.Content lastContent() {
        return this.lastContent;
    }
}

