/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import net.tomp2p.utils.Utils;

public class PeerSocketAddress
implements Serializable {
    private static final long serialVersionUID = 8483270473601620720L;
    private final InetAddress inetAddress;
    private final int tcpPort;
    private final int udpPort;
    private final int offset;

    public PeerSocketAddress(InetAddress inetAddress, int tcpPort, int udpPort) {
        this(inetAddress, tcpPort, udpPort, -1);
    }

    public PeerSocketAddress(InetAddress inetAddress, int tcpPort, int udpPort, int offset) {
        this.inetAddress = inetAddress;
        this.tcpPort = tcpPort;
        this.udpPort = udpPort;
        this.offset = offset;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] toByteArray() {
        byte[] retVal;
        int size2;
        int size = this.size();
        if (size != (size2 = this.toByteArray(retVal = new byte[size], 0))) {
            throw new RuntimeException("sizes do not match");
        }
        return retVal;
    }

    public int size() {
        return 4 + (this.isIPv4() ? 4 : 16);
    }

    public static int size(int header) {
        boolean isIPv4 = header == 0;
        return 4 + (isIPv4 ? 4 : 16);
    }

    public int toByteArray(byte[] me, int offset) {
        int offset2 = offset;
        me[offset2++] = (byte)(this.tcpPort >>> 8);
        me[offset2++] = (byte)this.tcpPort;
        me[offset2++] = (byte)(this.udpPort >>> 8);
        me[offset2++] = (byte)this.udpPort;
        if (this.inetAddress instanceof Inet4Address) {
            System.arraycopy(this.inetAddress.getAddress(), 0, me, offset2, 4);
            offset2 += 4;
        } else {
            System.arraycopy(this.inetAddress.getAddress(), 0, me, offset2, 16);
            offset2 += 16;
        }
        return offset2;
    }

    public boolean isIPv4() {
        return this.inetAddress instanceof Inet4Address;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PSA[");
        sb.append(this.inetAddress).append(",t:").append(this.tcpPort).append(",u:").append(this.udpPort).append("]");
        return sb.toString();
    }

    public static PeerSocketAddress create(byte[] me, boolean isIPv4, int offsetOriginal) {
        InetAddress address;
        int offset = offsetOriginal;
        int portTCP = ((me[offset++] & 0xFF) << 8) + (me[offset++] & 0xFF);
        int portUDP = ((me[offset++] & 0xFF) << 8) + (me[offset++] & 0xFF);
        if (isIPv4) {
            address = Utils.inet4FromBytes(me, offset);
            offset += 4;
        } else {
            address = Utils.inet6FromBytes(me, offset);
            offset += 16;
        }
        return new PeerSocketAddress(address, portTCP, portUDP, offset);
    }

    public static PeerSocketAddress create(ByteBuf ch, boolean isIPv4) {
        InetAddress address;
        int portTCP = ch.readUnsignedShort();
        int portUDP = ch.readUnsignedShort();
        if (isIPv4) {
            byte[] me = new byte[4];
            ch.readBytes(me);
            address = Utils.inet4FromBytes(me, 0);
        } else {
            byte[] me = new byte[16];
            ch.readBytes(me);
            address = Utils.inet6FromBytes(me, 0);
        }
        return new PeerSocketAddress(address, portTCP, portUDP, ch.readerIndex());
    }

    public static InetSocketAddress createSocketTCP(PeerSocketAddress peerSocketAddress) {
        return new InetSocketAddress(peerSocketAddress.getInetAddress(), peerSocketAddress.getTcpPort());
    }

    public static InetSocketAddress createSocketUDP(PeerSocketAddress peerSocketAddress) {
        return new InetSocketAddress(peerSocketAddress.getInetAddress(), peerSocketAddress.getUdpPort());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PeerSocketAddress)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PeerSocketAddress psa = (PeerSocketAddress)obj;
        return psa.inetAddress.equals(this.inetAddress) && psa.tcpPort == this.tcpPort && psa.udpPort == this.udpPort;
    }

    public int hashCode() {
        return this.inetAddress.hashCode() ^ this.tcpPort ^ this.udpPort;
    }
}

