/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.p2p.EvaluatingSchemeDHT;
import net.tomp2p.p2p.VotingSchemeDHT;
import net.tomp2p.p2p.builder.DHTBuilder;
import net.tomp2p.peers.PeerAddress;

public class FutureSend
extends FutureDHT<FutureSend> {
    private final int min;
    private final EvaluatingSchemeDHT evaluationScheme;
    private Map<PeerAddress, Object> rawObjects;
    private Map<PeerAddress, ByteBuf> rawChannels;
    private boolean minReached;

    public FutureSend(DHTBuilder<?> builder) {
        this(builder, 0, new VotingSchemeDHT());
    }

    public FutureSend(DHTBuilder<?> builder, int min, EvaluatingSchemeDHT evaluationScheme) {
        super(builder);
        this.min = min;
        this.evaluationScheme = evaluationScheme;
        this.self(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectData1(Map<PeerAddress, ByteBuf> rawChannels) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawChannels = rawChannels;
            int size = rawChannels.size();
            this.minReached = size >= this.min;
            this.type = this.minReached ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = this.minReached ? "Minimun number of results reached" : "Expected " + this.min + " result, but got " + size;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectData2(Map<PeerAddress, Object> rawObjects) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawObjects = rawObjects;
            int size = rawObjects.size();
            this.minReached = size >= this.min;
            this.type = this.minReached ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = this.minReached ? "Minimun number of results reached" : "Expected " + this.min + " result, but got " + size;
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, ByteBuf> getRawDirectData1() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawChannels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Object> getRawDirectData2() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawObjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate3(this.rawObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf getChannelBuffer() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate4(this.rawChannels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMinReached() {
        Object object = this.lock;
        synchronized (object) {
            return this.minReached;
        }
    }
}

