/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.peers.PeerAddress;

public class FuturePeerConnection
extends FutureDone<PeerConnection> {
    private final PeerAddress remotePeer;

    public FuturePeerConnection(PeerAddress remotePeer) {
        this.remotePeer = remotePeer;
    }

    public PeerAddress remotePeer() {
        return this.remotePeer;
    }

    public PeerConnection peerConnection() {
        return (PeerConnection)this.getObject();
    }

    public FutureDone<Void> close() {
        final FutureDone<Void> shutdown = new FutureDone<Void>();
        this.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<PeerConnection>>(){

            @Override
            public void operationComplete(FutureDone<PeerConnection> future) throws Exception {
                if (future.isSuccess()) {
                    future.getObject().close().addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureDone<Void>>(){

                        @Override
                        public void operationComplete(FutureDone<Void> future) throws Exception {
                            if (future.isSuccess()) {
                                shutdown.setDone();
                            } else {
                                shutdown.setFailed("could not close (1)", future);
                            }
                        }
                    });
                } else {
                    shutdown.setFailed("could not close (2)", future);
                }
            }
        });
        return shutdown;
    }
}

