/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.natpmp;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.tomp2p.natpmp.Message;
import net.tomp2p.utils.Timings;

class MessageQueue
implements Runnable {
    private InetAddress gatewayIP;
    private Thread thread;
    private LinkedList<Message> queue;
    private final Object queueLock = new Object();
    private final Object messageLock = new Object();
    private boolean shutdown = false;
    private final Object shutdownLock = new Object();

    private MessageQueue(InetAddress gatewayIP) {
        this.gatewayIP = gatewayIP;
        this.thread = new Thread((Runnable)this, "MessageQueue");
        this.thread.setDaemon(false);
        this.queue = new LinkedList();
    }

    static MessageQueue createMessageQueue(InetAddress gatewayIP) {
        MessageQueue messageQueue = new MessageQueue(gatewayIP);
        messageQueue.thread.start();
        while (messageQueue.thread.getState() != Thread.State.TIMED_WAITING) {
            Thread.yield();
        }
        return messageQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueMessage(Message message) {
        Object object = this.queueLock;
        synchronized (object) {
            this.queue.add(message);
            this.queueLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearQueue() {
        Object object = this.queueLock;
        synchronized (object) {
            this.queue.clear();
            this.queueLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdown = true;
        }
        this.clearQueue();
        while (this.thread.isAlive()) {
            try {
                Timings.sleep((int)25);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(MessageQueue.class.getName()).log(Level.SEVERE, null, ex);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isShutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilQueueEmpty() {
        int size = 0;
        Object object = this.messageLock;
        synchronized (object) {
            size = this.queue.size();
            while (size > 0) {
                try {
                    this.messageLock.wait(250L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(MessageQueue.class.getName()).log(Level.SEVERE, null, ex);
                }
                size = this.queue.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                Message message = null;
                Object object = this.messageLock;
                synchronized (object) {
                    Object object2 = this.queueLock;
                    synchronized (object2) {
                        while (message == null && !this.shutdown) {
                            if (this.queue.size() > 0) {
                                message = this.queue.removeFirst();
                                continue;
                            }
                            this.queueLock.wait(250L);
                            this.messageLock.wait(1L);
                        }
                    }
                    if (this.shutdown) {
                        continue;
                    }
                    message.sendMessage(this.gatewayIP);
                    message.notifyListener();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

