/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageHeaderCodec {
    private static final Logger LOG = LoggerFactory.getLogger(MessageHeaderCodec.class);
    public static final int HEADER_SIZE = 58;

    private MessageHeaderCodec() {
    }

    public static ByteBuf encodeHeader(ByteBuf buffer, Message message) {
        int versionAndType = message.getVersion() << 4 | message.getType().ordinal() & 0xF;
        buffer.writeInt(versionAndType);
        buffer.writeInt(message.getMessageId());
        buffer.writeByte((int)message.getCommand());
        buffer.writeBytes(message.getSender().getPeerId().toByteArray());
        buffer.writeShort((int)((short)message.getSender().tcpPort()));
        buffer.writeShort((int)((short)message.getSender().udpPort()));
        buffer.writeBytes(message.getRecipient().getPeerId().toByteArray());
        buffer.writeInt(MessageHeaderCodec.encodeContentTypes(message.getContentTypes()));
        buffer.writeByte(message.getSender().getOptions() << 4 | message.getOptions());
        return buffer;
    }

    public static Message decodeHeader(ByteBuf buffer, InetSocketAddress recipient, InetSocketAddress sender) {
        LOG.debug("Decode message, recipient={}, sender={}", (Object)recipient, (Object)sender);
        Message message = new Message();
        int versionAndType = buffer.readInt();
        message.setVersion(versionAndType >>> 4);
        message.setType(Message.Type.values()[versionAndType & 0xF]);
        message.setMessageId(buffer.readInt());
        short command = buffer.readUnsignedByte();
        message.setCommand((byte)command);
        Number160 senderID = MessageHeaderCodec.readID(buffer);
        int portTCP = buffer.readUnsignedShort();
        int portUDP = buffer.readUnsignedShort();
        Number160 recipientID = MessageHeaderCodec.readID(buffer);
        message.setRecipient(new PeerAddress(recipientID, recipient));
        int contentTypes = buffer.readInt();
        message.hasContent(contentTypes != 0);
        message.setContentTypes(MessageHeaderCodec.decodeContentTypes(contentTypes, message));
        short options = buffer.readUnsignedByte();
        message.setOptions(options & 0xF);
        int senderOptions = options >>> 4;
        PeerAddress peerAddress = new PeerAddress(senderID, sender.getAddress(), portTCP, portUDP, senderOptions);
        message.setSender(peerAddress);
        message.senderSocket(sender);
        message.recipientSocket(recipient);
        return message;
    }

    private static Number160 readID(ByteBuf buffer) {
        byte[] me = new byte[20];
        buffer.readBytes(me);
        return new Number160(me);
    }

    public static int encodeContentTypes(Message.Content[] contentTypes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            if (contentTypes[i * 2] != null) {
                result |= contentTypes[i * 2].ordinal() << i * 8;
            }
            if (contentTypes[i * 2 + 1] == null) continue;
            result |= contentTypes[i * 2 + 1].ordinal() << 4 << i * 8;
        }
        return result;
    }

    public static Message.Content[] decodeContentTypes(int contentTypes, Message message) {
        Message.Content[] result = new Message.Content[8];
        for (int i = 0; i < 8; ++i) {
            Message.Content type;
            result[i] = type = Message.Content.values()[contentTypes & 0xF];
            if (type == Message.Content.PUBLIC_KEY_SIGNATURE) {
                message.setHintSign();
            }
            contentTypes >>>= 4;
        }
        return result;
    }
}

