/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.synchronization;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.DataMap;
import net.tomp2p.message.KeyCollection;
import net.tomp2p.message.KeyMap640;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.DataBuffer;
import net.tomp2p.storage.StorageLayer;
import net.tomp2p.synchronization.Checksum;
import net.tomp2p.synchronization.Instruction;
import net.tomp2p.synchronization.RSync;
import net.tomp2p.synchronization.SyncBuilder;
import net.tomp2p.synchronization.SyncUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SyncRPC.class);
    public static final byte INFO_COMMAND = RPC.Commands.SYNC_INFO.getNr();
    public static final byte SYNC_COMMAND = RPC.Commands.SYNC.getNr();
    final int blockSize;

    public SyncRPC(PeerBean peerBean, ConnectionBean connectionBean, int blockSize) {
        super(peerBean, connectionBean);
        this.register(new int[]{INFO_COMMAND, SYNC_COMMAND});
        this.blockSize = blockSize;
    }

    public FutureResponse infoMessage(PeerAddress remotePeer, SyncBuilder synchronizationBuilder, ChannelCreator channelCreator) {
        Message message = this.createMessage(remotePeer, INFO_COMMAND, synchronizationBuilder.isSyncFromOldVersion() ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1);
        if (synchronizationBuilder.isSign()) {
            message.setPublicKeyAndSign(synchronizationBuilder.keyPair());
        }
        KeyMap640 keyMap = new KeyMap640(synchronizationBuilder.dataMapHash());
        message.setKeyMap640(keyMap);
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler requestHandler = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)synchronizationBuilder);
        LOG.debug("Info sent {}", (Object)message);
        return requestHandler.sendTCP(channelCreator);
    }

    public FutureResponse syncMessage(PeerAddress remotePeer, SyncBuilder synchronizationBuilder, ChannelCreator channelCreator) throws IOException {
        Message message = this.createMessage(remotePeer, SYNC_COMMAND, Message.Type.REQUEST_1);
        if (synchronizationBuilder.isSign()) {
            message.setPublicKeyAndSign(synchronizationBuilder.keyPair());
        }
        DataMap dataMap = synchronizationBuilder.dataMap();
        message.setDataMap(dataMap);
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler requestHandler = new RequestHandler(futureResponse, this.peerBean(), this.connectionBean(), (ConnectionConfiguration)synchronizationBuilder);
        LOG.debug("Sync sent {}", (Object)message);
        return requestHandler.sendTCP(channelCreator);
    }

    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws Exception {
        if (message.getCommand() != INFO_COMMAND && message.getCommand() != SYNC_COMMAND) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        if (message.getCommand() == INFO_COMMAND) {
            this.handleInfo(message, responseMessage, responder);
        } else if (message.getCommand() == SYNC_COMMAND) {
            this.handleSync(message, responseMessage, responder);
        } else {
            throw new IllegalArgumentException("Message content is wrong");
        }
    }

    private void handleInfo(Message message, Message responseMessage, Responder responder) {
        LOG.debug("Info received from {} -> I'm {}", (Object)message.getSender().getPeerId(), (Object)message.getRecipient().getPeerId());
        boolean isSyncFromOldVersion = message.getType() == Message.Type.REQUEST_2;
        KeyMap640 keysMap = message.getKeyMap640(0);
        HashMap retVal = new HashMap();
        for (Map.Entry entry : keysMap.keysMap().entrySet()) {
            Data data = this.peerBean().storage().get((Number640)entry.getKey());
            if (data != null) {
                if (((Number160)entry.getValue()).equals((Object)data.hash())) {
                    retVal.put(entry.getKey(), new Data().setFlag1());
                    LOG.debug("no sync required");
                    continue;
                }
                List<Checksum> checksums = RSync.checksums(data.toBytes(), this.blockSize);
                AlternativeCompositeByteBuf abuf = AlternativeCompositeByteBuf.compBuffer();
                DataBuffer dataBuffer = SyncUtils.encodeChecksum(checksums, ((Number640)entry.getKey()).getVersionKey(), data.hash(), (ByteBuf)abuf);
                retVal.put(entry.getKey(), new Data(dataBuffer));
                LOG.debug("sync required hash = {}", (Object)data.hash());
                continue;
            }
            if (isSyncFromOldVersion) {
                Map.Entry latest = this.peerBean().storage().get(((Number640)entry.getKey()).minVersionKey(), ((Number640)entry.getKey()).maxVersionKey(), 1, false).lastEntry();
                List<Checksum> checksums = RSync.checksums(((Data)latest.getValue()).toBytes(), this.blockSize);
                AlternativeCompositeByteBuf abuf = AlternativeCompositeByteBuf.compBuffer();
                DataBuffer dataBuffer = SyncUtils.encodeChecksum(checksums, ((Number640)latest.getKey()).getVersionKey(), ((Data)latest.getValue()).hash(), (ByteBuf)abuf);
                retVal.put(entry.getKey(), new Data(dataBuffer));
                LOG.debug("sync required for version");
                continue;
            }
            retVal.put(entry.getKey(), new Data().setFlag2());
            LOG.debug("copy required, not found on this peer {}", entry.getKey());
        }
        responseMessage.setDataMap(new DataMap(retVal));
        responder.response(responseMessage);
    }

    private void handleSync(Message message, Message responseMessage, Responder responder) {
        LOG.debug("Sync received: got from {} -> I'm {}", (Object)message.getSender().getPeerId(), (Object)message.getRecipient().getPeerId());
        DataMap dataMap = message.getDataMap(0);
        PublicKey publicKey = message.getPublicKey(0);
        ArrayList retVal = new ArrayList(dataMap.size());
        for (Map.Entry entry : dataMap.dataMap().entrySet()) {
            if (((Data)entry.getValue()).isFlag2()) {
                LOG.debug("remove entry {}", entry.getKey());
                this.peerBean().storage().remove((Number640)entry.getKey(), publicKey, false);
                continue;
            }
            if (((Data)entry.getValue()).length() <= 0) continue;
            if (((Data)entry.getValue()).isFlag1()) {
                LOG.debug("handle diff {}", entry.getKey());
                ByteBuf buf = ((Data)entry.getValue()).buffer();
                Number160 versionKey = SyncUtils.decodeHeader(buf);
                Number160 hash = SyncUtils.decodeHeader(buf);
                List<Instruction> instructions = SyncUtils.decodeInstructions(buf);
                Data dataOld = this.peerBean().storage().get(new Number640(((Number640)entry.getKey()).locationDomainAndContentKey(), versionKey));
                if (dataOld == null || !dataOld.hash().equals((Object)hash)) continue;
                DataBuffer reconstructedValue = RSync.reconstruct(dataOld.toBytes(), instructions, this.blockSize);
                Enum status = this.peerBean().storage().put((Number640)entry.getKey(), new Data(reconstructedValue), publicKey, false, false);
                if (status == StorageLayer.PutStatus.OK) {
                    retVal.add(entry.getKey());
                }
            } else {
                LOG.debug("handle copy {}", entry.getKey());
                Enum status = this.peerBean().storage().put((Number640)entry.getKey(), (Data)entry.getValue(), message.getPublicKey(0), false, false);
                if (status == StorageLayer.PutStatus.OK) {
                    retVal.add(entry.getKey());
                }
            }
            if (this.peerBean().replicationStorage() == null) continue;
            this.peerBean().replicationStorage().updateAndNotifyResponsibilities(((Number640)entry.getKey()).getLocationKey());
        }
        responseMessage.setKeyCollection(new KeyCollection(retVal));
        responder.response(responseMessage);
    }
}

