/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.rpc.BloomfilterFactory;
import net.tomp2p.rpc.SimpleBloomFilter;

public class DigestInfo {
    private volatile Number160 keyDigest = null;
    private volatile Number160 contentDigest = null;
    private volatile int size = -1;
    private final NavigableMap<Number640, Number160> mapDigests = new TreeMap<Number640, Number160>();

    public DigestInfo() {
    }

    public DigestInfo(int size) {
        this.size = size;
    }

    public DigestInfo(Number160 keyDigest, Number160 contentDigest, int size) {
        this.keyDigest = keyDigest;
        this.contentDigest = contentDigest;
        this.size = size;
    }

    public Number160 getKeyDigest() {
        if (this.keyDigest == null) {
            this.process();
        }
        return this.keyDigest;
    }

    public Number160 getContentDigest() {
        if (this.contentDigest == null) {
            this.process();
        }
        return this.contentDigest;
    }

    private void process() {
        Number160 hashKey = Number160.ZERO;
        Number160 hashContent = Number160.ZERO;
        for (Map.Entry entry : this.mapDigests.entrySet()) {
            hashKey = hashKey.xor(((Number640)entry.getKey()).getLocationKey());
            hashKey = hashKey.xor(((Number640)entry.getKey()).getDomainKey());
            hashKey = hashKey.xor(((Number640)entry.getKey()).getContentKey());
            hashKey = hashKey.xor(((Number640)entry.getKey()).getVersionKey());
            hashContent = hashContent.xor((Number160)entry.getValue());
        }
        this.keyDigest = hashKey;
        this.contentDigest = hashContent;
    }

    public SimpleBloomFilter<Number160> getLocationKeyBloomFilter(BloomfilterFactory factory) {
        SimpleBloomFilter<Number160> sbf = factory.createLoctationKeyBloomFilter();
        for (Map.Entry entry : this.mapDigests.entrySet()) {
            sbf.add(((Number640)entry.getKey()).getLocationKey());
        }
        return sbf;
    }

    public SimpleBloomFilter<Number160> getDomainKeyBloomFilter(BloomfilterFactory factory) {
        SimpleBloomFilter<Number160> sbf = factory.createDomainKeyBloomFilter();
        for (Map.Entry entry : this.mapDigests.entrySet()) {
            sbf.add(((Number640)entry.getKey()).getDomainKey());
        }
        return sbf;
    }

    public SimpleBloomFilter<Number160> getContentKeyBloomFilter(BloomfilterFactory factory) {
        SimpleBloomFilter<Number160> sbf = factory.createContentKeyBloomFilter();
        for (Map.Entry entry : this.mapDigests.entrySet()) {
            sbf.add(((Number640)entry.getKey()).getContentKey());
        }
        return sbf;
    }

    public SimpleBloomFilter<Number160> getVersionKeyBloomFilter(BloomfilterFactory factory) {
        SimpleBloomFilter<Number160> sbf = factory.createContentBloomFilter();
        for (Map.Entry entry : this.mapDigests.entrySet()) {
            sbf.add(((Number640)entry.getKey()).getVersionKey());
        }
        return sbf;
    }

    public void put(Number640 key, Number160 basedOn) {
        this.mapDigests.put(key, basedOn);
    }

    public NavigableMap<Number640, Number160> getDigests() {
        return this.mapDigests;
    }

    public int getSize() {
        if (this.size == -1) {
            this.size = this.mapDigests.size();
        }
        return this.size;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DigestInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DigestInfo other = (DigestInfo)obj;
        return this.getKeyDigest().equals(other.getKeyDigest()) && this.getSize() == other.getSize() && this.getContentDigest().equals(other.getContentDigest());
    }

    public int hashCode() {
        return this.getKeyDigest().hashCode() ^ this.getSize() ^ this.getContentDigest().hashCode();
    }
}

