/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.net.InetAddress;
import java.util.Collection;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.connection.DiscoverNetworks;
import net.tomp2p.connection.Ports;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerReachable;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DiscoverBuilder.class);
    private static final FutureDiscover FUTURE_DISCOVER_SHUTDOWN = (FutureDiscover)new FutureDiscover().setFailed("Peer is shutting down");
    private final Peer peer;
    private InetAddress inetAddress;
    private int portUDP = 7700;
    private int portTCP = 7700;
    private PeerAddress peerAddress;
    private int discoverTimeoutSec = 5;
    private ConnectionConfiguration configuration;
    private FutureDiscover futureDiscover;

    public DiscoverBuilder(Peer peer) {
        this.peer = peer;
    }

    public InetAddress inetAddress() {
        return this.inetAddress;
    }

    public DiscoverBuilder inetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        return this;
    }

    public DiscoverBuilder inetSocketAddress(InetAddress inetAddress, int port) {
        this.inetAddress = inetAddress;
        this.portTCP = port;
        this.portUDP = port;
        return this;
    }

    public DiscoverBuilder inetSocketAddress(InetAddress inetAddress, int portTCP, int portUDP) {
        this.inetAddress = inetAddress;
        this.portTCP = portTCP;
        this.portUDP = portUDP;
        return this;
    }

    public int portUDP() {
        return this.portUDP;
    }

    public DiscoverBuilder portUDP(int portUDP) {
        this.portUDP = portUDP;
        return this;
    }

    public int portTCP() {
        return this.portTCP;
    }

    public DiscoverBuilder portTCP(int portTCP) {
        this.portTCP = portTCP;
        return this;
    }

    public DiscoverBuilder ports(int port) {
        this.portTCP = port;
        this.portUDP = port;
        return this;
    }

    public PeerAddress peerAddress() {
        return this.peerAddress;
    }

    public DiscoverBuilder peerAddress(PeerAddress peerAddress) {
        this.peerAddress = peerAddress;
        return this;
    }

    public int discoverTimeoutSec() {
        return this.discoverTimeoutSec;
    }

    public DiscoverBuilder discoverTimeoutSec(int discoverTimeoutSec) {
        this.discoverTimeoutSec = discoverTimeoutSec;
        return this;
    }

    public FutureDiscover futureDiscover() {
        return this.futureDiscover;
    }

    public DiscoverBuilder futureDiscover(FutureDiscover futureDiscover) {
        this.futureDiscover = futureDiscover;
        return this;
    }

    public FutureDiscover start() {
        if (this.peer.isShutdown()) {
            return FUTURE_DISCOVER_SHUTDOWN;
        }
        if (this.peerAddress == null && this.inetAddress != null) {
            this.peerAddress = new PeerAddress(Number160.ZERO, this.inetAddress, this.portTCP, this.portUDP);
        }
        if (this.peerAddress == null) {
            throw new IllegalArgumentException("need peeraddress or inetaddress");
        }
        if (this.configuration == null) {
            this.configuration = new DefaultConnectionConfiguration();
        }
        if (this.futureDiscover == null) {
            this.futureDiscover = new FutureDiscover();
        }
        return this.discover(this.peerAddress, this.configuration, this.futureDiscover);
    }

    private FutureDiscover discover(final PeerAddress peerAddress, final ConnectionConfiguration configuration, final FutureDiscover futureDiscover) {
        FutureChannelCreator fcc = this.peer.getConnectionBean().reservation().create(1, 2);
        fcc.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    DiscoverBuilder.this.discover(futureDiscover, peerAddress, future.getChannelCreator(), configuration);
                } else {
                    futureDiscover.setFailed(future);
                }
            }
        });
        return futureDiscover;
    }

    private void discover(final FutureDiscover futureDiscover, final PeerAddress peerAddress, final ChannelCreator cc, final ConnectionConfiguration configuration) {
        this.peer.pingRPC().addPeerReachableListener(new PeerReachable(){
            private boolean changedUDP = false;
            private boolean changedTCP = false;

            @Override
            public void peerWellConnected(PeerAddress peerAddress, PeerAddress reporter, boolean tcp) {
                if (tcp) {
                    this.changedTCP = true;
                    futureDiscover.setDiscoveredTCP();
                } else {
                    this.changedUDP = true;
                    futureDiscover.setDiscoveredUDP();
                }
                if (this.changedTCP && this.changedUDP) {
                    futureDiscover.done(peerAddress, reporter);
                }
            }
        });
        final FutureResponse futureResponseTCP = this.peer.pingRPC().pingTCPDiscover(peerAddress, cc, configuration);
        futureResponseTCP.addListener((BaseFutureListener<BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                PeerAddress serverAddress = DiscoverBuilder.this.peer.getPeerBean().serverPeerAddress();
                if (futureResponseTCP.isSuccess()) {
                    Collection<PeerAddress> tmp = futureResponseTCP.getResponse().getNeighborsSet(0).neighbors();
                    if (tmp.size() == 1) {
                        PeerAddress seenAs = tmp.iterator().next();
                        logger.info("I'm seen as " + seenAs + " by peer " + peerAddress + " I see myself as " + DiscoverBuilder.this.peer.getPeerAddress().getInetAddress());
                        if (!DiscoverBuilder.this.peer.getPeerAddress().getInetAddress().equals(seenAs.getInetAddress())) {
                            Bindings bindings2 = new Bindings().addAddress(seenAs.getInetAddress());
                            String status = DiscoverNetworks.discoverInterfaces(bindings2);
                            logger.info("2nd interface discovery: " + status);
                            if (bindings2.foundAddresses().size() > 0 && bindings2.foundAddresses().contains(seenAs.getInetAddress())) {
                                serverAddress = serverAddress.changeAddress(seenAs.getInetAddress());
                                DiscoverBuilder.this.peer.getPeerBean().serverPeerAddress(serverAddress);
                            } else {
                                Ports ports = DiscoverBuilder.this.peer.getConnectionBean().channelServer().ports();
                                if (ports.isSetExternalPortsManually()) {
                                    serverAddress = serverAddress.changePorts(ports.externalTCPPort(), ports.externalUDPPort());
                                    serverAddress = serverAddress.changeAddress(seenAs.getInetAddress());
                                    DiscoverBuilder.this.peer.getPeerBean().serverPeerAddress(serverAddress);
                                } else {
                                    futureDiscover.setExternalHost("We are most likely behind NAT, try to UPNP, NATPMP or relay " + peerAddress, futureResponseTCP.getResponse().getRecipient().getInetAddress(), seenAs.getInetAddress());
                                    return;
                                }
                            }
                        }
                        FutureResponse fr1 = DiscoverBuilder.this.peer.pingRPC().pingTCPProbe(peerAddress, cc, configuration);
                        FutureResponse fr2 = DiscoverBuilder.this.peer.pingRPC().pingUDPProbe(peerAddress, cc, configuration);
                        Utils.addReleaseListener(cc, fr1, fr2);
                        futureDiscover.setTimeout(DiscoverBuilder.this.peer.getConnectionBean().timer(), DiscoverBuilder.this.discoverTimeoutSec);
                        return;
                    }
                    cc.shutdown();
                    futureDiscover.setFailed("Peer " + peerAddress + " did not report our IP address");
                    return;
                }
                cc.shutdown();
                futureDiscover.setFailed("FutureDiscover: We need at least the TCP connection", futureResponseTCP);
            }
        });
    }
}

