/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import net.tomp2p.p2p.ResponsibilityListener;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerStatatistic;
import net.tomp2p.storage.ReplicationStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Replication
implements PeerMapChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(Replication.class);
    private final List<ResponsibilityListener> listeners = new ArrayList<ResponsibilityListener>();
    private final PeerMap peerMap;
    private final PeerAddress selfAddress;
    private final ReplicationStorage replicationStorage;
    private int replicationFactor;

    public Replication(ReplicationStorage replicationStorage, PeerAddress selfAddress, PeerMap peerMap, int replicationFactor) {
        this.replicationStorage = replicationStorage;
        this.selfAddress = selfAddress;
        this.peerMap = peerMap;
        this.replicationFactor = replicationFactor;
        peerMap.addPeerMapChangeListener(this);
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public boolean isReplicationEnabled() {
        return this.listeners.size() > 0;
    }

    public void addResponsibilityListener(ResponsibilityListener responsibilityListener) {
        this.listeners.add(responsibilityListener);
    }

    public void removeResponsibilityListener(ResponsibilityListener responsibilityListener) {
        this.listeners.remove(responsibilityListener);
    }

    private void notifyMeResponsible(Number160 locationKey) {
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            responsibilityListener.meResponsible(locationKey);
        }
    }

    private void notifyMeResponsible(Number160 locationKey, PeerAddress newPeer) {
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            responsibilityListener.meResponsible(locationKey, newPeer);
        }
    }

    private void notifyOtherResponsible(Number160 locationKey, PeerAddress other, boolean delayed) {
        for (ResponsibilityListener responsibilityListener : this.listeners) {
            responsibilityListener.otherResponsible(locationKey, other, delayed);
        }
    }

    public void updateAndNotifyResponsibilities(Number160 locationKey) {
        if (!this.isReplicationEnabled()) {
            return;
        }
        PeerAddress closest = this.closest(locationKey);
        if (closest.getPeerId().equals(this.selfAddress.getPeerId())) {
            if (this.replicationStorage.updateResponsibilities(locationKey, closest.getPeerId())) {
                this.notifyMeResponsible(locationKey);
            }
        } else if (this.replicationStorage.updateResponsibilities(locationKey, closest.getPeerId())) {
            this.notifyOtherResponsible(locationKey, closest, false);
        }
    }

    @Override
    public void peerInserted(PeerAddress peerAddress, boolean verified) {
        if (!this.isReplicationEnabled() || !verified) {
            return;
        }
        LOG.debug("The peer {} was inserted in my map. I'm {}", (Object)peerAddress, (Object)this.selfAddress);
        Collection<Number160> myResponsibleLocations = this.replicationStorage.findContentForResponsiblePeerID(this.selfAddress.getPeerId());
        LOG.debug("I ({}) am currently responsibel for {}", (Object)this.selfAddress, myResponsibleLocations);
        for (Number160 myResponsibleLocation : myResponsibleLocations) {
            PeerAddress closest = this.closest(myResponsibleLocation);
            if (!closest.getPeerId().equals(this.selfAddress.getPeerId())) {
                if (!this.replicationStorage.updateResponsibilities(myResponsibleLocation, closest.getPeerId())) continue;
                this.notifyOtherResponsible(myResponsibleLocation, closest, false);
                continue;
            }
            if (!this.isInReplicationRange(myResponsibleLocation, peerAddress, this.replicationFactor)) continue;
            if (this.replicationStorage.updateResponsibilities(myResponsibleLocation, this.selfAddress.getPeerId())) {
                this.notifyMeResponsible(myResponsibleLocation);
                continue;
            }
            this.notifyMeResponsible(myResponsibleLocation, peerAddress);
        }
    }

    @Override
    public void peerRemoved(PeerAddress peerAddress, PeerStatatistic peerStatatistic) {
        if (!this.isReplicationEnabled()) {
            return;
        }
        Collection<Number160> otherResponsibleLocations = this.replicationStorage.findContentForResponsiblePeerID(peerAddress.getPeerId());
        Collection<Number160> myResponsibleLocations = this.replicationStorage.findContentForResponsiblePeerID(this.selfAddress.getPeerId());
        for (Number160 otherResponsibleLocation : otherResponsibleLocations) {
            PeerAddress closest = this.closest(otherResponsibleLocation);
            if (closest.getPeerId().equals(this.selfAddress.getPeerId())) {
                if (!this.replicationStorage.updateResponsibilities(otherResponsibleLocation, closest.getPeerId())) continue;
                this.notifyMeResponsible(otherResponsibleLocation);
                myResponsibleLocations.remove(otherResponsibleLocation);
                continue;
            }
            if (!this.replicationStorage.updateResponsibilities(otherResponsibleLocation, closest.getPeerId())) continue;
            LOG.debug("We should check if the closer peer has the content");
            this.notifyOtherResponsible(otherResponsibleLocation, closest, true);
        }
        for (Number160 myResponsibleLocation : myResponsibleLocations) {
            if (!this.isInReplicationRange(myResponsibleLocation, peerAddress, this.replicationFactor)) continue;
            this.notifyMeResponsible(myResponsibleLocation);
        }
    }

    @Override
    public void peerUpdated(PeerAddress peerAddress, PeerStatatistic peerStatatistic) {
    }

    private PeerAddress closest(Number160 locationKey) {
        NavigableSet<PeerAddress> tmp = this.peerMap.closePeers(locationKey, 1);
        tmp.add(this.selfAddress);
        return (PeerAddress)tmp.iterator().next();
    }

    private boolean isInReplicationRange(Number160 locationKey, PeerAddress peerAddress, int replicationFactor) {
        NavigableSet<PeerAddress> tmp = this.peerMap.closePeers(locationKey, replicationFactor);
        return tmp.headSet(peerAddress).size() < replicationFactor;
    }
}

