/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import net.tomp2p.examples.ExampleUtils;
import net.tomp2p.futures.FutureGet;
import net.tomp2p.futures.FuturePut;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerMaker;
import net.tomp2p.p2p.builder.GetBuilder;
import net.tomp2p.p2p.builder.PutBuilder;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.StorageLayer;
import net.tomp2p.utils.Utils;

public class ExampleDomainProtection {
    final Random rnd = new Random(42L);

    public static void main(String[] args) throws NoSuchAlgorithmException, IOException, ClassNotFoundException {
        ExampleDomainProtection.exampleAllMaster();
        ExampleDomainProtection.exampleNoneMaster();
    }

    public static void exampleAllMaster() throws NoSuchAlgorithmException, IOException, ClassNotFoundException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("DSA");
        KeyPair pair1 = gen.generateKeyPair();
        KeyPair pair2 = gen.generateKeyPair();
        KeyPair pair3 = gen.generateKeyPair();
        Number160 peer2Owner = Utils.makeSHAHash((byte[])pair2.getPublic().getEncoded());
        Peer peer1 = new PeerMaker(pair1).ports(4001).makeAndListen();
        Peer peer2 = new PeerMaker(pair2).ports(4002).makeAndListen();
        Peer peer3 = new PeerMaker(pair3).ports(4003).makeAndListen();
        Peer[] peers = new Peer[]{peer1, peer2, peer3};
        ExampleUtils.bootstrap(peers);
        ExampleDomainProtection.setProtection(peers, StorageLayer.ProtectionEnable.ALL, StorageLayer.ProtectionMode.MASTER_PUBLIC_KEY);
        FuturePut futurePut = ((PutBuilder)peer1.put(Number160.ONE).setData(new Data((Object)"test")).setDomainKey(peer2Owner).setProtectDomain()).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> because no one claimed this domain");
        futurePut = ((PutBuilder)peer3.put(Number160.ONE).setData(new Data((Object)"hello")).setDomainKey(peer2Owner).setProtectDomain()).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> becaues peer1 already claimed this domain");
        futurePut = ((PutBuilder)peer2.put(Number160.ONE).setData(new Data((Object)"MINE!")).setDomainKey(peer2Owner).setProtectDomain()).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> becaues peer2 is the owner");
        FutureGet futureGet = ((GetBuilder)peer1.get(Number160.ONE).setDomainKey(peer2Owner)).start();
        futureGet.awaitUninterruptibly();
        System.out.println("we got " + futureGet.getData().object());
        ExampleDomainProtection.shutdown(peers);
    }

    public static void exampleNoneMaster() throws NoSuchAlgorithmException, IOException, ClassNotFoundException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("DSA");
        KeyPair pair1 = gen.generateKeyPair();
        KeyPair pair2 = gen.generateKeyPair();
        KeyPair pair3 = gen.generateKeyPair();
        Number160 peer2Owner = Utils.makeSHAHash((byte[])pair2.getPublic().getEncoded());
        Peer peer1 = new PeerMaker(pair1).ports(4001).makeAndListen();
        Peer peer2 = new PeerMaker(pair2).ports(4002).makeAndListen();
        Peer peer3 = new PeerMaker(pair3).ports(4003).makeAndListen();
        Peer[] peers = new Peer[]{peer1, peer2, peer3};
        ExampleUtils.bootstrap(peers);
        ExampleDomainProtection.setProtection(peers, StorageLayer.ProtectionEnable.NONE, StorageLayer.ProtectionMode.MASTER_PUBLIC_KEY);
        FuturePut futurePut = ((PutBuilder)peer1.put(Number160.ONE).setData(new Data((Object)"test")).setProtectDomain()).setDomainKey(peer2Owner).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> because no one can claim domains except the owner, storage ok but no protection");
        futurePut = ((PutBuilder)peer3.put(Number160.ONE).setData(new Data((Object)"hello")).setProtectDomain()).setDomainKey(peer2Owner).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> because no one can claim domains except the owner, storage ok but no protection");
        futurePut = ((PutBuilder)peer2.put(Number160.ONE).setData(new Data((Object)"MINE!")).setProtectDomain()).setDomainKey(peer2Owner).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> becaues peer2 is the owner");
        FutureGet futureGet = ((GetBuilder)peer1.get(Number160.ONE).setDomainKey(peer2Owner)).start();
        futureGet.awaitUninterruptibly();
        System.out.println("we got " + futureGet.getData().object());
        futurePut = peer3.put(Number160.ONE).setDomainKey(peer2Owner).setData(new Data((Object)"hello")).start();
        futurePut.awaitUninterruptibly();
        System.out.println("stored: " + futurePut.isSuccess() + " -> because this domain is claimed by peer2");
        ExampleDomainProtection.shutdown(peers);
    }

    private static void shutdown(Peer[] peers) {
        for (Peer peer : peers) {
            peer.shutdown();
        }
    }

    private static void setProtection(Peer[] peers, StorageLayer.ProtectionEnable protectionEnable, StorageLayer.ProtectionMode protectionMode) {
        for (Peer peer : peers) {
            peer.getPeerBean().storage().setProtection(protectionEnable, protectionMode, protectionEnable, protectionMode);
        }
    }
}

