/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p.builder;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.connection.DefaultConnectionConfiguration;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.p2p.RoutingMechanism;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerFilter;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.rpc.SimpleBloomFilter;

public class RoutingBuilder
extends DefaultConnectionConfiguration {
    private Number160 locationKey;
    private Number160 domainKey;
    private Number160 contentKey;
    private SimpleBloomFilter<Number160> keyBloomFilter;
    private SimpleBloomFilter<Number160> contentBloomFilter;
    private Number640 from;
    private Number640 to;
    private Collection<PeerFilter> peerFilters;
    private int maxDirectHits;
    private int maxNoNewInfo;
    private int maxFailures;
    private int maxSuccess;
    private int parallel;
    private boolean isBootstrap;
    private boolean isForceRoutingOnlyToSelf;
    private boolean isRoutingToOthers;

    public Number160 getLocationKey() {
        return this.locationKey;
    }

    public Number160 getDomainKey() {
        return this.domainKey;
    }

    public int getMaxDirectHits() {
        return this.maxDirectHits;
    }

    public void setMaxDirectHits(int maxDirectHits) {
        this.maxDirectHits = maxDirectHits;
    }

    public int getMaxNoNewInfo() {
        return this.maxNoNewInfo;
    }

    public void setMaxNoNewInfo(int maxNoNewInfo) {
        this.maxNoNewInfo = maxNoNewInfo;
    }

    public int getMaxFailures() {
        return this.maxFailures;
    }

    public void setMaxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
    }

    public int getMaxSuccess() {
        return this.maxSuccess;
    }

    public void setMaxSuccess(int maxSuccess) {
        this.maxSuccess = maxSuccess;
    }

    public int getParallel() {
        return this.parallel;
    }

    public void setParallel(int parallel) {
        this.parallel = parallel;
    }

    public boolean isBootstrap() {
        return this.isBootstrap;
    }

    public void setBootstrap(boolean isBootstrap) {
        this.isBootstrap = isBootstrap;
    }

    public boolean isForceRoutingOnlyToSelf() {
        return this.isForceRoutingOnlyToSelf;
    }

    public void setForceRoutingOnlyToSelf(boolean isForceRoutingOnlyToSelf) {
        this.isForceRoutingOnlyToSelf = isForceRoutingOnlyToSelf;
    }

    public void setLocationKey(Number160 locationKey) {
        this.locationKey = locationKey;
    }

    public void setDomainKey(Number160 domainKey) {
        this.domainKey = domainKey;
    }

    public RoutingBuilder peerFilters(Collection<PeerFilter> peerFilters) {
        this.peerFilters = peerFilters;
        return this;
    }

    public Collection<PeerFilter> peerFilters() {
        return this.peerFilters;
    }

    public NeighborRPC.SearchValues searchValues() {
        if (this.getContentKey() != null) {
            return new NeighborRPC.SearchValues(this.locationKey, this.domainKey, this.getContentKey());
        }
        if (this.from != null && this.to != null) {
            return new NeighborRPC.SearchValues(this.locationKey, this.domainKey, this.from, this.to);
        }
        if (this.getContentBloomFilter() == null && this.getKeyBloomFilter() != null) {
            return new NeighborRPC.SearchValues(this.locationKey, this.domainKey, this.getKeyBloomFilter());
        }
        if (this.getContentBloomFilter() != null && this.getKeyBloomFilter() != null) {
            return new NeighborRPC.SearchValues(this.locationKey, this.domainKey, this.getKeyBloomFilter(), this.getContentBloomFilter());
        }
        return new NeighborRPC.SearchValues(this.locationKey, this.domainKey);
    }

    public RoutingBuilder routingOnlyToSelf(boolean isRoutingOnlyToSelf) {
        this.isRoutingToOthers = !isRoutingOnlyToSelf;
        return this;
    }

    public boolean isRoutingToOthers() {
        return this.isRoutingToOthers;
    }

    public Number160 getContentKey() {
        return this.contentKey;
    }

    public void setContentKey(Number160 contentKey) {
        this.contentKey = contentKey;
    }

    public SimpleBloomFilter<Number160> getContentBloomFilter() {
        return this.contentBloomFilter;
    }

    public void setContentBloomFilter(SimpleBloomFilter<Number160> contentBloomFilter) {
        this.contentBloomFilter = contentBloomFilter;
    }

    public SimpleBloomFilter<Number160> getKeyBloomFilter() {
        return this.keyBloomFilter;
    }

    public void setKeyBloomFilter(SimpleBloomFilter<Number160> keyBloomFilter) {
        this.keyBloomFilter = keyBloomFilter;
    }

    public RoutingMechanism createRoutingMechanism(FutureRouting futureRouting) {
        FutureResponse[] futureResponses = new FutureResponse[this.getParallel()];
        RoutingMechanism routingMechanism = new RoutingMechanism(new AtomicReferenceArray<FutureResponse>(futureResponses), futureRouting, this.peerFilters);
        routingMechanism.setMaxDirectHits(this.getMaxDirectHits());
        routingMechanism.setMaxFailures(this.getMaxFailures());
        routingMechanism.setMaxNoNewInfo(this.getMaxNoNewInfo());
        routingMechanism.setMaxSucess(this.getMaxSuccess());
        return routingMechanism;
    }

    public void setRange(Number640 from, Number640 to) {
        this.from = from;
        this.to = to;
    }

    public Number640 from() {
        return this.from;
    }

    public Number640 to() {
        return this.to;
    }
}

