/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.Responder;
import net.tomp2p.connection.TimeoutFactory;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.DispatchHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class Dispatcher
extends SimpleChannelInboundHandler<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(Dispatcher.class);
    private final int p2pID;
    private final PeerBean peerBean;
    private final int heartBeatMillis;
    private volatile Map<Number160, Map<Integer, DispatchHandler>> ioHandlers = new HashMap<Number160, Map<Integer, DispatchHandler>>();

    public Dispatcher(int p2pID, PeerBean peerBean, int heartBeatMillis) {
        this.p2pID = p2pID;
        this.peerBean = peerBean;
        this.heartBeatMillis = heartBeatMillis;
    }

    public void registerIoHandler(Number160 peerId, DispatchHandler ioHandler, int ... names) {
        HashMap<Number160, Map<Integer, DispatchHandler>> copy = new HashMap<Number160, Map<Integer, DispatchHandler>>(this.ioHandlers);
        HashMap<Integer, DispatchHandler> types = (HashMap<Integer, DispatchHandler>)copy.get(peerId);
        if (types == null) {
            types = new HashMap<Integer, DispatchHandler>();
            copy.put(peerId, types);
        }
        int[] arr$ = names;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer name = arr$[i$];
            types.put(name, ioHandler);
        }
        this.ioHandlers = Collections.unmodifiableMap(copy);
    }

    public void removeIoHandler(Number160 peerId) {
        HashMap<Number160, Map<Integer, DispatchHandler>> copy = new HashMap<Number160, Map<Integer, DispatchHandler>>(this.ioHandlers);
        copy.remove(peerId);
        this.ioHandlers = Collections.unmodifiableMap(copy);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Message message) throws Exception {
        LOG.debug("received request {}", (Object)message);
        if (message.getVersion() != this.p2pID) {
            LOG.error("Wrong version. We are looking for {} but we got {}, received: {}", new Object[]{this.p2pID, message.getVersion(), message});
            ctx.close();
            for (PeerStatusListener peerStatusListener : this.peerBean.peerStatusListeners()) {
                peerStatusListener.peerFailed(message.getSender(), PeerStatusListener.FailReason.Exception);
            }
            return;
        }
        if (!message.isRequest()) {
            LOG.debug("handing message to the next handler {}", (Object)message);
            ctx.fireChannelRead((Object)message);
            return;
        }
        DirectResponder responder = new DirectResponder(ctx, message);
        DispatchHandler myHandler = this.getAssociatedHandler(message);
        if (myHandler != null) {
            boolean isUdp = ctx.channel() instanceof DatagramChannel;
            boolean isRelay = message.getSender().isRelayed();
            if (isRelay) {
                PeerAddress sender = message.getSender().changePeerSocketAddresses(message.getPeerSocketAddresses());
                message.setSender(sender);
            }
            LOG.debug("about to respond to {}", (Object)message);
            PeerConnection peerConnection = new PeerConnection(message.getSender(), (ChannelFuture)new DefaultChannelPromise(ctx.channel()).setSuccess(), this.heartBeatMillis);
            myHandler.forwardMessage(message, isUdp ? null : peerConnection, responder);
        } else {
            LOG.debug("No handler found for {}. Probably we have shutdown this peer.", (Object)message);
            Message responseMessage = DispatchHandler.createResponseMessage(message, Message.Type.UNKNOWN_ID, this.peerBean.serverPeerAddress());
            this.response(ctx, responseMessage);
        }
    }

    private void response(ChannelHandlerContext ctx, Message response) {
        if (ctx.channel() instanceof DatagramChannel) {
            if (!ctx.channel().isOpen()) {
                LOG.debug("channel UDP is not open, do not reply {}", (Object)response);
                return;
            }
            LOG.debug("reply UDP message {}", (Object)response);
        } else {
            if (!ctx.channel().isActive()) {
                LOG.debug("channel TCP is not open, do not reply {}", (Object)response);
                return;
            }
            LOG.debug("reply TCP message {} to {}", (Object)response, (Object)ctx.channel().remoteAddress());
        }
        ctx.channel().writeAndFlush((Object)response);
    }

    public DispatchHandler getAssociatedHandler(Message message) {
        if (message == null || !message.isRequest()) {
            return null;
        }
        PeerAddress recipient = message.getRecipient();
        if (recipient.getPeerId().isZero() && message.getCommand() == 0) {
            return this.searchHandler(this.peerBean.serverPeerAddress().getPeerId(), 0);
        }
        return this.searchHandler(recipient.getPeerId(), Integer.valueOf(message.getCommand()));
    }

    public DispatchHandler searchHandler(Number160 recipientID, Integer command) {
        Map<Integer, DispatchHandler> types = this.ioHandlers.get(recipientID);
        if (types != null && types.containsKey(command)) {
            return types.get(command);
        }
        LOG.debug("Handler not found for type {} we are looking for the server with ID {}", (Object)command, (Object)recipientID);
        return null;
    }

    public Map<Number160, DispatchHandler> searchHandler(Integer command) {
        HashMap<Number160, DispatchHandler> result = new HashMap<Number160, DispatchHandler>();
        for (Map.Entry<Number160, Map<Integer, DispatchHandler>> entry : this.ioHandlers.entrySet()) {
            for (Map.Entry<Integer, DispatchHandler> entry2 : entry.getValue().entrySet()) {
                DispatchHandler handlerh = entry.getValue().get(command);
                if (handlerh == null || !entry2.getKey().equals(command)) continue;
                result.put(entry.getKey(), handlerh);
            }
        }
        return result;
    }

    public class DirectResponder
    implements Responder {
        final ChannelHandlerContext ctx;
        final Message requestMessage;

        DirectResponder(ChannelHandlerContext ctx, Message requestMessage) {
            this.ctx = ctx;
            this.requestMessage = requestMessage;
        }

        @Override
        public void response(Message responseMessage) {
            if (responseMessage.getSender().isRelayed()) {
                responseMessage.setPeerSocketAddresses(responseMessage.getSender().getPeerSocketAddresses());
            }
            Dispatcher.this.response(this.ctx, responseMessage);
        }

        @Override
        public void failed(Message.Type type, String reason) {
            Message responseMessage = DispatchHandler.createResponseMessage(this.requestMessage, type, Dispatcher.this.peerBean.serverPeerAddress());
            Dispatcher.this.response(this.ctx, responseMessage);
        }

        @Override
        public void responseFireAndForget() {
            LOG.debug("The reply handler was a fire-and-forget handler, we don't send any message back! {}", (Object)this.requestMessage);
            if (!(this.ctx.channel() instanceof DatagramChannel)) {
                LOG.warn("There is no TCP fire and forget, use UDP in that case {}", (Object)this.requestMessage);
                throw new RuntimeException("There is no TCP fire and forget, use UDP in that case.");
            }
            TimeoutFactory.removeTimeout(this.ctx);
        }
    }
}

