/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.net.InetAddress;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.p2p.builder.Builder;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.relay.RelayFuture;
import net.tomp2p.relay.RelayManager;
import net.tomp2p.relay.RelayRPC;

public class RelayBuilder
implements Builder {
    private static final RelayFuture FUTURE_RELAY_NO_BOOTSTRAP_ADDRESS = (RelayFuture)new RelayFuture(0).setFailed("No bootrap address has been set");
    private final Peer peer;
    private final RelayRPC relayRPC;
    private BootstrapBuilder bootstrapBuilder;
    private PeerAddress bootstrapAddress;
    private InetAddress bootstrapInetAddress;
    private int port = 7700;
    private int peerMapUpdateInterval = 5;
    private int relaySearchInterval = 60;
    private int failedRelayWaitTime = 60;
    private int minRelays = 2;
    private int maxRelays = 5;

    public RelayBuilder(Peer peer) {
        this.peer = peer;
        this.relayRPC = RelayRPC.setup(peer);
    }

    public RelayBuilder failedRelayWaitTime(int failedRelayWaitTime) {
        this.failedRelayWaitTime = failedRelayWaitTime;
        return this;
    }

    public int failedRelayWaitTime() {
        return this.failedRelayWaitTime;
    }

    public RelayBuilder relaySearchInterval(int relaySearchInterval) {
        this.relaySearchInterval = relaySearchInterval;
        return this;
    }

    public int relaySearchInterval() {
        return this.relaySearchInterval;
    }

    public RelayBuilder minRelays(int minRelays) {
        this.minRelays = minRelays;
        return this;
    }

    public RelayBuilder maxRelays(int maxRelays) {
        this.maxRelays = maxRelays;
        return this;
    }

    public int maxRelays() {
        return this.maxRelays;
    }

    public RelayBuilder peerMapUpdateInterval(int peerMapUpdateInterval) {
        this.peerMapUpdateInterval = peerMapUpdateInterval;
        return this;
    }

    public int peerMapUpdateInterval() {
        return this.peerMapUpdateInterval;
    }

    public RelayBuilder bootstrapAddress(PeerAddress bootrapAddress) {
        this.bootstrapAddress = bootrapAddress;
        return this;
    }

    public RelayBuilder bootstrapInetAddress(InetAddress bootstrapInetAddress) {
        this.bootstrapInetAddress = bootstrapInetAddress;
        return this;
    }

    public RelayBuilder ports(int port) {
        this.port = port;
        return this;
    }

    public RelayBuilder bootstrapBuilder(BootstrapBuilder bootstrapBuilder) {
        this.bootstrapBuilder = bootstrapBuilder;
        return this;
    }

    public RelayFuture start() {
        BootstrapBuilder bootstrapBuilder = null;
        if (this.bootstrapAddress != null) {
            bootstrapBuilder = this.peer.bootstrap().setPeerAddress(this.bootstrapAddress);
        } else if (this.bootstrapInetAddress != null) {
            bootstrapBuilder = this.peer.bootstrap().setInetAddress(this.bootstrapInetAddress).setPorts(this.port);
        } else if (this.bootstrapBuilder != null) {
            bootstrapBuilder = this.bootstrapBuilder;
        } else {
            return FUTURE_RELAY_NO_BOOTSTRAP_ADDRESS;
        }
        RelayManager relayManager = new RelayManager(this.peer, this.relayRPC, bootstrapBuilder, this.maxRelays, this.minRelays, this.peerMapUpdateInterval, this.relaySearchInterval, this.failedRelayWaitTime);
        return relayManager.setupRelays();
    }
}

