/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.tomp2p.storage.AlternativeCompositeByteBuf;

public class DataBuffer {
    private final List<ByteBuf> buffers;
    private int alreadyTransferred = 0;

    public DataBuffer() {
        this.buffers = new ArrayList<ByteBuf>(1);
    }

    public DataBuffer(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public DataBuffer(byte[] buffer, int offset, int length) {
        this.buffers = new ArrayList<ByteBuf>(1);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])buffer);
        this.buffers.add(buf);
    }

    public DataBuffer(ByteBuf buf) {
        this.buffers = new ArrayList<ByteBuf>(1);
        this.buffers.add(buf.slice());
        buf.retain();
    }

    private DataBuffer(List<ByteBuf> buffers) {
        this.buffers = new ArrayList<ByteBuf>(buffers.size());
        for (ByteBuf buf : buffers) {
            this.buffers.add(buf.duplicate());
            buf.retain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer shallowCopy() {
        List<ByteBuf> list = this.buffers;
        synchronized (list) {
            DataBuffer db = new DataBuffer(this.buffers);
            return db;
        }
    }

    public List<ByteBuffer> bufferList() {
        DataBuffer copy = this.shallowCopy();
        ArrayList<ByteBuffer> nioBuffers = new ArrayList<ByteBuffer>(copy.buffers.size());
        for (ByteBuf buf : copy.buffers) {
            for (ByteBuffer bb : buf.nioBuffers()) {
                nioBuffers.add(bb);
            }
        }
        return nioBuffers;
    }

    public ByteBuf toByteBuf() {
        DataBuffer copy = this.shallowCopy();
        return Unpooled.wrappedBuffer((ByteBuf[])copy.buffers.toArray(new ByteBuf[0]));
    }

    public ByteBuf[] toByteBufs() {
        DataBuffer copy = this.shallowCopy();
        return copy.buffers.toArray(new ByteBuf[0]);
    }

    public ByteBuffer[] toByteBuffer() {
        return this.toByteBuf().nioBuffers();
    }

    public void transferTo(AlternativeCompositeByteBuf buf) {
        DataBuffer copy = this.shallowCopy();
        for (ByteBuf buffer : copy.buffers) {
            buf.addComponent(buffer);
            this.alreadyTransferred += buffer.readableBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transferFrom(ByteBuf buf, int remaining) {
        int readable = buf.readableBytes();
        int index = buf.readerIndex();
        int length = Math.min(remaining, readable);
        if (length == 0) {
            return 0;
        }
        if (buf instanceof AlternativeCompositeByteBuf) {
            List<ByteBuf> decoms = ((AlternativeCompositeByteBuf)buf).decompose(index, length);
            for (ByteBuf decom : decoms) {
                List<ByteBuf> list = this.buffers;
                synchronized (list) {
                    this.buffers.add(decom);
                }
                decom.retain();
            }
        } else {
            List<ByteBuf> list = this.buffers;
            synchronized (list) {
                this.buffers.add(buf.slice(index, length));
            }
            buf.retain();
        }
        this.alreadyTransferred += length;
        buf.readerIndex(buf.readerIndex() + length);
        return length;
    }

    public int alreadyTransferred() {
        return this.alreadyTransferred;
    }

    public void resetAlreadyTransferred() {
        this.alreadyTransferred = 0;
    }

    public int hashCode() {
        return this.toByteBuffer().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataBuffer)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DataBuffer m = (DataBuffer)obj;
        return m.toByteBuf().equals((Object)this.toByteBuf());
    }

    protected void finalize() throws Throwable {
        DataBuffer copy = this.shallowCopy();
        for (ByteBuf buf : copy.buffers) {
            buf.release();
        }
    }
}

