/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.BitSet;
import net.tomp2p.connection.DSASignatureFactory;
import net.tomp2p.connection.SignatureFactory;
import net.tomp2p.message.SignatureCodec;
import net.tomp2p.p2p.PeerMaker;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.AlternativeCompositeByteBuf;
import net.tomp2p.storage.DataBuffer;
import net.tomp2p.utils.Timings;
import net.tomp2p.utils.Utils;

public class Data {
    private static final int MAX_BYTE_SIZE = 256;
    private final Type type;
    private final int length;
    private final DataBuffer buffer;
    private boolean basedOnFlag;
    private boolean signed;
    private boolean ttl;
    private boolean flag1;
    private boolean flag2;
    private boolean protectedEntry;
    private boolean publicKeyFlag;
    private SignatureCodec signature;
    private int ttlSeconds = -1;
    private Number160 basedOn = null;
    private PublicKey publicKey;
    private transient PrivateKey privateKey;
    private long validFromMillis;
    private SignatureFactory signatureFactory;
    private Number160 hash;
    private boolean meta;

    public Data(DataBuffer buffer, int length) {
        this.length = length;
        this.type = length < 256 ? Type.SMALL : Type.LARGE;
        this.buffer = buffer;
        this.validFromMillis = Timings.currentTimeMillis();
    }

    public Data(int header, int length) {
        this.publicKeyFlag = Data.hasPublicKey(header);
        this.flag1 = Data.isFlag1(header);
        this.flag2 = Data.isFlag2(header);
        this.basedOnFlag = Data.hasBasedOn(header);
        this.signed = Data.isSigned(header);
        this.ttl = Data.hasTTL(header);
        this.protectedEntry = Data.isProtectedEntry(header);
        this.type = Data.type(header);
        if (this.type == Type.SMALL && length > 255) {
            throw new IllegalArgumentException("Type is not small");
        }
        if (this.type == Type.LARGE && length <= 255) {
            throw new IllegalArgumentException("Type is not large");
        }
        this.length = length;
        this.buffer = new DataBuffer();
        this.validFromMillis = Timings.currentTimeMillis();
    }

    public Data(Object object) throws IOException {
        this(Utils.encodeJavaObject(object));
    }

    public Data(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public Data() {
        this(Utils.EMPTY_BYTE_ARRAY);
    }

    public Data(byte[] buffer, int offest, int length) {
        this.buffer = new DataBuffer(buffer, offest, length);
        this.length = length;
        this.type = length < 256 ? Type.SMALL : Type.LARGE;
        this.validFromMillis = Timings.currentTimeMillis();
    }

    private static boolean hasEnoughDataForPublicKey(ByteBuf buf, int indexPublicKey, int toRead) {
        int len = buf.getUnsignedShort(buf.readerIndex() + indexPublicKey);
        return len <= 0 || buf.readableBytes() >= toRead + len;
    }

    public static Data decodeHeader(ByteBuf buf, SignatureFactory signatureFactory) {
        int len;
        if (buf.readableBytes() < 2) {
            return null;
        }
        short header = buf.getUnsignedByte(buf.readerIndex());
        Type type = Data.type(header);
        int meta1 = (Data.hasTTL(header) ? 4 : 0) + (Data.hasBasedOn(header) ? 20 : 0);
        int meta2 = Data.hasPublicKey(header) ? 2 : 0;
        switch (type) {
            case SMALL: {
                int toReadPublicKey = meta1 + 1 + 1;
                int toRead = toReadPublicKey + meta2;
                if (buf.readableBytes() < toReadPublicKey) {
                    return null;
                }
                if (Data.hasPublicKey(header) && !Data.hasEnoughDataForPublicKey(buf, toReadPublicKey, toRead)) {
                    return null;
                }
                len = buf.skipBytes(1).readUnsignedByte();
                break;
            }
            case LARGE: {
                int toReadPublicKey = meta1 + 1 + 4;
                int toRead = toReadPublicKey + meta2;
                if (buf.readableBytes() < toReadPublicKey) {
                    return null;
                }
                if (Data.hasPublicKey(header) && !Data.hasEnoughDataForPublicKey(buf, toReadPublicKey, toRead)) {
                    return null;
                }
                len = buf.skipBytes(1).readInt();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type");
            }
        }
        Data data = new Data(header, len);
        if (data.ttl) {
            data.ttlSeconds = buf.readInt();
        }
        if (data.basedOnFlag) {
            byte[] me = new byte[20];
            buf.readBytes(me);
            data.basedOn = new Number160(me);
        }
        if (data.publicKeyFlag) {
            data.publicKey = signatureFactory.decodePublicKey(buf);
        }
        return data;
    }

    public boolean decodeBuffer(ByteBuf buf) {
        int already = this.buffer.alreadyTransferred();
        int remaining = this.length() - already;
        if (remaining == 0) {
            return true;
        }
        int transfered = this.buffer.transferFrom(buf, remaining);
        return transfered == remaining;
    }

    public boolean decodeDone(ByteBuf buf, PublicKey publicKey, SignatureFactory signatureFactory) {
        if (this.signed) {
            if (publicKey == PeerMaker.EMPTY_PUBLICKEY) {
                this.publicKey = publicKey;
            }
            this.signature = signatureFactory.signatureCodec();
            if (buf.readableBytes() < this.signature.signatureSize()) {
                return false;
            }
            this.signature.read(buf);
        }
        return true;
    }

    public boolean verify(SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        return this.verify(this.publicKey, signatureFactory);
    }

    public boolean verify(PublicKey publicKey, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        return signatureFactory.verify(publicKey, this.buffer.toByteBuf(), this.signature);
    }

    public void encodeHeader(AlternativeCompositeByteBuf buf, SignatureFactory signatureFactory) {
        int header = this.type.ordinal();
        if (this.publicKeyFlag) {
            header |= 2;
        }
        if (this.flag1) {
            header |= 4;
        }
        if (this.flag1) {
            header |= 8;
        }
        if (this.protectedEntry) {
            header |= 0x10;
        }
        if (this.ttl) {
            header |= 0x20;
        }
        if (this.signed) {
            header |= 0x40;
        }
        if (this.basedOnFlag) {
            header |= 0x80;
        }
        switch (this.type) {
            case SMALL: {
                buf.writeByte(header);
                buf.writeByte(this.length);
                break;
            }
            case LARGE: {
                buf.writeByte(header);
                buf.writeInt(this.length);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown size");
            }
        }
        if (this.ttl) {
            buf.writeInt(this.ttlSeconds);
        }
        if (this.basedOnFlag) {
            buf.writeBytes(this.basedOn.toByteArray());
        }
        if (this.publicKeyFlag) {
            if (this.publicKey == null) {
                buf.writeShort(0);
            } else {
                signatureFactory.encodePublicKey(this.publicKey, buf);
            }
        }
        this.buffer.transferTo(buf);
    }

    public boolean encodeBuffer(AlternativeCompositeByteBuf buf) {
        int already = this.buffer.alreadyTransferred();
        int remaining = this.length() - already;
        if (remaining == 0) {
            return true;
        }
        this.buffer.transferTo(buf);
        return this.buffer.alreadyTransferred() == this.length();
    }

    public void encodeDone(ByteBuf buf, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        if (this.signed) {
            if (this.signature == null && this.privateKey == null) {
                throw new IllegalArgumentException("you need to sign the data object first and add a public key!");
            }
            if (this.privateKey != null) {
                this.signature = signatureFactory.sign(this.privateKey, this.buffer.toByteBuf());
            }
            this.signature.write(buf);
        }
    }

    public ByteBuf buffer() {
        return this.buffer.toByteBuf();
    }

    public Object object() throws ClassNotFoundException, IOException {
        return Utils.decodeJavaObject(this.buffer);
    }

    public long validFromMillis() {
        return this.validFromMillis;
    }

    Data validFromMillis(long validFromMillis) {
        this.validFromMillis = validFromMillis;
        return this;
    }

    public Data sign(KeyPair keyPair, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        if (this.signature == null) {
            this.signed = true;
            this.signature = signatureFactory.sign(keyPair.getPrivate(), this.buffer.toByteBuf());
            this.publicKey = keyPair.getPublic();
            this.publicKeyFlag = true;
        }
        return this;
    }

    public Data sign(PrivateKey privateKey, SignatureFactory signatureFactory) throws InvalidKeyException, SignatureException, IOException {
        if (this.signature == null) {
            this.signed = true;
            this.signature = signatureFactory.sign(privateKey, this.buffer.toByteBuf());
        }
        return this;
    }

    public Data lazySign(KeyPair keyPair) {
        if (this.signature == null) {
            this.signed = true;
            this.privateKey = keyPair.getPrivate();
            this.publicKey = keyPair.getPublic();
            this.publicKeyFlag = true;
        }
        return this;
    }

    public Data lazySign(PrivateKey privateKey) {
        if (this.signature == null) {
            this.signed = true;
            this.privateKey = privateKey;
        }
        return this;
    }

    public int length() {
        return this.length;
    }

    public long expirationMillis() {
        return this.ttlSeconds <= 0 ? Long.MAX_VALUE : this.validFromMillis + (long)this.ttlSeconds * 1000L;
    }

    public int ttlSeconds() {
        return this.ttlSeconds;
    }

    public Data ttlSeconds(int ttlSeconds) {
        this.ttlSeconds = ttlSeconds;
        this.ttl = true;
        return this;
    }

    public Data basedOn(Number160 basedOn) {
        this.basedOn = basedOn;
        this.basedOnFlag = true;
        return this;
    }

    public Number160 basedOn() {
        return this.basedOn;
    }

    public SignatureFactory signatureFactory() {
        if (this.signatureFactory == null) {
            return new DSASignatureFactory();
        }
        return this.signatureFactory;
    }

    public Data signatureFactory(SignatureFactory signatureFactory) {
        this.signatureFactory = signatureFactory;
        return this;
    }

    public boolean isProtectedEntry() {
        return this.protectedEntry;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public Data signed(boolean signed) {
        this.signed = signed;
        return this;
    }

    public Data signed() {
        this.signed = true;
        return this;
    }

    public Data protectedEntry(boolean protectedEntry) {
        this.protectedEntry = protectedEntry;
        this.publicKeyFlag = protectedEntry;
        return this;
    }

    public Data setProtectedEntry() {
        this.protectedEntry = true;
        this.publicKeyFlag = true;
        return this;
    }

    public boolean isFlag1() {
        return this.flag1;
    }

    public Data flag1(boolean flag1) {
        this.flag1 = flag1;
        return this;
    }

    public Data setFlag1() {
        this.flag1 = true;
        return this;
    }

    public boolean isFlag2() {
        return this.flag2;
    }

    public Data flag2(boolean flag2) {
        this.flag2 = flag2;
        return this;
    }

    public Data setFlag2() {
        this.flag2 = true;
        return this;
    }

    public boolean hasPublicKey() {
        return this.publicKeyFlag;
    }

    public Data hasPublicKey(boolean publicKeyFlag) {
        this.publicKeyFlag = publicKeyFlag;
        return this;
    }

    public Data setPublicKey() {
        this.publicKeyFlag = true;
        return this;
    }

    public boolean isMeta() {
        return this.meta;
    }

    public Data meta(boolean meta) {
        this.meta = meta;
        return this;
    }

    public Data setMeta() {
        this.meta = true;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data[l:");
        sb.append(this.length).append(",t:");
        sb.append(this.ttlSeconds()).append(",hasPK:");
        sb.append(this.publicKey != null).append(",h:");
        sb.append(this.signature).append("]");
        return sb.toString();
    }

    public void resetAlreadyTransferred() {
        this.buffer.resetAlreadyTransferred();
    }

    public Data duplicate() {
        Data data = new Data(this.buffer.shallowCopy(), this.length).publicKey(this.publicKey).signature(this.signature).basedOn(this.basedOn).ttlSeconds(this.ttlSeconds);
        data.publicKeyFlag = this.publicKeyFlag;
        data.flag1 = this.flag1;
        data.flag2 = this.flag2;
        data.basedOnFlag = this.basedOnFlag;
        data.signed = this.signed;
        data.ttl = this.ttl;
        data.protectedEntry = this.protectedEntry;
        data.privateKey = this.privateKey;
        data.validFromMillis = this.validFromMillis;
        return data;
    }

    public Data duplicateMeta() {
        Data data = new Data().publicKey(this.publicKey).signature(this.signature).basedOn(this.basedOn).ttlSeconds(this.ttlSeconds);
        data.publicKeyFlag = this.publicKeyFlag;
        data.flag1 = this.flag1;
        data.flag2 = this.flag2;
        data.basedOnFlag = this.basedOnFlag;
        data.signed = this.signed;
        data.ttl = this.ttl;
        data.protectedEntry = this.protectedEntry;
        data.privateKey = this.privateKey;
        data.validFromMillis = this.validFromMillis;
        return data;
    }

    public static Type type(int header) {
        return Type.values()[header & 1];
    }

    private static boolean hasPublicKey(int header) {
        return (header & 2) > 0;
    }

    private static boolean isFlag1(int header) {
        return (header & 4) > 0;
    }

    private static boolean isFlag2(int header) {
        return (header & 8) > 0;
    }

    private static boolean isProtectedEntry(int header) {
        return (header & 0x10) > 0;
    }

    private static boolean hasTTL(int header) {
        return (header & 0x20) > 0;
    }

    private static boolean isSigned(int header) {
        return (header & 0x40) > 0;
    }

    private static boolean hasBasedOn(int header) {
        return (header & 0x80) > 0;
    }

    public byte[] toBytes() {
        ByteBuf buf = this.buffer.toByteBuf();
        byte[] me = new byte[buf.readableBytes()];
        buf.readBytes(me);
        return me;
    }

    public ByteBuffer[] toByteBuffers() {
        return this.buffer.toByteBuffer();
    }

    public PublicKey publicKey() {
        return this.publicKey;
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }

    public Data publicKey(PublicKey publicKey) {
        this.publicKeyFlag = true;
        this.publicKey = publicKey;
        return this;
    }

    public SignatureCodec signature() {
        return this.signature;
    }

    public Data signature(SignatureCodec signature) {
        this.signature = signature;
        return this;
    }

    public int hashCode() {
        BitSet bs = new BitSet(5);
        bs.set(0, this.signed);
        bs.set(1, this.ttl);
        bs.set(2, this.basedOnFlag);
        bs.set(3, this.protectedEntry);
        bs.set(4, this.publicKeyFlag);
        int hashCode = bs.hashCode() ^ this.ttlSeconds ^ this.type.ordinal() ^ this.length;
        if (this.basedOn != null) {
            hashCode ^= this.basedOn.hashCode();
        }
        return hashCode ^ this.buffer.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Data)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Data d = (Data)obj;
        if (d.signed != this.signed || d.ttl != this.ttl || d.basedOnFlag != this.basedOnFlag || d.protectedEntry != this.protectedEntry || d.publicKeyFlag != this.publicKeyFlag) {
            return false;
        }
        if (d.ttlSeconds != this.ttlSeconds || d.type != this.type || d.length != this.length) {
            return false;
        }
        return Utils.equals(this.basedOn, d.basedOn) && Utils.equals(this.signature, d.signature) && d.buffer.equals(this.buffer);
    }

    public Number160 hash() {
        if (this.hash == null) {
            this.hash = Utils.makeSHAHash(this.buffer.toByteBuf());
        }
        return this.hash;
    }

    public static enum Type {
        SMALL,
        LARGE;

    }
}

