/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.List;
import java.util.Map;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerStatatistic;

public class Statistics {
    private static final double MAX = Math.pow(2.0, 160.0);
    private double estimatedNumberOfPeers = 1.0;
    private double avgGap = MAX / 2.0;
    private final List<Map<Number160, PeerStatatistic>> peerMap;
    private final int bagSize;

    public Statistics(List<Map<Number160, PeerStatatistic>> peerMap, int bagSize) {
        this.peerMap = peerMap;
        this.bagSize = bagSize;
    }

    public double getEstimatedNumberOfNodes() {
        double gap = 0.0;
        int gapCount = 0;
        for (int i = 0; i < 160; ++i) {
            Map<Number160, PeerStatatistic> peers = this.peerMap.get(i);
            int numPeers = peers.size();
            if (numPeers > 0 && numPeers < this.bagSize) {
                double currentGap = Math.pow(2.0, i) / (double)numPeers;
                gap += currentGap * (double)numPeers;
                gapCount += numPeers;
                continue;
            }
            if (numPeers != 0 && numPeers != this.bagSize) continue;
        }
        this.avgGap = gap / (double)gapCount;
        this.estimatedNumberOfPeers = MAX / this.avgGap;
        return this.estimatedNumberOfPeers;
    }

    public double getAvgGap() {
        return this.avgGap;
    }
}

