/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.connection.RequestHandler;
import net.tomp2p.connection.Responder;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.KeyCollection;
import net.tomp2p.message.Message;
import net.tomp2p.message.NeighborSet;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number640;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.DispatchHandler;
import net.tomp2p.rpc.RPC;
import net.tomp2p.rpc.SimpleBloomFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeighborRPC
extends DispatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NeighborRPC.class);
    public static final int NEIGHBOR_SIZE = 30;
    public static final int NEIGHBOR_LIMIT = 1000;

    public NeighborRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        this(peerBean, connectionBean, true);
    }

    public NeighborRPC(PeerBean peerBean, ConnectionBean connectionBean, boolean register) {
        super(peerBean, connectionBean);
        if (register) {
            this.register(RPC.Commands.NEIGHBOR.getNr());
        }
    }

    public FutureResponse closeNeighbors(PeerAddress remotePeer, SearchValues searchValues, Message.Type type, ChannelCreator channelCreator, ConnectionConfiguration configuration) {
        Message message = this.createMessage(remotePeer, RPC.Commands.NEIGHBOR.getNr(), type);
        if (!message.isRequest()) {
            throw new IllegalArgumentException("The type must be a request");
        }
        message.setKey(searchValues.locationKey());
        message.setKey(searchValues.domainKey() == null ? Number160.ZERO : searchValues.domainKey());
        if (searchValues.from() != null && searchValues.to() != null) {
            ArrayList<Number640> collection = new ArrayList<Number640>(2);
            collection.add(searchValues.from());
            collection.add(searchValues.to());
            KeyCollection keyCollection = new KeyCollection(collection);
            message.setKeyCollection(keyCollection);
        } else {
            if (searchValues.contentKey() != null) {
                message.setKey(searchValues.contentKey());
            }
            if (searchValues.keyBloomFilter() != null) {
                message.setBloomFilter(searchValues.keyBloomFilter());
            }
            if (searchValues.contentBloomFilter() != null) {
                message.setBloomFilter(searchValues.contentBloomFilter());
            }
        }
        return this.send(message, configuration, channelCreator);
    }

    private FutureResponse send(Message message, ConnectionConfiguration configuration, ChannelCreator channelCreator) {
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandler<FutureResponse> request = new RequestHandler<FutureResponse>(futureResponse, this.peerBean(), this.connectionBean(), configuration);
        if (!configuration.isForceTCP()) {
            return request.sendUDP(channelCreator);
        }
        return request.sendTCP(channelCreator);
    }

    @Override
    public void handleResponse(Message message, PeerConnection peerConnection, boolean sign, Responder responder) throws IOException {
        boolean isDigest;
        if (message.getKeyList().size() < 2) {
            throw new IllegalArgumentException("We need the location and domain key at least");
        }
        if (message.getType() != Message.Type.REQUEST_1 && message.getType() != Message.Type.REQUEST_2 && message.getType() != Message.Type.REQUEST_3 && message.getType() != Message.Type.REQUEST_4 && message.getCommand() == RPC.Commands.NEIGHBOR.getNr()) {
            throw new IllegalArgumentException("Message content is wrong");
        }
        Number160 locationKey = message.getKey(0);
        Number160 domainKey = message.getKey(1);
        SortedSet<PeerAddress> neighbors = this.getNeighbors(locationKey, 30);
        if (neighbors == null) {
            Message response = this.createResponseMessage(message, Message.Type.NOT_FOUND);
            response.setNeighborsSet(new NeighborSet(-1));
            responder.response(response);
            return;
        }
        Message responseMessage = this.createResponseMessage(message, Message.Type.OK);
        LOG.debug("found the following neighbors {}", neighbors);
        NeighborSet neighborSet = new NeighborSet(1000, neighbors);
        responseMessage.setNeighborsSet(neighborSet);
        Number160 contentKey = message.getKey(2);
        SimpleBloomFilter<Number160> keyBloomFilter = message.getBloomFilter(0);
        SimpleBloomFilter<Number160> contentBloomFilter = message.getBloomFilter(1);
        KeyCollection keyCollection = message.getKeyCollection(0);
        boolean bl = isDigest = message.getType() != Message.Type.REQUEST_1;
        if (isDigest) {
            if (message.getType() == Message.Type.REQUEST_2) {
                DigestInfo digestInfo;
                if (contentKey != null && locationKey != null && domainKey != null) {
                    Number320 locationAndDomainKey = new Number320(locationKey, domainKey);
                    Number640 from = new Number640(locationAndDomainKey, contentKey, Number160.ZERO);
                    Number640 to = new Number640(locationAndDomainKey, contentKey, Number160.MAX_VALUE);
                    digestInfo = this.peerBean().storage().digest(from, to, -1, true);
                } else if ((keyBloomFilter != null || contentBloomFilter != null) && locationKey != null && domainKey != null) {
                    Number320 locationAndDomainKey = new Number320(locationKey, domainKey);
                    digestInfo = this.peerBean().storage().digest(locationAndDomainKey, keyBloomFilter, contentBloomFilter, -1, true, true);
                } else if (keyCollection != null && keyCollection.keys().size() == 2) {
                    Iterator<Number640> iterator = keyCollection.keys().iterator();
                    Number640 from = iterator.next();
                    Number640 to = iterator.next();
                    digestInfo = this.peerBean().storage().digest(from, to, -1, true);
                } else if (locationKey != null && domainKey != null) {
                    Number320 locationAndDomainKey = new Number320(locationKey, domainKey);
                    Number640 from = new Number640(locationAndDomainKey, Number160.ZERO, Number160.ZERO);
                    Number640 to = new Number640(locationAndDomainKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
                    digestInfo = this.peerBean().storage().digest(from, to, -1, true);
                } else {
                    LOG.warn("did not search for anything");
                    digestInfo = new DigestInfo();
                }
                responseMessage.setInteger(digestInfo.getSize());
                responseMessage.setKey(digestInfo.getKeyDigest());
                responseMessage.setKey(digestInfo.getContentDigest());
            } else if (message.getType() == Message.Type.REQUEST_3) {
                DigestInfo digestInfo = this.peerBean().trackerStorage().digest(locationKey, domainKey, null);
                if (digestInfo.getSize() == 0) {
                    LOG.debug("No entry found on peer {}", (Object)message.getRecipient());
                }
                responseMessage.setInteger(digestInfo.getSize());
            }
        }
        responder.response(responseMessage);
    }

    protected SortedSet<PeerAddress> getNeighbors(Number160 id, int atLeast) {
        return this.peerBean().peerMap().closePeers(id, atLeast);
    }

    public static class SearchValues {
        private final SimpleBloomFilter<Number160> keyBloomFilter;
        private final SimpleBloomFilter<Number160> contentBloomFilter;
        private final Number160 locationKey;
        private final Number160 domainKey;
        private final Number160 contentKey;
        private final Number640 from;
        private final Number640 to;

        public SearchValues(Number160 locationKey, Number160 domainKey) {
            this.locationKey = locationKey;
            this.domainKey = domainKey;
            this.keyBloomFilter = null;
            this.contentBloomFilter = null;
            this.contentKey = null;
            this.from = null;
            this.to = null;
        }

        public SearchValues(Number160 locationKey, Number160 domainKey, Number160 contentKey) {
            this.locationKey = locationKey;
            this.domainKey = domainKey;
            this.keyBloomFilter = null;
            this.contentBloomFilter = null;
            this.contentKey = contentKey;
            this.from = null;
            this.to = null;
        }

        public SearchValues(Number160 locationKey, Number160 domainKey, Number640 from, Number640 to) {
            this.locationKey = locationKey;
            this.domainKey = domainKey;
            this.keyBloomFilter = null;
            this.contentBloomFilter = null;
            this.contentKey = null;
            this.from = from;
            this.to = to;
        }

        public SearchValues(Number160 locationKey, Number160 domainKey, SimpleBloomFilter<Number160> keyBloomFilter) {
            this.locationKey = locationKey;
            this.domainKey = domainKey;
            this.keyBloomFilter = keyBloomFilter;
            this.contentBloomFilter = null;
            this.contentKey = null;
            this.from = null;
            this.to = null;
        }

        public SearchValues(Number160 locationKey, Number160 domainKey, SimpleBloomFilter<Number160> keyBloomFilter, SimpleBloomFilter<Number160> contentBloomFilter) {
            this.locationKey = locationKey;
            this.domainKey = domainKey;
            this.keyBloomFilter = keyBloomFilter;
            this.contentBloomFilter = contentBloomFilter;
            this.contentKey = null;
            this.from = null;
            this.to = null;
        }

        public Number160 locationKey() {
            return this.locationKey;
        }

        public Number160 domainKey() {
            return this.domainKey;
        }

        public SimpleBloomFilter<Number160> keyBloomFilter() {
            return this.keyBloomFilter;
        }

        public SimpleBloomFilter<Number160> contentBloomFilter() {
            return this.contentBloomFilter;
        }

        public Number160 contentKey() {
            return this.contentKey;
        }

        public Number640 from() {
            return this.from;
        }

        public Number640 to() {
            return this.to;
        }
    }
}

