/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.relay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureDone;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FuturePeerConnection;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.builder.BootstrapBuilder;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerSocketAddress;
import net.tomp2p.relay.ConcurrentCacheSet;
import net.tomp2p.relay.PeerMapUpdateTask;
import net.tomp2p.relay.RelayFuture;
import net.tomp2p.relay.RelayRPC;
import net.tomp2p.relay.SearchRelaysTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayManager {
    static final Logger LOG = LoggerFactory.getLogger(RelayManager.class);
    private final Peer peer;
    private final RelayManager self = this;
    private final RelayRPC relayRPC;
    private final BootstrapBuilder bootstrapBuilder;
    private final int maxRelays;
    private final int minRelays;
    private final int peerMapUpdateInterval;
    private final int relaySearchInterval;
    final Set<PeerAddress> relayAddresses;
    private final Set<PeerAddress> failedRelays;
    private final SearchRelaysTask searchRelaysTask;
    private boolean searchRelaysTaskRunning = false;
    private final PeerMapUpdateTask peerMapUpdateTask;
    private boolean peerMapUpdateTaskRunning = false;
    private final FutureChannelCreator futureChannelCreator;

    public RelayManager(Peer peer, RelayRPC relayRPC, BootstrapBuilder bootstrapBuilder, int maxRelays, int minRelays, int peerMapUpdateInterval, int relaySearchInterval, int failedRelayWaitTime) {
        this.peer = peer;
        this.relayRPC = relayRPC;
        this.bootstrapBuilder = bootstrapBuilder;
        if (maxRelays > 5 || maxRelays < 0) {
            LOG.warn("at most {} relays are allowed.", (Object)5);
            maxRelays = 5;
        }
        this.maxRelays = maxRelays;
        this.minRelays = minRelays;
        this.peerMapUpdateInterval = peerMapUpdateInterval;
        this.relaySearchInterval = relaySearchInterval;
        this.relayAddresses = new CopyOnWriteArraySet<PeerAddress>();
        this.failedRelays = new ConcurrentCacheSet<PeerAddress>(failedRelayWaitTime);
        this.searchRelaysTask = new SearchRelaysTask(this);
        this.peerMapUpdateTask = new PeerMapUpdateTask(relayRPC, bootstrapBuilder, this.relayAddresses);
        this.futureChannelCreator = peer.getConnectionBean().reservation().create(0, maxRelays);
    }

    private void addCloseListener(final PeerConnection peerConnection, BootstrapBuilder bootstrapBuilder) {
        peerConnection.closeFuture().addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

            public void operationComplete(FutureDone<Void> future) throws Exception {
                if (!RelayManager.this.peer.isShutdown()) {
                    PeerAddress failedRelay = peerConnection.remotePeer();
                    LOG.debug("Relay " + failedRelay + " failed, setting up a new relay peer");
                    RelayManager.this.removeRelay(failedRelay);
                    RelayManager.this.failedRelays.add(failedRelay);
                    RelayManager.this.setupRelays();
                }
            }
        });
    }

    private FutureDone<Set<PeerAddress>> getRelayCandidates(BootstrapBuilder bootstrapBuilder) {
        final FutureDone futureDone = new FutureDone();
        FutureBootstrap fb = bootstrapBuilder.start();
        fb.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

            public void operationComplete(FutureBootstrap future) throws Exception {
                if (future.isSuccess()) {
                    LinkedHashSet relayCandidates = new LinkedHashSet(RelayManager.this.peer.getDistributedRouting().peerMap().getAll());
                    for (PeerAddress pa : relayCandidates) {
                        if (!pa.isRelayed()) continue;
                        relayCandidates.remove(pa);
                    }
                    relayCandidates.removeAll(RelayManager.this.relayAddresses);
                    relayCandidates.removeAll(RelayManager.this.failedRelays);
                    LOG.debug("Found {} peers that could act as relays", (Object)relayCandidates.size());
                    if (relayCandidates.isEmpty()) {
                        futureDone.setFailed("No peers that could act as relays were found");
                    }
                    futureDone.setDone(relayCandidates);
                } else {
                    LOG.error("Bootstrapping failed: {}", (Object)future.getFailedReason());
                    futureDone.setFailed((BaseFuture)future);
                }
            }
        });
        return futureDone;
    }

    public Collection<PeerAddress> getRelayAddresses() {
        return this.relayAddresses;
    }

    public int maxRelays() {
        return this.maxRelays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relaySetupLoop(final FutureDone<PeerConnection>[] futures, final Set<PeerAddress> relayCandidates, final ChannelCreator cc, final int numberOfRelays, final FutureDone<Void> futureDone, final BootstrapBuilder bootstrapBuilder) {
        if (numberOfRelays == 0) {
            futureDone.setDone();
            return;
        }
        int active = 0;
        for (int i = 0; i < numberOfRelays; ++i) {
            if (futures[i] == null) {
                PeerAddress candidate = null;
                Set<PeerAddress> set = relayCandidates;
                synchronized (set) {
                    if (!relayCandidates.isEmpty()) {
                        candidate = relayCandidates.iterator().next();
                        relayCandidates.remove(candidate);
                    }
                }
                FuturePeerConnection fpc = this.peer.createPeerConnection(candidate);
                futures[i] = this.relayRPC.setupRelay(cc, fpc);
                if (futures[i] == null) continue;
                ++active;
                continue;
            }
            if (futures[i] == null) continue;
            ++active;
        }
        if (active == 0) {
            this.updatePeerAddress();
            futureDone.setDone();
        }
        FutureForkJoin ffj = new FutureForkJoin(new AtomicReferenceArray<FutureDone<PeerConnection>>(futures));
        ffj.addListener((BaseFutureListener)new BaseFutureAdapter<FutureForkJoin<FutureDone<PeerConnection>>>(){

            public void operationComplete(FutureForkJoin<FutureDone<PeerConnection>> future) throws Exception {
                if (future.isSuccess()) {
                    List reponses = future.getCompleted();
                    for (FutureDone fr : reponses) {
                        PeerConnection peerConnection = (PeerConnection)fr.getObject();
                        PeerAddress relayAddress = peerConnection.remotePeer();
                        if (fr.isSuccess()) {
                            LOG.debug("Adding peer {} as a relay", (Object)relayAddress);
                            RelayManager.this.relayAddresses.add(relayAddress);
                            RelayManager.this.addCloseListener(peerConnection, bootstrapBuilder);
                            RelayManager.this.updatePeerAddress();
                            continue;
                        }
                        LOG.debug("Peer {} denied relay request", (Object)relayAddress);
                        RelayManager.this.failedRelays.add(relayAddress);
                    }
                    RelayManager.this.updatePeerAddress();
                    futureDone.setDone();
                } else {
                    RelayManager.this.relaySetupLoop(futures, relayCandidates, cc, numberOfRelays, (FutureDone<Void>)futureDone, bootstrapBuilder);
                }
            }
        });
    }

    private void removeRelay(PeerAddress pa) {
        this.relayAddresses.remove(pa);
        if (this.relayAddresses.isEmpty()) {
            this.peerMapUpdateTask.cancel();
            this.peerMapUpdateTaskRunning = false;
        }
        this.updatePeerAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureDone<Void> setupPeerConnections(ChannelCreator cc, BootstrapBuilder bootstrapBuilder, Set<PeerAddress> relayCandidates) {
        RelayManager relayManager = this;
        synchronized (relayManager) {
            int nrOfRelays;
            FutureDone fd = new FutureDone();
            if (this.relayAddresses.size() + relayCandidates.size() < this.minRelays) {
                this.startRelaySearchTask();
            }
            if ((nrOfRelays = Math.min(this.maxRelays - this.relayAddresses.size(), relayCandidates.size())) > 0) {
                FutureDone[] relayConnectionFutures = new FutureDone[nrOfRelays];
                this.relaySetupLoop(relayConnectionFutures, relayCandidates, cc, nrOfRelays, (FutureDone<Void>)fd, bootstrapBuilder);
            } else {
                fd.setFailed("done");
            }
            return fd;
        }
    }

    public RelayFuture setupRelays() {
        final RelayFuture rf = new RelayFuture(this.minRelays);
        rf.addListener((BaseFutureListener)new BaseFutureAdapter<RelayFuture>(){

            public void operationComplete(RelayFuture future) throws Exception {
                if (future.isSuccess()) {
                    RelayManager.this.startPeerMapUpdateTask();
                    RelayManager.this.searchRelaysTask.cancel();
                } else {
                    RelayManager.this.startRelaySearchTask();
                }
            }
        });
        if (!this.peer.getPeerAddress().isRelayed()) {
            PeerAddress pa = this.peer.getPeerBean().serverPeerAddress().changeFirewalledTCP(true).changeFirewalledUDP(true);
            this.peer.getPeerBean().serverPeerAddress(pa);
        }
        this.futureChannelCreator.addListener((BaseFutureListener)new BaseFutureAdapter<FutureChannelCreator>(){

            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    final ChannelCreator cc = future.getChannelCreator();
                    FutureDone fd = RelayManager.this.getRelayCandidates(RelayManager.this.bootstrapBuilder);
                    fd.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Set<PeerAddress>>>(){

                        public void operationComplete(FutureDone<Set<PeerAddress>> future) throws Exception {
                            if (future.isSuccess()) {
                                FutureDone fd = RelayManager.this.setupPeerConnections(cc, RelayManager.this.bootstrapBuilder, (Set)future.getObject());
                                fd.addListener((BaseFutureListener)new BaseFutureAdapter<FutureDone<Void>>(){

                                    public void operationComplete(FutureDone<Void> future) throws Exception {
                                        if (future.isSuccess()) {
                                            FutureBootstrap fb = RelayManager.this.bootstrapBuilder.start();
                                            fb.addListener((BaseFutureListener)new BaseFutureAdapter<FutureBootstrap>(){

                                                public void operationComplete(FutureBootstrap future) throws Exception {
                                                    if (future.isSuccess()) {
                                                        rf.relayManager(RelayManager.this.self);
                                                    } else {
                                                        rf.setFailed((BaseFuture)future);
                                                    }
                                                }
                                            });
                                        } else {
                                            rf.setFailed((BaseFuture)future);
                                        }
                                    }
                                });
                            } else {
                                rf.setFailed((BaseFuture)future);
                            }
                        }
                    });
                } else {
                    rf.setFailed((BaseFuture)future);
                }
            }
        });
        return rf;
    }

    private void startPeerMapUpdateTask() {
        if (!this.peerMapUpdateTaskRunning) {
            this.peer.getConnectionBean().timer().scheduleAtFixedRate(this.peerMapUpdateTask, 0L, this.peerMapUpdateInterval, TimeUnit.SECONDS);
            this.peerMapUpdateTaskRunning = true;
        }
    }

    private void startRelaySearchTask() {
        if (!this.searchRelaysTaskRunning) {
            this.peer.getConnectionBean().timer().scheduleAtFixedRate(this.searchRelaysTask, this.relaySearchInterval, this.relaySearchInterval, TimeUnit.SECONDS);
        }
        this.searchRelaysTaskRunning = true;
    }

    private void updatePeerAddress() {
        boolean hasRelays = !this.relayAddresses.isEmpty();
        ArrayList<PeerSocketAddress> socketAddresses = new ArrayList<PeerSocketAddress>(this.relayAddresses.size());
        for (PeerAddress pa : this.relayAddresses) {
            socketAddresses.add(new PeerSocketAddress(pa.getInetAddress(), pa.tcpPort(), pa.udpPort()));
        }
        PeerAddress newAddress = this.peer.getPeerAddress().changeFirewalledTCP(!hasRelays).changeFirewalledUDP(!hasRelays).changeRelayed(hasRelays).changePeerSocketAddresses(socketAddresses);
        this.peer.getPeerBean().serverPeerAddress(newAddress);
    }
}

