/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.examples;

import java.net.InetAddress;
import java.util.Random;
import net.tomp2p.connection.Bindings;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.p2p.Peer;
import net.tomp2p.p2p.PeerMaker;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;

public class ExampleNAT {
    public void startServer() throws Exception {
        Peer peer = null;
        try {
            Random r = new Random(42L);
            Bindings b = new Bindings().addInterface("eth0");
            peer = new PeerMaker(new Number160(r)).bindings(b).ports(4000).makeAndListen();
            System.out.println("peer started.");
            while (true) {
                for (PeerAddress pa : peer.getPeerBean().peerMap().getAll()) {
                    BaseFuture future = peer.ping().setPeerAddress(pa).setTcpPing().start();
                    if (future.isSuccess()) {
                        System.out.println("peer online (TCP):" + pa);
                    } else {
                        System.out.println("offline " + pa);
                    }
                    future = peer.ping().setPeerAddress(pa).start();
                    if (future.isSuccess()) {
                        System.out.println("peer online (UDP):" + pa);
                        continue;
                    }
                    System.out.println("offline " + pa);
                }
                Thread.sleep(1500L);
            }
        }
        catch (Throwable throwable) {
            peer.shutdown();
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            ExampleNAT.startClientNAT(args[0]);
        } else {
            ExampleNAT t = new ExampleNAT();
            t.startServer();
        }
    }

    public static void startClientNAT(String ip) throws Exception {
        Random r = new Random(43L);
        Peer peer = new PeerMaker(new Number160(r)).ports(4000).setBehindFirewall().makeAndListen();
        PeerAddress pa = new PeerAddress(Number160.ZERO, InetAddress.getByName(ip), 4000, 4000);
        FutureDiscover fd = peer.discover().peerAddress(pa).start();
        fd.awaitUninterruptibly();
        if (fd.isSuccess()) {
            System.out.println("found that my outside address is " + fd.getPeerAddress());
        } else {
            System.out.println("failed " + fd.getFailedReason());
        }
        peer.shutdown();
    }
}

